<?php //  ۞ // text {  encoding:utf-8 ; bom:no ; linebreaks:unix ; tabs:4sp  ; }
												$sess_view['version'] = '0.7.2';

/*
	View php sessions

	Keep this in a protected area - contains no auth of its own.
	(for public access - see the $sess_view['public_view'] preference (below))

	Usage:

		Simply load in a web browser. So long as you have access to the php
		session folder - hint, set that to be inside your web space (in
		.htaccess, etc.)..

		php_value session.save_path /var/www/mydomain.com/db/sessions

		Then you can view and edit php sessions.

	Have fun!

	;o) Cor

	(c) copyright corz.org 2007->today

*/


// prefs..
//

// location of "Fecker", a (very simple) online file editor..
//
$sess_view['fecker_location'] = '/tools/fecker.php';
//
// You can use your own online editor, though remember to alter the $_GET
// parameters to suit your needs (inside the script, below)


// session file name prefix
// so we can omit other files from the drop-down menu, and insert  into useful places. Unless you know otherwise, it is
// probably 'sess_'
$sess_view['session_prefix'] = 'sess_';

// these should be fine as-is..
$sess_view['site_root'] = $_SERVER['DOCUMENT_ROOT'];

// this is only to load the admin session time, if applicable..
$sess_view['do_authentication'] = true;

// in which case, we need to..

// load pajamas authentication.
// remember to set the name to whatever you use on-site. here, it's "corz.org"
//
if ($sess_view['do_authentication']) {
	include $sess_view['site_root'].'/blog/inc/pajamas/pajamas.php';
	$auth = new pajamas($_SERVER['HTTP_HOST']);
}


// this should be fine, left as-is. It's the FULL path to the session folder,
// from the root of your SERVER, e.g. "/var/www/vhosts/mysite/httpdocs/log/db/sessions
// this gets it automatically from the local php prefs..
//
$sess_view['session_dir'] = session_save_path();


// This is the same path, except from your SITE root.
//
// NOTE! If either your site or session folder are referred to by symlinks, you
// will need to edit this to match the path of your session folder from the root
// of your site, with no trailing slash. e.g. $sess_view['site_session_dir'] = '/db/sessions';
// However, this should work it out automatically..
//
$sess_view['site_session_dir'] = str_replace($_SERVER['DOCUMENT_ROOT'], '', $sess_view['session_dir']);


// This is handy if the session viewer is publicly accessible (guests can view their own session data). Also, if you
// have lots of current sessions and you generally only view your own session data, it will load more quickly (no drop-
// down).
//
$sess_view['public_view'] = true;



// slightly compacted session view, handy for big sessions..
$sess_view['compact_view'] = true;



/*
	end prefs	*/



// how we begin..
//
$sess_start = 0;
$sess_msg = '';
$sess_show_errors = false;
$sess_id = '';

// start the session!
session_start();


// which session to view?..

// default "public" view session (your own)
$sess_id = $sess_view['session_prefix'].session_id();

if (!empty($_REQUEST['session_file'])) {
	if ($_GET['session_file'] == 'my') {
		$sess_id = $sess_view['session_prefix'].session_id();
	} else {
		$sess_id = $_REQUEST['session_file'];
	}
}

$session_file = $sess_view['session_dir'].'/'.$sess_id;


if (!empty($_REQUEST['start'])) $sess_start = $_REQUEST['start'];
if ($sess_start < 0 ) $sess_start = 0;

if ($sess_view['do_authentication']) {
	$remaining = $auth->remainingTime();
	$mins = floor($remaining / 60);
	$secs = round($remaining - ($mins*60));
	if ($mins <= 0) {
		$sess_showtime = '[not logged in]';
	} else {
		$sess_showtime = $mins.'m '.$secs.'s';
	}
}


// standard doctype for corz.org (usually included)
echo '<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="initial-scale=1.0, width=device-width" />
<title>corz session viewer [v',$sess_view['version'],'] for ',$_SERVER['HTTP_HOST'],'..</title>
<meta name="description" content="corz session viewer for ',$_SERVER['HTTP_HOST'],'.. see the data inside session files.. by corz.org" />
<style media="screen">
body {
	min-width: 320px;
	max-width: 920px;
	width: 100%;
	margin: 0 auto;
	font-size: 1em;
	font-family: Tahoma, "Trebuchet MS", Trebuchet, "Lucida Grande", Verdana, sans-serif;
}
#session-selector {
	position: absolute;
	top: 8px;
	left: 8px;
	padding: 0;
	margin: 0;
	font-weight: 600;
	max-width: 47%;
}
#load-my-session {
	position: fixed;
	right: 8px;
	top: 8px;
	font-size: 1.5em;
	max-width: 47%;
	text-align: right;
}
#remaining { font-size: small; }
#session-view {
	margin: 6em 2em 2em;
	font-size: 80%;
}
pre { white-space: pre-wrap; }
#raw-view { width: 100%; }
#session-textarea {
	font-size: 80%;
	width: 100%;
}
@media screen and (max-width: 920px) {
	html { font-size: 90%; }
	#session-selector, #load-my-session {
		position: relative;
		left: auto;
		right: auto;
		top: auto;
		font-size: 80%;
		max-width: 95%;
		margin: 0 1em;
	}
	#session-view { margin: 1em; }
	#raw-view {
		margin: 0 auto;
		width: 96%;
	}
}
</style>
</head>
<body>';


// title with session edit link..		[top-left]
if (!$sess_view['public_view']) {
echo '
<form method="get" action="',$_SERVER['SCRIPT_NAME'],'">
<div id="session-selector">
	session: ',$sess_id,'.. &nbsp; ';
	echo '[<a href="',$sess_view['fecker_location'],'?page=',$sess_view['site_session_dir'],'/',$sess_id,
	'" title="Edit this session file" id="link-fecker-session-edit" onclick="window.open(this.href); return false;">Edit</a>]';
	// create the drop-down menu of all available session files..
	echo '
	<br />
	<select name="session_file">';
	$filenames = return_dir($sess_view['session_dir']);
	asort($filenames);
	foreach ($filenames as $this_file) {
		$selected = '';
		if (strstr($this_file, $sess_view['session_prefix'])) {
			if ($this_file == $_REQUEST['session_file']) $selected = ' selected';
			echo '
		<option value="',$this_file,'"',$selected,'>',$this_file,'</option>';
		}
	}
	echo '
	</select>
	<input type="submit" value="Load" title="get it fresh" />
</div>
</form>';
}

// form to load user's session..	[top-right]
echo '
<form method="get" action="',$_SERVER['SCRIPT_NAME'],'">
<div id="load-my-session">
	<input type="hidden" name="session_file" value="',$sess_view['session_prefix'],session_id(),'"/>
	My Session: ',session_id();

	if (!$sess_view['public_view']) {
		echo '
	<div id="remaining">&nbsp;Remaining session time: ',$sess_showtime,'</div>';
	} else {
		echo '<br />';
	}
	echo '
	<input type="submit" value="Load" title="Get MY Session!" />
</div>
</form>
<div id="session-view">
<pre>';
$session_raw = '';
if (file_exists($session_file)) {
	$search = array('        ', '>', "\n (", ' )');
	if ( $sess_view['compact_view'] ) {
		$replace = array(' ', '&gt;', " (", '    )'); // compact view!
	} else {
		$replace = array(' ', '&gt;', " (\n", "\n".'    )');
	}
	$session_raw = file_get_contents($session_file);
	$session_array = unserialize_session_data($session_raw);
	echo str_replace($search, $replace, print_r($session_array, true));
} else {
	echo 'session file';
	if (!$sess_view['public_view']) {
		echo ' [',$session_file,']';
	}
	echo ' is missing';
}
echo '
</pre>
</div>
<form id="theform" method="post" action="',$_SERVER['SCRIPT_NAME'],'">
<div id="raw-view">
	<label for="session-textarea"><strong>raw view: </strong></label><br />
	<textarea name="editspace" rows="12" cols="100" id="session-textarea">',$session_raw,'</textarea>
</div>
</form>
</body>
</html>';


/*
   fin!
		*/




/*
return a list of files in a folder
as an array of file names..
							  */
function return_dir($sess_view_dir) {
	if ($the_session = opendir($sess_view_dir)) {
		$q = 0;
		while (false !== ($file = readdir($the_session))) $itemz[] = $file;
		// now we have all the files in one array..
		closedir($the_session);
		if (!empty($itemz)) { return $itemz; } else { return false; }
	} else {
		// couldn't open the dir..
		return false;
	}
}

function unserialize_session_data( $serialized_string ) {
    $variables = array();
    $a = preg_split( "/(\w+)\|/", $serialized_string, -1, PREG_SPLIT_NO_EMPTY | PREG_SPLIT_DELIM_CAPTURE );
    for( $i = 0; $i < count( $a ); $i = $i+2 ) {
        $variables[$a[$i]] = unserialize( $a[$i+1] );
    }
    return( $variables );
}
?>