<?php

/*
		v0.3.6

		links.php - corzoogle-powered robot food generator

		produces a list of all the links on a site, in no particular order
		useful for search engines robots and other creepy-crawlers.

		now has "text mode" where it will embed the links into a text file
		of your choosing. this is a nifty way to do it, something for everyone.

		rename to "links.php" and chuck in the root of your site, let
		the robots chew. includes valid corzblog links automatically, too.
		put a link somewhere on your front page, mine is a hidden image map,
		hover the mouse around the left of my printer icon, you'll see.

		you can put this inside folders, too, providing links for only that area.

		I ripped most of the code straight out of the corzoogle engine..

		http://corz.org/corzoogle.php

		;o)
		(or

		© 2004 -> corz.org
*/

/*
	files to create links from
	I don't create links for downloads, zips, etc.
	bots don't need to access those.
*/
$lm_extentions = array(
	'.html',
	'.txt',
	'.nfo',
	'.php',
	'.phps',
	'.blog',
	'.c',
	'.exe',
	'.comment',
	'.jpg',
	'.png',
	'.gif',
	'.src',
	'.term',
	'.au3',
	'.mp3',
	'.m3u',
	'.sh',
	'.doc',
	'.pdf',
	'.out');

/*
	IGNORE folders.
	these will NOT be parsed by the link generator. one '/inc/' covers all
	if you need to be more specific, do: "/foo/inc/"
*/
$lm_ignore = array(
	'/_arc/',
	'/err/',
	'/inc/',
	'/dev/php/',
	'/corz/tools/',
	'/hag/',
	'/cvs/',
	'/tracker/',
	'/includes/',
	'/cgi-bin/',
	'/public/images/smileys/',
	'/public/icons/',
	'/private/');

/*
	special links

	these are links that, for one reason or another, you would like to
	put manually on the page. a generated gateway link of some kind,
	for instance, like http://corz.org/engine is. things that wouldn't
	be picked up searching through a filesystem, yet you would like
	to include.

	links in single quotes, seperated by commas..
	$lm_special_links = array ('/engine','/source/');

	of course, your *hot* new pages, should go here, too, the search
	engines will pick them up as soon as possible. these appear first.
*/
$lm_special_links = array
	(
	'/bbtags',
	'/windows/software/checksum/checksum.php',
	'/windows/software/ffe/',
	'/windows/software/clock/',
	'/windows/software/color-pickin-chooser/',
	'/windows/dev/AutoIt/AutoIt-setup-for-EditPlus.php',
	'/engine',
	'/windows/',
	'/blog/',
	'/blog/inc/cbparser.php'
	);


/*
	text mode?

	false:	produces a plain list of all the links.
			simple, neat and effective.

	true: 	will "linkify" a text file.
			this is best, mixes the links into a pre-selected text document. this
			is a real page of text, except with your site links all through it.
			a good place to put some text that you'd like folks to read, too.
			en-joy..

			http://corz.org/links.php
*/
$lm_text_mode = true;


/*	the text file..
	(location from site root)
*/
$lm_text_file = '/inc/txt/text.txt';


// for the title..
$lm_links_domain = $_SERVER['HTTP_HOST'];


// embed in some other page?
$lm_embed_in_page = false;


// transformations..
/*
	if you have some script generated pages, you can perform transformations on the included (real) documents
	I'll use corzblog as an example, but this will work for any generated page that uses flat-file content.
*/

//$lm_match_ext = '.blog';
//$lm_trans_title = 'corzblog archive: ';
//$lm_trans_path = '/blog/'; // I use (mod_rewritten) flat-inks
//$lm_trans_add = ''; // any string you wish to add on the end of the link, eg. '&amp;foo=bar'

// so, for example; when the links machine finds /some/path/file.blog it converts it into..
// http://corz.org/blog/index.php?archive=file
// or.. http://corz.org/blog/2006-May or whatevr 


// in the real world, you are better to use .htaccess and mod_rewrite for this stuff.

/*	end of preferences
*/


// init..
$lm_path = array('./');
$lm_level = 0; $lm_count = 0;
$lm_links_array = array();
if (!$lm_embed_in_page) {
do_header();
}
echo '
<h1>generated links for '.$lm_links_domain.'..</h1>';
if ($lm_text_mode) echo '<h3 class="sub"><small>(fine text mode)</small></h3>';

if (is_array($lm_special_links)) {
	foreach($lm_special_links as $lm_link) {
		array_push($lm_links_array, '<a href="'.$lm_link.'" title="'.
			$lm_link.'" onclick="window.open(this.href); return false;">'.$lm_link.'</a>');
	}
	$lm_count += count($lm_links_array);
}
spider();
do_result('out');
echo $lm_links_page;

// leave this in, ta.
echo '
<a href="http://corz.org/engine?source=menu&amp;section=php/seo%20scripts"
title="get the get the source for this link generator"><small>get the source for this generator</small></a>';

// my footer, use yer own..
if (stristr($lm_links_domain, 'corz')) @include ($_SERVER['DOCUMENT_ROOT'].'/inc/footerx.php');

if (!$lm_embed_in_page) {
	echo '
</div>
</div>
</body>
</html>
';
}

/*
function:spider()
for more comments, see corzoogle.php
*/
function spider() {
global $lm_count, $lm_extentions, $lm_ignore, $lm_level, $lm_path;

	$lm_search_path='';
	for ($lm_search=0; $lm_search <= $lm_level; $lm_search++) {
		$lm_search_path .= $lm_path[$lm_search];
		$lm_search_path = str_replace($lm_ignore, '', $lm_search_path);
	}

	$lm_dirhandle = opendir($lm_search_path);
	while ($lm_file = readdir($lm_dirhandle)) {

	if ($lm_file[0] != '.') {

		if (is_file($lm_search_path.$lm_file)) {
			$lm_fext = substr($lm_file,strrpos($lm_file,'.'));

			$lm_itsname = basename($lm_file);
			if (in_array($lm_fext, $lm_extentions)) {
				do_result($lm_search_path.$lm_file);
				$lm_count += 1;
			}
		}
		elseif (is_dir($lm_search_path.$lm_file)) {
			$lm_path[++$lm_level] = ($lm_file.'/');
			spider();
			$lm_level--;
			}
		}
	}

}/*	end function:spider()
*/


/*
function do_result()
filling up the $lm_links_array, and making the $lm_links_page
							 */
function do_result($lm_file) {
global $lm_links_page, $lm_links_array, $lm_match_ext, $lm_text_mode, $lm_trans_add, $lm_trans_path, $lm_trans_title;

if (isset($do_debug) and $do_debug > 0) { debug('$lm_special_links: '."\t".print_r($lm_special_links, true)."\n\n"); }//:debug:
	$lm_pre_title = '';
	if ($lm_file == 'out') {
		foreach($lm_links_array as $lm_link) {
			$lm_links_page .= $lm_link;
		}
	if ($lm_text_mode) $lm_links_page = embed_in_text();

	} else {
		$lm_title = basename($lm_file);
		if (!$lm_text_mode) $lm_pre_title .=  '<br />';

		// transformations..
		if (substr($lm_title, -5) == $lm_match_ext) {
			$lm_pre_title .= $lm_trans_title;
			$lm_title = str_replace($lm_match_ext, '', $lm_title);
			$lm_file = $lm_trans_path.$lm_title.$lm_trans_add;
		}

		// replace *certain* characters with entities..
		$old_ent = array(' ','&');
		$new_ent = array('%20', '&amp;');
		array_push($lm_links_array,'<a href="'.str_replace($old_ent, $new_ent, $lm_file).'" title="'.
			str_replace($old_ent, $new_ent, $lm_title).'" onclick="window.open(this.href); return false;">'.$lm_pre_title.$lm_title.'</a>');
	}
}/*	end function do_result()
*/


/*
function embed_in_text()
clean, simple	*/

function embed_in_text() {
global $lm_count, $lm_links_array, $lm_text_file;

	$lm_embedded_page = '';

	$lm_chunk = implode('', file($_SERVER['DOCUMENT_ROOT'].$lm_text_file));
	$lm_chunk_size = (strlen($lm_chunk) / $lm_count);
	$lm_text_chunks = array();

	while (strlen($lm_chunk) > 0) {
		array_push($lm_text_chunks, substr($lm_chunk,0,$lm_chunk_size));
		$lm_chunk = substr($lm_chunk,$lm_chunk_size);
	}

	$lm_i=0;
	foreach($lm_links_array as $lm_link) {
		$lm_text_chunks[$lm_i] = preg_replace("/\">(.*)<\/a>/i","\">$lm_text_chunks[$lm_i]</a>",$lm_link);
		$lm_i++;
	}

	// we do it in two stages, to catch the extra text in the file
	foreach($lm_text_chunks as $lm_text_line) {
		$lm_embedded_page .= $lm_text_line;
	}

	$lm_embedded_page = str_replace("\n","<br />\n",$lm_embedded_page); // get back the linebreaks
	$lm_embedded_page = str_replace("\t",'&nbsp;&nbsp;&nbsp;&nbsp;',$lm_embedded_page); // and tabs
	return $lm_embedded_page;

}/*	end function embed_in_text()
*/


/*
function do_header()	*/

function do_header() {
global $lm_links_domain;
	// initialize..
	if (stristr(@$_SERVER['HTTP_ACCEPT'],'application/xhtml+xml')) {
		$lm_doc_content = 'application/xhtml+xml';
	} else {
		// read: "Internet Explorer"
		$lm_doc_content = 'text/html';
	}
	echo '<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
	"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<meta http-equiv="content-type" content="',$lm_doc_content,'; charset=utf-8" />
<title>generated links for ',$lm_links_domain,' (robot food)</title>
<meta name="description" content="corzoogle-powered link machine generator LINKS links robot food yum corz.org" />
<meta name="robots" content="all" />
<meta name="generator" content="corzoogle engine" />
<meta name="author" content="corz.org" />
<meta name="keywords" content="corzoogle engine powered link generator corz.org .. data packets with real bits" />
<style type="text/css">
/*<![CDATA[*/ 
@import "/inc/css/main.css"; 
@import "/inc/css/site.css"; 
@import "/inc/css/footer.css";
/*]]>*/
</style>
</head>
<body>
<div class="container">
	<div class="genlinks content">';
}/*	end function do_header()
*/

?>