﻿<?php //  ۞ // text {  encoding:utf-8 ; bom:no ; linebreaks:unix ; tabs:4sp  ; }

/*
	Remove duplicate entries from a list file or posted list data..

	Cor @ corz.org, 2014.

*/

global $is_admin, $result;
global $raw_data, $data;
global $display_file, $file;


// File operations only when logged in as admin..
//

// UNIX Linebreaks in saved list files
$line_break = "\n";

// rudimentary one-time backup, in case of boo-boos..
$backup_list = $_SERVER['DOCUMENT_ROOT'].'/inc/log/backup_list';


/*	I use Pajamas for site logins..
*/
$do_authentication = true;

// I include my pajamas code and prefs from in here..
// see elsewhere for full pajamas implementations.
require_once $_SERVER['DOCUMENT_ROOT'].'/inc/init.php';

// check pajamas auth status..
if ($auth->auth_user()) {
	$is_admin = true;
}

//
// You could of course set $is_admin to true/false by some other auth method.
// If running at home/mirror/somewhere secure, just set $is_admin = true; now.


// For public settings, you may want to limit a user's usage..
//

$limit_use = 10;
session_start();
$title_add = '';

if (isset($_POST['raw_list']) and trim($_POST['raw_list'])) {

	if ($is_admin or !isset($_SESSION['limit_use'])) {
		$_SESSION['limit_use'] = 0;
		if (!$is_admin) { $title_add = ' &nbsp;['.$limit_use.' uses left]'; }
	} else {
		$_SESSION['limit_use']++;
		$title_add = ' &nbsp;['.($limit_use-$_SESSION['limit_use']).' uses left]';
		if ($_SESSION['limit_use'] == ($limit_use-2)) {
			// Only one 2 uses left!
			$title_add = ' &nbsp;[2 shots left!]';
		}
		if ($_SESSION['limit_use'] == ($limit_use-1)) {
			// Final shot!
			$title_add = ' &nbsp;[FINAL USE!]';
		}
	}
	if ($_SESSION['limit_use'] > $limit_use) {
		// NO MORE! END PAGE!
		die('<!DOCTYPE html><html lang="en"><head><title>Download this tool and use at home!</title></head><body>Why not download this tool and use at home!<br />
<a href="./" title="Click here to go to the menu" id="link-menu-over-use">menu</a></body></html>');
	}
}


// Spit out basic page..
//

echo '<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="initial-scale=1.0, width=device-width" />
<title>A PHP Tool to Remove Duplicate List Entries',$title_add,'</title>
<meta name="description" content="simple gui for you to enter a list, from which you can remove duplicate entries" />
<link rel="stylesheet" href="/inc/css/tools.css" type="text/css" media="screen" />
<style media="screen">
/*<![CDATA[*/
<!--
.content {margin-top: 10px; }
.form, input, textarea { margin-bottom: 1rem; width: 100%; }
.reset { float: right; }
//-->
/*]]>*/
</style>
</head>
<body>
<div class="content">';


echo '
<a href="',$_SERVER['SCRIPT_NAME'],'" class="reset"><strong>[reset]</strong></a>';


// check for POSTed file names..
//
if ($is_admin) {
	if (isset($_POST['file']) and trim($_POST['file'])) {
		$display_file = $_POST['file'];
		$file = $_SERVER['DOCUMENT_ROOT'].$display_file;
	}

	if ($file) {
		$result = remove_duplicates($file, '', $line_break);
		echo '<h4>',$result,$title_add,'</h4>';
	}
}

// POSTed raw list data..
if (isset($_POST['raw_list']) and trim($_POST['raw_list'])) {
	$result = remove_duplicates('', $_POST['raw_list']);
	echo '<h4>',$result,$title_add,'</h4>';
}

$instructions = '';
if (!$result) {
	if ($is_admin) {
		$instructions .= ' File Location or ';
	}
	echo '<h4>Enter your ',$instructions,'list data &amp; click "Remove Duplicates"',$title_add,'</h4>';
}


if ($is_admin) {
	echo '
<form method="post" action="',$_SERVER['SCRIPT_NAME'],'">
<div class="form">
	<label for="file" title="Input the full site path, e.g. /data/lists/list.txt">Input file path (from site root): </label><br />
	<input id="file" type="text" id="file" name="file" value="',$display_file,'" size="50" />
	<input type="submit" id="do-it-loc" value="Remove Duplicates" title="do it!" />
</div>
</form>';
}

echo '
<form method="post" action="',$_SERVER['SCRIPT_NAME'],'">
<div class="form">
	<label for="raw_list" title="Paste a raw list into the textarea">Enter a raw list..<br />
	<textarea name="raw_list" id="raw_list" rows="30" style="width:100%;min-height:70%" rows="80" cols="50" onclick="this.focus();this.select()" >',$raw_data,'</textarea><br />
	<input type="submit" id="do-it-raw" value="Remove Duplicates" title="do it!"  />
</div>
</form>
</div>
</body></html>';




// remove duplicate entries from a list file..
//
function remove_duplicates($file, $raw_input_data='', $lb="\n") {

  global $raw_data, $data, $backup_list;

	if ($raw_input_data) {
		$list_array = explode("\r\n", trim($raw_input_data));

	} elseif ($file) {
		if (!file_exists($file)) { return basename($file).' => Does Not Exist!'; }
		// read file into array..
		copy($file, $backup_list);
		$list_array = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
		if (!is_array($list_array)) { return 'Error reading '.basename($file).' into array!'; }
	}

	// get initial line-count..
	$original_lines = count($list_array);

	// remove duplicates..
	$list_array = array_unique($list_array);

	// get final line-count..
	$final_lines = count($list_array);


	if ($original_lines == $final_lines) {
		// set textarea data to original data..
		if ($raw_input_data) { $raw_data = $raw_input_data; }
		return 'No Duplicates in List!';
	}

	// re-create list file into string..
	foreach ($list_array as $line) {
		$data .= $line.$lb;
	}

	// set textarea data to updated list..
	if ($raw_input_data) { $raw_data = $data; }

	// write back to the file (wipe first: 'wb')..
	$ret_str = '';

	if (isset($_POST['file'])) {
		if (is_writable($file)) {
			$fp = fopen($file, 'wb');
			$lock = flock($fp, LOCK_EX);
			if ($lock) {
				if (fwrite($fp, $data)) {
					$ret_str .= ' OK!';
				}
				flock ($fp, LOCK_UN);
			} else {
				return $ret_str.' Could Not Lock File!';
			}
			fclose($fp);
		}
		$ret_str .= ' ';
	}


	return basename($file).$ret_str.' Duplicates Removed OK! &nbsp;[read: '.$original_lines.' items, wrote: '.$final_lines.' items]';
}

?>