<?php //if ?image=*something* isn't set, there's no point continuing..
if (!isset($_GET['image'])) { die("To err is human, human!"); }

/*
	Remote Watermark Script.	v0.1

	If you are hosting your images on a different server or with an image 
	service, you may want to..
	
		Hide the fact that the images are hosted elsewhere

		Add a watermark to the image before the browser gets it.

	So instead of linking to the remote site, we pipe the requests through 
	our /own/ domain, to some "image handler" script like this one.

	To use:

	*	Create your CMS/pages so that all URI references to 

			http://OtherDomain.com/<path>/<to>/<image> 

		point instead to..

			http://yoursite.com/hosted/<path>/<to>/<image>

		For example:

			<img id="MyImage" src="/hosted/path/to/some/image.jpg" alt="image">


	*	In .htaccess, rewrite all image links (to '/hosted/something') to your 
		"handler" script, something like this..

			RewriteEngine On
			RewriteRule ^hosted/(.*)\.(gif|jpe?g|png)$ /remote-watermark.php?image=$1.$2 [NC,L,QSA]

		NOTE: Check if you can use RewriteRule before re-coding your CMS!

		The "QSA" flag ensures any original query strings are appended back on
		to the final request (e.g. ?watermark=My%20Super%20Funky%20Watermark)

		If you want to use some other path (i.e. NOT /hosted/), simply switch
		it in your links and RewriteRule. It's a virtual path only, but you may
		be using it elsewhere.


	OK, all image requests are now rewritten to /remote-watermark.php which does 
	three things:

		1. Fetches the image from the *real* location (on the remote server)

		2. Adds a custom watermark to the image.

		3. Spits out the new image.

	You can change the name and location of this script, as required, so long as 
	your RewriteRule matches its final destination.

	For this to work, your installation of PHP must have the php flag:
	
		allow_url_fopen On

	This is likely already switched on at the server level. If not you can 
	probably enable it in .htaccess, too. Like so:

		php_flag allow_url_fopen On


	Any issues, mail me at the usual address..

	;o) Cor

	@ corz.org

	ps. of course you could expand greatly on this, check for png and other
	image types, send out more headers and so on. This is merely a working bare-
	bones-proof-of-concept-example type thing.

	And of course this is more processing for your server.

	If you are reading this file at corz.org, the "test" button will take you
	to a simple HTML page which demonstrates this script in action. You can
	also hit "download" to get a zip of everything required.

*/


// 'watermark' text we will overlay on the image (can be overridden by page)..
$my_text = 'My Funky Watermark';

// grab image location from query string..
$img_location = $_GET['image'];

// you could send the text as well, I guess..	?watermark=My%20Super%20Funky%20Watermark
if (isset($_GET['watermark'])) { $my_text = $_GET['watermark']; }

// open remote image..
$img = imagecreatefromjpeg('http://corz.org/public/machine/source/php/imaging/'.$img_location);
// This is where you put the REAL location of the image on the REMOTE host.

// add black text..
$text_color = imagecolorallocate($img, 0, 0, 0);

// place the text: size 4 "built-in" font, 8px along, 5 down..
imagestring($img, 4, 8, 5, $my_text, $text_color); 

// send the image..
header("Content-type: image/jpeg");
imagejpeg($img);
imagedestroy($img);

?>