<?php             // ۞ text{encoding:utf-8;bom:no;linebreaks:unix;tabs:4;}  ۞//
												  $post_dumper_version = '0.6';
/*

	php post dumper.
	a post-dump back-up strategy for browser crashes..

	When someone at your site POSTs something (from any form) this script dumps
	the posted textarea to a file. Of course it works for your posts, too.

	So, if your browser ever crashes, as they do, you can get back that 'lost post',
	blog, comment, whatever it was. You could recover text that your users 'lost'
	too, and also see things which they previewed, but *didn't* post. 8)

	Also handy for catching potential spammers. You'd be amazed the things that
	people use your site's forms for, often automatically, things that one would
	not normally see, at least with a decent spam-preventionsystem in-place.

	How does the dumper know which post variable is the textarea? It doesn't, it
	simply calculates the length of all variables in the POST array, and dumps the
	*longest* one, works brilliantly.

	I wish I had this ten minutes ago!

	Make fun, now.

	;o) Cor

	(c) copyright corz.org 2005->today

*/


/*
prefs.. */
/*
	dump file..

	you'll likely want to ensure this file is protected from direct browser access.
	hence the suggested ".ht_something" name. "basic" passwords may end up in here.
	if running under phpsuexec, you could chmod it 600, too.
																				*/

	if (@empty($site_config['dump_file'])) $dump_file = $_SERVER['DOCUMENT_ROOT'].'/inc/log/.ht_dump';


/*
	time adjust..

	difference between server time and your local time (in hours).
	purely to save you having to calculate it over when reading the dump.
	if you are in the UK, and your server in the states, use 5, or whatever.

	If you are using php5, set it to zero, and use the locale setting (next)
																			*/
	$site_config['pd_diff'] = 0;


/*
	got php5, you can use this..
								*/
if ((int)PHP_VERSION >= 5) {
	date_default_timezone_set('GB'); // 'GB' handles BST automatically, afaik. handy.
}


/*
end prefs. */



function do_post_dump($file) {
global $site_config;

	if (!empty($_POST)) {

		// set the time..
		// php5 has better ways to do this.
		$adjustment = ($site_config['pd_diff'] * 60 * 60);
		$date = date('D jS F g:i a',time() + $adjustment);

		// the magic part 1..
		foreach ($_POST as $key => $value) {
			if (!is_array($value)) {
				$posted[$key] = strlen($value); // clever!
			} else { unset($posted[$key]); }
		} asort($posted); // sneak this in here.

		// you might want to format this differently..
		$user_agent_str = @$_SERVER['HTTP_USER_AGENT'];
		$info_string = $_SERVER['REQUEST_URI']."\t".$user_agent_str."\t\n[from: "
			.$_SERVER['REMOTE_ADDR'].' on '.$date."]\n\n";

		// the magic part 2..
		//$longest = str_replace("\r\n", "\n", $_POST[array_pop(array_flip($posted))]);
		// php5 strict error avoidance method.. *sigh*..
		$flipped = array_flip($posted);
		$longest = str_replace("\r\n", "\n", $_POST[array_pop($flipped)]);

		if (get_magic_quotes_gpc()) { // more magic! pfff..
			$longest = stripslashes($longest);
		}

		// gotcha!		// folk testing the parser..
		if (!stristr($longest, '[big]corzblog bbcode to html to bbcode parser')) {
			append_post_data($file, $info_string.$longest."\n\n\n");
		}
	}
}


/*
	append post data to the end of the dump file
										*/
function append_post_data($file, $data) {

	// it's not there. try to create..
	if (!file_exists($file)) {
		$fp = fopen($file, 'wb');
	}

	if (is_writable($file)) {
		$fp = fopen($file, 'ab');
		$lock = flock($fp, LOCK_EX);
		if ($lock) {
			fwrite($fp, $data);
			flock ($fp, LOCK_UN);
		} else {
			$GLOBALS['errors']['append_post_data'] = "couldn't lock $file";
		}
		fclose($fp);
	} else {
		$GLOBALS['errors']['append_post_data'] = "can't write to $file";
	}
}

// direct access -> dump the php source..
if (realpath($_SERVER['SCRIPT_FILENAME']) == realpath(__FILE__)) {
	@include $_SERVER['DOCUMENT_ROOT'].'/inc/source-dump.php';
	source_dump(__FILE__);
}

?>