<?php // ۞// text { encoding:utf-8 ; bom:no ; linebreaks:unix ; tabs:4sp ; }

/*
	pajamas demo v2

	this is a "secure image viewer", if you like.
	once you login, you get to see the pics.

	based on the old demo, but somewhat cleaner, 
	and using the new modular system.


	© (or @ corz.org 2004-> ;o)

*/

// init..
$do_authentication = true;
$show_session_errors = false;
include ('inc/init.php');

// a wee image loader for the demo..
if(isset($_GET['go_image'])) {
	get_image($_GET['go_image']);
	die();
}

include ('inc/doc-type.php');
echo '<head>
<meta http-equiv="content-type" content="',$doc_content,'; charset=utf-8" />
<title>\'pajamas\' (v',$auth->_version,') .. php + javascript secure login demonstration from corz.org</title>
<meta name="description" content="\'pajamas\' secure image demo - php and javascript advanced md5 authentication system, from corz.org. pajamas is a modular authentication system." />
<meta name="keywords" content="corz org,pajamas,security,secure login,php and javascript,php security,web site security,pajamas,authentication,secure authentication,demo" />
<style type="text/css">
/*<![CDATA[*/ 
@import "inc/css/pajamas.css";
/*]]>*/
</style>
</head>
<body>
<div class="container">';

// changes with auth..
include ('inc/menu.php');


if (!$auth->auth_user()) {	// NOT authenticated!
	echo '
	<div class="content">

		<h1>pajamas</h1>
		<h3 class="sub">php and javascript advanced md5 authentication system</h3>

		<div class="v-wide-top">
			<h3>Welcome to the pajamas demo!</h3>

			Before you login, you can load the <strong><a href="readme.php" title="readme!" id="readme-link">readme</a></strong> page. After you login, you can also access the cool images gallery (which is, in fact, the page you are reading right now, except you can\'t see the good stuff, yet). Note that the menu (top-right) will be different after you login, on all pages.<br />
			<br />

			The default authentication system (&quot;pj&quot;) uses JavaScript to mash up the password before it goes over the wires. If you look closely at the password field when you click "login", you will see that it changes just before it gets sent, growing to exactly thirty two characters.<br />
			<br />

			Your session will last thirty seconds.<br />
			The password is <strong>demo</strong>.
		</div>

	</div>
	<div class="small-space">&nbsp;</div>';

	// spit out a login form..
	echo $auth->getAuthCode(); // gotta include this first.
	echo $auth->getLoginForm();
	echo '
	<div class="half-space">&nbsp;</div>';


} else {

	// they are authenticated and logged in.
	// better do a logout button..
	echo $auth->getLogoutButton();

/*
	and then whatever else "authorised" folks get to do..
	
	I'm just gonna do a wee image gallery, some snaps from the donny.
	(aka "The Don". A river in Aberdeen where I often walk with Karma)
	
	a gallery..														*/

	if(isset($_GET['image'])) { $image = $_GET['image']; } else { $image = '1'; } // default image.
	
	if($auth->_do_time_out) {
		$time_msg = '<b>you have exactly '.$auth->remainingTime().' seconds to enjoy these pics..</b>';
	} else { 
		$time_msg = '<b>take your time, enjoy the pics..</b>';
	}

	// numbers correspond to the name of the image, eg. "img1.jpg"..
	$footnotes = array (
		'1'		=>	'Bird in flight (current desktop background)',
		'2'		=>	'A cool tree \'doon by the donnie\'',
		'3'		=>	'Some ancient machinery. We like this',
		'4'		=>	'Karma contemplates fishing, again.'
	);
	
	echo '
	<div class="wide-content">
	<div class="tiny-space">&nbsp;</div>
		<h2>',$time_msg,'</h2>
	</div>
	<div class="small-space">&nbsp;</div>

	<div class="v-narrow-top">
		<div class="img-view">
			<div class="small-space">&nbsp;</div>
			<img src="',$auth->getSelf(),'?go_image=img',$image,'.jpg" alt="your image" /><br />
			<div class="pic-text">',$footnotes[$image],'</div>
		</div>
		<div class="thumb-view">';
	foreach ($footnotes as $num => $pic) {
		echo '
			<a href="',$auth->getSelf(),'?image=',$num,'" title="',$pic,'click here to see a bigger version of this image"><img src="',$auth->getSelf(),'?go_image=img',$num,'_tn.jpg" alt="',$pic,'" /></a>';
		}
	echo '
		</div>
	</div>
	<div class="quarter-space">&nbsp;</div>';

}


// you really want to see this?
if ($auth->getErrors() and $show_session_errors) {
	echo '
	<div class="warning centered">';
	echo $auth->getErrors();
	echo '
	</div>';

}

echo '
<div class="clear">&nbsp;</div>
<!-- footer -->';
include ('inc/footerx.php');
echo '
</div>
</body>
</html>';


	/*
		fin
			 */


/*
image includer..		   */
function get_image($image) {
global $auth;

	if (empty($image)) { return; }
	$file = substr($_SERVER['SCRIPT_FILENAME'], 0, (strrpos($_SERVER['SCRIPT_FILENAME'],'/') + 1)).'img/'.$image;

	if ($auth->auth_user()) {
		if ($get_it = @fopen($file, 'rb')) {
			header("Content-Type: image/jpeg \n");
			header("Content-Length: ".filesize($file)."\n");
			header("Content-Disposition: attachment; filename=$image\n");
			fpassthru($get_it); // do it!
		} else {
			create_image(90,70,'404'); // spit out a 404 image
			die();
		}
	} else {
		create_image(90,70,'403'); // spit out a 403 image
		die();
	}
}

/* 
feed it an http error code, get an image of that..	*/
function create_image($width, $height, $err_code) {
	$img = imagecreate(30, 20) or die("can't create image.sorree");
	$bg = imagecolorallocate($img, 255, 255 ,0); // 1st colour becomes background
	$black = imagecolorallocate($img, 0, 0, 0); // black
	imagestring($img, 5, 2, 0, $err_code, $black);
	$img2 = imagecreatetruecolor($width, $height);
	imagecopyresampled($img2, $img, 0, 0, 0, 0, $width, $width, 30, 20);
	imagedestroy($img);
	$black = imagecolorallocate($img2, 0, 0, 0); // black
	header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
	header('Expires: Tue, 01 Apr 1970 00:00:00 GMT');
	header('Pragma: no-cache');
	header('Content-type: image/jpeg');
	imagejpeg($img2,"",90);
	imagedestroy($img2);
}


?>