<?php // ۞// text { encoding:utf-8 ; bom:no ; linebreaks:unix ; tabs:4sp ; }
if (realpath ($_SERVER['SCRIPT_FILENAME'] )   ==   realpath ( __FILE__ ))  {
										die ( 'to err is human, human!' ); }
/*

	"plain"
	a plug-in authentication module for pajamas.
	
	If, for some insane reason, you don't have access to a JavaScript-capable 
	browser, use this 'plain' module, otherwise, use 'pj'. You could feasibly
	allow users to choose, I guess. :/

	The plain module has many of its features of the more secure 'pj' module; 
	sessions, IP check, time-out, etc., and can be configured in exactly the 
	same way as, too. The only real difference being that the password is sent 
	over the wire in *plain* text. JavaScript is not required.
	
	With the pajamas plain module, at least the password travels over the wires 
	one time only, unlike HTTP basic authentication, which send the password with 
	*every single request*! Probably that's what your site hosting admin uses, 
	crazy, huh.

	Usage:

		simply load pajamas as usual. ie..

			include('/path/to/pajamas.php');
			$auth = new pajamas();

		or 

			$auth = new pajamas('MyUid'); // optionally pass an id 


		and then, before you use the module, with your other preferences, set..

			$auth->_default_module = 'plain';
	
	If you need to use the plain module in 'simple' mode, set that inside pajamas,
	or else call it like this.. $auth = new pajamas('uid-plain');

	If you need help, mail me @ corz.org, or if you think a solution to your 
	issue would	be valuable to others, drop a comment on the pajamas page.

		http://corz.org/serv/security/pajamas.php

	Have fun!
	
	;o)
	(or

	ps..	Like all pajamas modules, the plain module can also be accessed
			directly, if required.

	© 2006-> (or @ corz.org ;o)

*/


class authModule {

	var $_version			= '0.1';


/*	public properties..
	see the main pajamas engine for more details.
	*/
	var $_big_luser			= 10;
	var $_check_ip			= true;
	var $_createForms		= true;
	var $_do_messages		= true;
	var $_do_time_out		= true;
	var $_kick_bad_users	= false;
	var $_login_password	= 'password';
	var $_no_autocomplete	= true;
	var $_session_time		= 60;


	// private properties..
	var $_auth_message		= '';
	var $_bad_user			= false;
	var $_is_authenticated	= null;
	var $_unique_id;
	

	// constructor..
	function authModule($uniqueid='') {
		if (!empty($uniqueid) and ctype_alnum($uniqueid)) {
			$this->_unique_id = $uniqueid;
		}
		$this->initSession();
	}

	// main function..
	function auth_user() {

		if ($this->_is_authenticated === true) {
			return true;
		} else if ($this->_is_authenticated === false) {
			return false;
		}
		
		$address_is_good = false;
		if ($this->_check_ip == false) { $address_is_good = true; }
		$agent_is_good = false;
		
		
		$time = '';
		$time_out = false;
		if ($this->_do_time_out == true) { 
			$real_session_time = $this->_session_time * 6000;
			$now = explode(' ',microtime());
			$time = $now[1].substr($now[0],2,2);
			settype($time, 'float');
	
			// time-out (do this before login events)..
			if (isset($_SESSION['auth'.$this->_unique_id]['login_at'])) {
				if ($_SESSION['auth'.$this->_unique_id]['login_at'] < ($time - $real_session_time)) {
					$this->_auth_message = 'session time-out!';
					$time_out = true;
				}
			}
		}


		// you logged out..
		if ((isset($_REQUEST['logout'])) or ($time_out == true)) {
			$this->endSession();
			// This gets rid of the logout in the REQUEST vars
			if (!headers_sent()) {
				header("Location: ".$this->getSelf());
			}
		}

		// check their IP address..
		if (isset($_SESSION['auth'.$this->_unique_id]['remote_addr'])) {
			if ($_SERVER['REMOTE_ADDR'] == $_SESSION['auth'.$this->_unique_id]['remote_addr']) {
				$address_is_good = true;
			}
		} else { 
			$_SESSION['auth'.$this->_unique_id]['remote_addr'] = $_SERVER['REMOTE_ADDR'];
		}
	
		// check their user agent..
		if (isset($_SESSION['auth'.$this->_unique_id]['agent'])) {
			if ($_SERVER['HTTP_USER_AGENT'] == $_SESSION['auth'.$this->_unique_id]['agent']) {
				$agent_is_good = true;
			}
		} else { 
			$_SESSION['auth'.$this->_unique_id]['agent'] = $_SERVER['HTTP_USER_AGENT'];
		}

		// they tried and tried, now we've had enough of them..
		if (($_SESSION['auth'.$this->_unique_id]['count'] >= $this->_big_luser) and ($this->_kick_bad_users)) { 
			$this->_bad_user = true;
			$this->_is_authenticated = false;
			
			// error message for lusers..
			$this->_auth_message = 'too many bad attempts! restart your browser to try again.';
			return false;
		}


		// admin login
		if (isset($_POST['auth_login'])) {	// u da man!

			if ($_POST['auth_login'] == $this->_login_password) {
				$_SESSION['auth'.$this->_unique_id]['login_at'] = $time; // isn't this empty ('')?
				$_SESSION['auth'.$this->_unique_id]['session_pass'] = md5($this->_login_password);
				$this->_is_authenticated = true;

			} else { // oh oh..
				$_SESSION['auth'.$this->_unique_id]['count']++;
				$this->_auth_message = 'password incorrect!';
	
				// they blew it.
				if ($_SESSION['auth'.$this->_unique_id]['count'] >= $this->_big_luser) {
					$_SESSION['auth'.$this->_unique_id]['dead'] = true; // just for our own records
				
					$this->_auth_message = 'too many bad attempts! restart your browser to try again.';
					$this->_bad_user = true;
				}
				$this->_is_authenticated = false;
				return false;
			}
		}


		// already logged in..
		if ((isset($_SESSION['auth'.$this->_unique_id]['session_pass']))
			and ($_SESSION['auth'.$this->_unique_id]['session_pass'] == md5($this->_login_password))) {
			if (($address_is_good == true) and ($agent_is_good == true)) {
				$this->_is_authenticated = true;
			} else { 
				$this->_auth_message = 'who are you?';
			}
		}
		return $this->_is_authenticated;
	}

	function getAuthCode() { 
		return '';
	}

	function getLoginForm() {

		if (func_num_args() > 0) { 
			$simple = func_get_arg(0); 
		} else { 
			$simple = false;
		}
		$str = '';
		if ($this->_no_autocomplete) { $ac = 'autocomplete="off"'; } else { $ac = ''; }

		if ($this->_createForms) {
			$str .= '
		<form name="passform" method="post" action="'.$this->getSelf().'">';
		}

		// instead of proprietary autocomplete, perhaps.. name="auth_login-'.$this->getRandomString().'"
		// and work out the $_POST variable later! hmm. dunno.
		if (!$simple) { $str .= '
		<div class="auth-container">
		<div class="auth-form">';
		}
		if (($this->_do_messages) and (!empty($this->_auth_message))) { 
			$str .= '
		<div style="color:#FF0000;font-weight:bold;">'.$this->_auth_message.'</div><br />';
		}

		$str .= '
			<span class="auth-text">password..</span><br />
			<input type="password" class="auth-login" id="auth_login" name="auth_login" size="16" title="watch this area VERY carefully when you click \'log in\'" '.$ac.' />
			<input type="submit" value="login" title="note: on weird systems you MUST click this, pressing enter won\'t work" /><br />';

		if (!$simple) { $str .= '
			<div class="auth-note">';		
			$cs = '';
		} else { 
			$cs = ' class="auth-note"';
		}
		$str .= '
				<a'.$cs.' href="http://corz.org/serv/security/pajamas.php" onclick="window.open(this.href); return false;" title="php and javascript advanced md5 authentication system, from corz.org">powered by pajamas authentication (plain)</a>';

		if (!$simple) { $str .= '
			</div>
		</div>
		</div>';
		}
		if ($this->_createForms) { $str .= '
		</form>';
		}

	return $str;
	}

/*
	create logout button..
*/
	function getLogoutButton() {

		if (func_num_args() > 0) { 
			$simple = func_get_arg(0); 
		} else { 
			$simple = false;
		}

		$str = '';
		if ($this->_createForms) {
			$str = '
		<form name="logout_form" action="'.$this->getSelf().'" method="post">';
		}
		if (!$simple) {
			$str .='
		<div class="auth-logout">';
		}
		$str .='
			<input type="submit" value="logout" name="logout" />';
		if (!$simple) {
			$str .='
		</div>';
		}
		if ($this->_createForms) {
			$str .= '
		</form>';
		}
		return $str;
	}
	


	function getSelf() {
		return $_SERVER['SCRIPT_NAME'];
	}

	function getBadUser() {
		return $this->_bad_user;
	}

	function endSession() {
		unset($_SESSION['auth'.$this->_unique_id]);
		$this->initSession();
	}

	function initSession() {

		if (!headers_sent()) {
			session_start();
			header('Cache-control: private'); // IE 6 Fix :/
		}

		// initialize the session variables..
		if (!isset($_SESSION['auth'.$this->_unique_id])) {
			$_SESSION['auth'.$this->_unique_id] = array('count' => 0);
		}
	}
	
}


class simpleAuthModule extends authModule {

	function simpleAuthModule($uniqueid='') {
		parent::authModule($uniqueid);
		if ($this->auth_user()) {
			echo $this->getLogoutButton();
		} else {
			echo $this->getLoginForm();
		}
	}
	
}

?>