<?php  // ۞// text { encoding:utf-8  ; bom:no ;  linebreaks:unix  ; tabs:4sp ; }

/*
	simple php source viewer v0.3.1

	many web servers don't support .phps source highlighting, and
	on those that do (you can add support in .htaccess files), you
	will often find the output truncated, which is frustrating.

	here is a solution which works under all conditions (php4+)

	ideally, you create a folder called "source" and drop this file
	(usually named "index.php") into that folder, along with any php
	scripts you would like to have available for viewing.

	anything with a .php, .phps or .inc extension will be added to the menu

	in order for the "download" link to work, you will need to have a
	zip archive in the specified folder, called "script-filename.zip", so
	for instance, to allow users to download "rss.php", you would create a
	zip called "rss.php.zip", which by happy coincedence is exactly the
	same filename the OS X built-in zipper would give you!

	this script was the precursor to corz distro machine. this is its original form,
	purely a source viewer, though with a few small refinements.

	INSTALLATION:
	rename this file to "index.php" and drop it in the source folder


	(c) copyright corz.org 2000->today

*/

// paths, from your http root..
$source_path = '/public/machine/source/php/corz function library/';
$download_path = '/public/machine/download/php/corz function library/';
$source_file = '';

// You will need a local copy of this for IE7/8 users..
$HTML5_shiv = '/inc/js/html5.js';

// setup some php values..

// essential! switch off in .htaccess too!
ini_set('zlib.output_compression','off');

// the colors for the source highlighing..
@ini_set('highlight.string','#E53600');
@ini_set('highlight.comment','#FFAD1D');
@ini_set('highlight.keyword','#47A35E');
@ini_set('highlight.bg','#FFFFFF');
@ini_set('highlight.default','#3F6DAE');
@ini_set('highlight.html','#0D3D0D');

do_header();

//echo '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
//        "http://www.w3.org/TR/html4/loose.dtd"><html><head>
//<meta http-equiv="content-type" content="text/html; charset=utf-8"><title>corz.org php source viewer</title>
//<meta name="description" content="php source viewing system by corz.org"><meta name="author" content="corz.org">
////<link rel = stylesheet href="/inc/css/osx.css"><style media="screen"><!--
//body { font-family: Tahoma, Lucida Grande, Helvetica, Verdana, sans-serif; color: #003; font-size: 12pt; background: #FFF  url(/img/window_plain_m.png) repeat-x; }
//a:link		{ color:#55aa55; text-decoration: none; }
//a:active 	{ color:#F0F; text-decoration: none; }
//a:visited 	{ color:#77cc77; text-decoration: none; }
//a:hover		{ color:#449944; text-decoration: none; }
//td.foot { font-family: Tahoma, Trebuchet, Helvetica, sans-serif; font-size: 11pt; color: #000; padding: 3px;}
////--></style></head>
//<bodybgcolor="#ffffff">';
//@include $_SERVER['DOCUMENT_ROOT'].'/public/mac/inc/osxheader.php';
//

if (isset($_GET['source'])) $source_file = $_GET['source'];
// prevents them viewing your system files..
$source_file = str_replace('../','',$source_file);
if (($source_file != '') and (file_exists($source_file))) {

	/*	we specify the folder to prevent folks viewing sources outside it, using, say
		http://domain/scripts/index.php?=./config.php	*/
	$file_name = $_SERVER['DOCUMENT_ROOT']. $source_path . $source_file;

	/*	the optional true parameter tells php to pipe output to a string
		rather than just spit it out directly	*/
	$source2print = highlight_file($file_name, true);

	echo '
	<table align="center" cellspacing=0 cellpadding=0 width="95%">
		<tr>
			<td height=10>
			</td>
		</tr>
		<tr>
			<td colspan=3><span size="-1">';
	echo $source2print;
	echo '</span>
	<!-- source viewer ® corz.org 2004 -->
	<!--printend-->
			</td>
		</tr>
		<tr><td height=10></td></tr>
		<tr>
			<td height=42 bgcolor="#99ee99" align=left width="33%">
			<a href="./" title="back to green source viewer menu">
			&nbsp;back to the menu
			</a>
			</td>

			<td bgcolor="#99ee99" align="center" width=\'33%\'>
			<a href="',$download_path.$source_file,'.zip" title="download a zip of this script">
			&nbsp;download&nbsp;
			</a>
			</td>

			<td bgcolor="#99ee99" align="right" width=\'33%\'>
			<a href="./',$source_file,'" title="run this script, check it out, maybe">
			try out this script&nbsp;<br />
			<small>(note: some scripts won\'t run from this location)</small>&nbsp;
			</a>
			</td>
		</tr>
		<tr><td height=10></td></tr>
	</table>
</body></html>';

} else {

	echo '
	<table align="center" cellspacing=0 cellpadding=0 width="90%">
		<tr>
			<td height=42 colspan=2>
			</td>
			<td></td>
			<td></td>
		</tr>
		<tr>
			<td height=70 width="23%">
			<td><span color="#77cc77">
			<h3>&nbsp;view source for which script?..</h3>
			</span>
			</td>
		</tr>
		<tr>
			<td height=70 width=100>
			<td>

			<table align=left cellspacing=0 cellpadding=20 width="72%">
				<tr>
					<td bgcolor="#99ee99">';

	// we'll do this in two stages, cuz it's neater.
	if ($the_dir = opendir($_SERVER['DOCUMENT_ROOT'] . $source_path)) {
		$q=0;
		while (false != ($file = readdir($the_dir))) {

			// check which files to allow, no invisibles (which may share same extensions - mac)
			if ((preg_match("/(\\.php|\\.inc|\\.phps)$/", $file)) and (ord($file) != 46)) {

				// handy for running source_viewer in a /source/ directory
				if (basename($file) != 'index.php') {

					// add filename to array (path stripped off)
					$itemz[$q++] = basename($file);
				}
			}
		}
	}
closedir($the_dir);
}

// we have the array now, let's spit it out..
if (@count($itemz)>0) {
	sort ($itemz);
	$dirsize = count($itemz);
	for ($a=0 ; $a<$dirsize ; $a++) {
		if ($a == $dirsize){
			break;
		} else {
			$source_file_name = $itemz[$a];
			echo '
			<a href="?source='.
			$source_file_name,'" title="see the source for this file">',$source_file_name,'</a><br />';
		}
	}
				echo '
			</td>
			<td bgcolor="#99ee99" width=100></td>
		</tr>
		<tr>
			<td align="right" colspan=2 bgcolor="#aaffaa">
			<span color="#77cc77" size="+2">
			<strong>..corz php source viewer</strong></span>
			</td>
		</tr>

		<tr>
			<td align="right" colspan=2><span color="#77cc77" size="+1">
			<a href="../" title="return to php scripts folder.">return to php scripts folder</a>
			</span>
			</td>
		</tr>

		</table>
		</td>
	<tr>
	<tr>
		<td height=30>
		</td>
	</tr>
</table>';

} elseif (!isset($_GET['source'])) {

	echo '
			</td>
			<td bgcolor="#99ee99"><span color="#55aa55" size="+1">
			no scripts available to show</span></td>
		</tr>
		<tr>
			<td align="right" colspan=2><span color="#77cc77" size="+1">
			<a href="/public/scripts/php" title="return to php scripts folder.">return to php scripts folder</a>
			</span>
			</td>
		</tr>
		</table>';
}



/*
   do a page header
					 */
function do_header() {
global $textview, $HTML5_shiv;

	if (empty($GLOBALS['textview']['file_name'])) {
		$title_str = 'built-in demo';
	} else { $title_str = $GLOBALS['textview']['source_file']; }

	echo '<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="initial-scale=1.0, width=device-width" />
<!--[if lt IE 9]><script src=',$HTML5_shiv,'></script><![endif]-->
<meta name="description" content="text files served with love and simple formatting" />
<meta name="generator" content="Cor" />
<meta name="author" content="corz.org" />
<style media="screen">
/*<![CDATA[*/ ';
switch (true) {
  case (file_exists($textview['root'].'/inc/css/main.css')):
	echo '
@import "/inc/css/main.css";'; // for the corz.org toolbar
  case (file_exists($textview['root'].'/inc/css/textview.css')):
	echo '
@import "/inc/css/textview.css";'; // in-situ
	break;
  case (file_exists('textview.css')):
	echo '
@import "textview.css";'; // distro, or lazy web master.
}
echo '
/*]]>*/
</style>
<title>text view of '.$title_str.'</title>
</head>
<body>';

}

echo '
</body>
</html>';

?>