<?php // ۞// text { encoding:utf-8 ; bom:no ; linebreaks:unix ; tabs:4sp ; }
if  (realpath ($_SERVER['SCRIPT_FILENAME'])    ==    realpath (__FILE__))  {
                                        die ( 'to err is human, human!' ); }

// for ini file writing..
require_once 'file-tools.php';

/*
	ini-tools.php - read/write ini files in php			v0.3.3

	;o) Cor

	© corz.org  2008->tomorrow!

*/

/*
	Available Functions:

			read_ini					(data_file)

			write_ini_pairs				(data_file, ini_array [, section])

			write_ini_value				(data_file, section, key [, value])

			write_ini_array_to_file		(ini_array, data_file)

			write_ini_data_to_file		(data_file, data)
*/



/*
	function read_ini()

	pull the data from the ini file and return as an array

	Usage: array (string {path to file})

	returns false on failure.

	NOTE: This function will return a multi-dimensional array if you ask for sections.

	NOTE: unlike parse_ini_file(), this function will correctly parse [square braces]
	inside keys and values (unless the key /begins/ with a "[", which would be plain silly).

												*/
function read_ini($data_file, $sections=false) {
	$ini_array = array();
	if (is_readable($data_file)) {
		$file = file($data_file);
		$current_section = NULL;
		foreach($file as $conf) {
			$conf = trim($conf);
			if ($sections) {
				if (substr($conf,0,1) == '[') {
					$current_section = substr($conf,1,-1);
					continue;
				}
			}
			// if first real character isn't '#' or ';' and there is a '=' in the line..
			if ((substr($conf,0,1) != '#')
			  and (substr($conf,0,1) != ';')
			  and (substr_count($conf,'=') >= 1) ) {
				$eq = strpos($conf, '=');
				if ($sections) {
					$ini_array[$current_section][trim(substr($conf,0,$eq))] = trim(substr($conf, $eq + 1), '"');
				} else {
					$ini_array[trim(substr($conf,0,$eq))] = trim(substr($conf, $eq + 1), '"');
				}
			}
		}
		unset($file);
		return $ini_array;
	} else {
		$GLOBALS['errors']['read_ini'] = "ini file: $file does not exist.";
		return false;
	}
}



/*
function write_ini_pairs()

	This function accepts an array of values, and creates an "ini" file from them.
	For security reasons, write_ini_pairs won't store keys named 'password' or 'pass'.

	It was designed to enable you to easily capture whole $_POST arrays, get
	authentication, and pass the rest directly to write_ini_pairs().

	Note:	The ini file has no [sections] capability, but can create a single
			master [section] to hold your key = value pairs, if required.

			If you want to manipulate sections, keys and values, see
			write_ini_value(), below.

	Usage:

		bool ( string {path to file}, array {of ini key=values} [, string {"[ini-section]"}])

	this function returns true on success,
	false on failure.
										*/
function write_ini_pairs($data_file, $ini_array, $section='') {
	// init..
	if ($section) {
		$data = '['.$section."]\n";
	} else {
		$data = '';
	}
	foreach ($ini_array as $var => $val) {
		if ($var != 'password' and $var != 'pass') {
			$data .= $var.' = '.$ini_array[$var]."\n";
		}
	}
	if (get_magic_quotes_gpc()) {
		$data = stripslashes($data);
	}
	if (write_ini_data_to_file($data)) {
		return true;
	} else {
		$GLOBALS['errors']['write_ini_pairs'] = $GLOBALS['errors']['write_ini_data_to_file'];
		return false;
	}
}



/*
	Write an ini value.

	Usage:

		bool write_ini_value(String {file path}, String {section name}, String {key name}, String {its value})

	If the key exists, its value will be set to the your value.
	If the key does not exist, it will be created, and then set.
	If the section does not exist, it too, is created, and then the 'key = "value"' pair added.

	NOTE: You can remove keys by setting them by omitting the value (4th) parameter.

	This function relies upon the following other functions:

		read_ini()
		write_ini_array_to_file()
		 .. write_ini_data_to_file()
																			*/
function write_ini_value($data_file, $section, $key, $value='') {
	$done = false;
	$ini_array = read_ini($data_file);
	if (is_array($ini_array)) {
		foreach ($ini_array as $ky => $val) {
			if ($ky == $section) {
				foreach ($val as $ky2 => $val2) {
					if ($ky2 == $key) {
						if ($value) {
							$ini_array[$section][$key] = $value;
						} else {
							unset($ini_array[$section][$key]);
						}
						$done = true;
					}
				}
			}
		}
		// no changes, add a new key = value pair..
		if (!$done) {
			$ini_array[$section][$key] = $value;
		}
	} else {
		// Start a whole new section..
		$ini_array = array($section => array($key => $value));
	}
	// write out the complete ini file..
	write_ini_array_to_file($ini_array, $data_file);
	return true;
}




// Basic. Does what it says on the tin..
// I nicked this from the php manual..
//
function write_ini_array_to_file($ini_array, $data_file) {
	$ini_data = '';
	foreach ($ini_array as $key => $value) {
		$ini_data .= "[".$key."]\n";
		foreach ($value as $key2 => $value2) {
			if (is_array($value2)) {
				for($i=0; $i < count($value2); $i++) {
					$ini_data .= $key2."[] = \"".$value2[$i]."\"\n";
				}
			} elseif ($value2 == '') {
				$ini_data .= $key2." = \n";
			} else {
				$ini_data .= $key2." = \"".$value2."\"\n";
			}
		}
	}
	// finally, write the string data to the ini file..
	write_ini_data_to_file($data_file, $ini_data);
}



/*
	write out some data to a new file..

	usage:

		bool ( string {full file path}, string {data to write});

	this function returns true on success, false on failure.

													*/
function write_ini_data_to_file($data_file, $data) {
	if (!$writable = write_data_to_file($data_file, $data)) {
		$GLOBALS['errors']['write_ini_data_to_file'] = $GLOBALS['errors']['write_data_to_file'];
	}
	return $writable;
}


?>