<?php //۞// text{encoding:utf-8;bom:no;linebreaks:unix;tabs:4;}
                                 $file_tools_version = '0.4';/*

	file tools..
	miscelleneous file system functions.

	read file, write file, append to file, that sort of thing.
	these functions are very fast, robust, and heavily tested.

	read functions generally return a string, write functions
	generally return true for successful operations, or false
	in the case of failure, in which case an error message
	describing the failure will be available at..

		$GLOBALS['errors']['name_of_function']  (from anywhere)

	or..

		$errors['name_of_function']     (from the global scope)

	which you can echo somewhere, log, whatever. I find it handy
	to keep errors in the global scope because you never know
	when you might need to get to them.

	;o) Cor

	(c) 2003->tomorrow! cor + corz.org ;o)

*/


// init..
// you might want to do this..
//$GLOBALS['errors'] = array();


/*
	get file into string..

	open a file and return the contents as a string.
	faster than file_get_contents (so it's useful when *lots* of
	files need to be interrogated)..

		string ( string (full file path));

	this function returns false on failure.
								   */
function get_file_as_string($file) {

	if (file_exists($file)) {
		$file_handle = fopen($file, 'rb');
		$file_contents = fread($file_handle, filesize($file));
		fclose($file_handle);
		return $file_contents;
	} else {
		$GLOBALS['errors']['get_file_as_string'] = "$file. is missing!";
		return false;
	}
}


/*
	Appends one line of text to a file

	Used to maintain lists, usually. i.e. add a spammer to the
	spammer strings list. The "file" is a plain text with UNIX
	("\n") line breaks.


	Usage:

		bool ( string (full file path), string (line to add));

	Note: You do not need to add the line break.

	This function returns true on success,
	false on failure.
											 */
function append_line_to_file($file, $string) {

	$writable = false;

	if (is_writable($file)) {
		$fp = fopen($file, 'ab');
		$lock = flock($fp, LOCK_EX);

		if ($lock) {
			fwrite($fp, trim($string, "\n\r")."\n");
			flock ($fp, LOCK_UN);
			$writable = true;
		} else {
			$GLOBALS['errors']['append_line_to_file'] = "couldn't lock $file";
			$writable = false;
		}
		fclose($fp);
		clearstatcache(); // not strictly necessary

	} else {
		$GLOBALS['errors']['append_line_to_file'] = "can't write to $file";
		$writable = false;
	}

	return $writable;
}



/*
	add some data to the end of a file.

	usage:

		bool ( string (full file path), string (data to add));

	this function returns true on success,
	false on failure.
										   */
function append_data_to_file($file, $data) {

	$writable = false;

	if (is_writable($file)) {
		$fp = fopen($file, 'ab');
		$lock = flock($fp, LOCK_EX);
		if ($lock) {
			$writable = true;
			fwrite($fp, $data);
			flock ($fp, LOCK_UN);
		} else {
			$GLOBALS['errors']['append_data_to_file'] = "couldn't lock $file";
			$writable = false;
		}
		fclose($fp);
		clearstatcache();
	} else {
		$GLOBALS['errors']['append_data_to_file'] = "can't write to $file";
		$writable = false;
	}

	return $writable;
}



/*
	Write out some data to a new file..

	Existing files will be wiped before the data is written.

	Usage:

		bool ( string (full file path), string (data to write));

	returns true on success, false on failure.
											*/
function write_data_to_file($file, $data) {

	$writable = false;

	if (!file_exists($file)) {
		$fp = fopen($file, 'wb');
		fwrite ($fp, '');
		fclose ($fp);
	}

	if (is_writable($file)) {
		$fp = fopen($file, 'wb');
		$lock = flock($fp, LOCK_EX);
		if ($lock) {
			fwrite ($fp, $data);
			flock ($fp, LOCK_UN);
			$writable = true;
		} else {
			$GLOBALS['errors']['write_data_to_file'] = "couldn't lock $file";
			$writable = false;
		}
		fclose ($fp);
		clearstatcache();
	} else {
		$GLOBALS['errors']['write_data_to_file'] = "can't write to $file";
		$writable = false;
	}

	return $writable;
}




/*
	Is the file ready for writing?..

	Test for file's existence and writability.
	If it doesn't exist, we attempt to create it.
	If it does exists, we attempt to write to it.

	Provides an early-warning for other functions.
												*/
function verify_writable($file, $add="\n") {

	// no file, let's attempt to create it..
	if (!file_exists($file)) {
			write_data_to_file($file, $add);
			clearstatcache();
	}

	// okay, we have a file now..
	if (file_exists($file)) {

		// perhaps a zero-length man-made file..
		if (filesize($file) == 0) {
			write_data_to_file($file, $add);
			clearstatcache();
		}

		// that didn't work, still zero-length..
		if (filesize($file) == 0) {
			$GLOBALS['errors']['verify_writable'] = "zero-length: $file";
			return false;
		}

		// let's see if we can write to it NOW.
		if (is_writable($file)) {
			return true; // w00t!
		} else {
			$GLOBALS['errors']['verify_writable'] = "can't write to: $file";
			return false;
		}

	// nope, still no file..
	} else {
		$GLOBALS['errors']['verify_writable'] = "does not exist: $file";
		return false;
	}
}



/*
function nice_filesize($file)	*/
function nice_filesize($file) {

	$nice_size = 0;
	if (file_exists($file)) {
		$size = filesize($file);
		if ($size < 1024) {
			$nice_size = $size.' Bytes';
		} elseif (($size >= 1024) and ($size < 1024000)) {
			$nice_size = round($size/1024, 2).' KB';
   		} elseif ($size >= 1024000) {
			$nice_size=round(($size/1024)/1024, 2).' MB';
		}
	}
	return $nice_size;
}/*
end function nice_filesize()   */




/*
increment a counter (v2)	*/
function increment_counter($count_file, $report_only=false, $reset=false) {

	$count = false;

	if (!file_exists($count_file) or $reset) {
		$file_pointer = fopen($count_file, 'wb');
		fwrite ($file_pointer, '0');
		fclose ($file_pointer);
	}

	// now the counter..
	if (file_exists($count_file)) {

		// read in the old score..
		$count = trim(file_get_contents($count_file));
		if ($report_only) { return $count; }
		if (!$count) { $count = 0; }
		$count++;

		// write out new score..
		if (is_writable($count_file)) {
			$file_pointer = fopen($count_file, 'wb+');
			$lock = flock($file_pointer, LOCK_EX);
				if ($lock) {
					fwrite($file_pointer, $count);
					flock ($file_pointer, LOCK_UN);
				}
				fclose($file_pointer);
				clearstatcache();
		}
	}
	return $count;
}




/*
	Generic File Zipping..

	Adds a file to a zip.
	If the zip archive does not exist, it is created.
	The optional 3rd parameter enables you to specify the name
	*inside* the archive, otherwise the full path is stored.

	e.g..
	$return_val = zip_file("./tiffs.zip", "/path/to/image.tiff", "image.tiff");

	Return values..

		0 = Success!
		1 = Error opening zip.
		2 = Error creating new zip.
		3 = Error adding files to an existing zip.

	NOTE:	You need to have the php Zip extension installed for this to work.
			To find out if you do, run my "xt.php", or try zipping something!
																			  */
function zip_file($archive, $file, $name='') {

	$zip = new ZipArchive();

	if (file_exists($archive)) {
		// cannot open existing archive..
		if ($zip->open($archive, ZIPARCHIVE::CHECKCONS) !== TRUE) {
			return 1;
		}
	} else {
		// cannot create new archive..
		if ($zip->open($archive, ZIPARCHIVE::CM_PKWARE_IMPLODE) !== TRUE) {
			return 2;
		}
	}
	// error adding file to archive..
	if ($name) {
		if (!$zip->addFile($file, $name)) {
			return 3;
		}
	} else {
		if (!$zip->addFile($file)) {
			return 3;
		}
	}
	$zip->close();
	return 0;
}


?>