<?php // ۞// text { encoding:utf-8 ; bom:no ; linebreaks:unix ; tabs:4sp ; }
/*

	edit.php	v3.3

	this script is used to edit/delete an existing blog

	a part of corzblog.. http://corz.org/blog/

	;o) Cor

	(c) copyright 2003->today -> cor @ corz.org

*/
require 'init.php';

// cbparser preference overrides..
if ($spam_protection) { $cbparser->_prevent_spam = true; }


$edit_authorized = false;
if ($corzblog['is_authorized']) { $edit_authorized = true; }

// start page
doc_type();

// init
$blog_page = $corzblog['blog_is'];
$state = 'preview';
$jump_add = $post_track = $track_value = '';

if (isset($_POST['preview'])) { $state = 'preview'; }
if (isset($_POST['publish'])) { $state = 'blogging'; }

// first edit (number is sent)..
if (isset($_POST['blog-number'])) {
	$mark_number = $_POST['blog-number'];
	$state = 'first edit';
}

// "about" page editing..
if (isset($_POST[$corzblog['about_name']])) {
	$corzblog['blog_file'] = $corzblog['about_name'].$corzblog['blog_ext'];
	$jump_add = '?archive='.$corzblog['about_name'].'-blog';
	$blog_page = ' "'.$corzblog['about_name'].'" '.$corzblog['blog_is'];
	$post_track = $corzblog['about_name'];
}

// archive editing..
if (isset($_POST['arc-name'])) {
	if (isset($_POST['arc-edit'])) { $state = 'first edit'; }
	$arc_file = $_POST['arc-name']; // => 2004-jun-3
	$mark_number = substr($arc_file, strrpos($arc_file, '-') + 1);// => 3
	$edit_arc_file = substr($arc_file, 0, strrpos($arc_file, '-')); // => 2004-jun
	$corzblog['blog_file'] = $corzblog['archive_dir'].$edit_arc_file.$corzblog['blog_ext'];// => /path/to/arc/2004-jun.blog
	$jump_add = '?archive='.$edit_arc_file;
	$blog_page = ' archive &nbsp;<small>['.$edit_arc_file.']</small>';
	$post_track = 'arc-name';
	$track_value = $arc_file;
}



// collect blog info first, then check for..
if (isset($_POST['delete'])) {
	if ($edit_authorized) {
		$state = 'deleting';
	} else {
		$jump_link = make_jump_link('not authorized to delete at this time..', 2, $corzblog['blogzpath'], true, 'go to blogs');
		$cbparser->_warning_message = do_message('delete not successful!', $jump_link, true);
		$state = 'bad';
	}
}

echo '
<title>edit ',strip_tags($blog_page),' for ', $corzblog['mysite_clean'],'</title>';
output_style_links();
echo '
<script src="inc/js/func.js"></script><noscript><!-- JavaScript Only Functions --></noscript>
<script>
//<![CDATA[
<!--
function doConfirm() {
	return confirm("really delete this blog?");
}
//-->
//]]>
</script>
<noscript><!-- JavaScript Delete Confirmation --></noscript>
</head>
<body>';

// custom header..
if ($corzblog['custom_header']) { include $corzblog['custom_header']; }

echo '
<div id="blog-container">';

echo blog_header('edit '.$blog_page.'..', '['.$state.']');

// sidebar
if ($corzblog['sidebar_first']) { echo sidebar(); }

echo '
<div id="blogzcol">';


// someone is accessing the edit page directly, redirect to choose.php..
if (!isset($_POST['number']) and !isset($mark_number)) {
	$jump_link = make_jump_link('please hold..', 2, $corzblog['blogzpath'].'choose.php', true, 'choose a '.$corzblog['blog_is']);
	echo do_message('no '.$corzblog['blog_is'].' was chosen!', $jump_link, true);
	$state = 'bad';
}


// delete a blog..
if ($state == 'deleting' and $edit_authorized) {
	$i = '';
	if (isset($mark_number)) { $i = $mark_number; }
	if (!is_numeric($i)) { $i = $_POST['number']; }
	do_backup($corzblog['blog_file']);
	$blog_entries = get_blog_entries($corzblog['blog_file']);
	unset($blog_entries[$i]);
	write_blog($corzblog['blog_file'], implode('<!--*end*-->', $blog_entries).'<!--*end*-->');
	$jump_link = make_jump_link('now jumping to undeleted blogs..', 1, $corzblog['blogzpath'].$jump_add, true, 'go to blogs');
	echo do_message('delete successful!', $jump_link);
}


//		[0]	blog body
//		[1]	title
//		[2]	id title
//		[3]	raw title (includes HTML tags)
//		[4] plain text part of "posted by" line


/*
original blog entry..	*/

// first visit to the editing desk?
if ($state == 'first edit') {

	if (is_numeric($mark_number)) {

		// open the blogz file and find the right article
		$blog_entries = get_blog_entries($corzblog['blog_file']);

		// which blog are we editing..
		$this_blog = $blog_entries[$mark_number];
		$blog_parts = get_blog_parts($this_blog);


		$id_title = $blog_parts[2];
		$editable = $cbparser->html2bb($blog_parts[0], $id_title);

		// check the spelling..
		if ($corzblog['spell_checker']) {
			if (!$corzblog['begin_spell_check']) { $spelling->_do_spell_check = false; }
			$this_blog = $spelling->check_spelling($this_blog);
		}

		echo $this_blog;
		echo do_delete_butt();

		// display spelling suggestions..
		if ($corzblog['spell_checker']) {
			$spelling->suggest_words();
		}
		$cbparser->do_bb_form($editable, '', $mark_number, true, $blog_parts[1], true, $post_track, $track_value, 'blogform', true, true, false);
		if ($corzblog['spell_checker']) { $spelling->echo_spelltime(); }
	}
}


// okay, let's attempt to publish..
if ($state == 'blogging') {

	if (isset($_POST['blogtitle'])) {
		$blog_title = do_slashes($_POST['blogtitle']);
	} else {
		$blog_title = '';
	}

	// valid id title..
	$id_title = $cbparser->make_valid_id($blog_title);

	// the html entry..
	$new_xhtml = $cbparser->bb2html(@$_POST['blogform-text'], $blog_title);


	/*
		errors
				*/

	if (empty($blog_title)) { // no title..
		echo do_message('you left the title field blank!',
			'you will need to give your '.$corzblog['blog_is'].' a name..', true);
		$state = 'preview';

	} elseif (empty($_POST['blogform-text'])) { // blank blog..
		echo do_message('your '.$corzblog['blog_is'].' is blank!',
			'you will need to type something..', true);
		$state = 'preview';

	} elseif ($cbparser->_state == 1) { // unbalanced tags..
		$state = 'preview';

	} elseif (!$edit_authorized) { // NO!
		echo do_message('YOU HAVE NOT THE AUTHORITY!!!', '', true);
		$state = 'preview';
	}
}

// state may have been changed due to errors..

/*
	NOW we're publishing..
								*/
if ($state == 'blogging') {

	// okeedokee...
	$i = $_POST['number'];

	// back-up the most recent version, just in case..
	do_backup($corzblog['blog_file']);

	$blog_entries = get_blog_entries($corzblog['blog_file']);
	$blog_parts = get_blog_parts($blog_entries[$i]);
	$blog_entries[$i] = "\n\n\n\n".create_blog_entry($blog_title, $new_xhtml, $blog_parts[4]);
	if (write_blog($corzblog['blog_file'], implode('<!--*end*-->', $blog_entries).'<!--*end*-->')) {
	 // jump to edited article (but not the top entry)..
		if ($i == 0) { $blog_title = ''; } else { $blog_title = '#'.$cbparser->make_valid_id($blog_title); }
		$jump_link = make_jump_link('now jumping to edited blog..', 2, $corzblog['blogzpath'].$jump_add.$blog_title, true, 'go to blog');
		echo do_message('edit successful!', $jump_link);
	}
}

/*
		preview blog...
							*/
if ($state == 'preview') {

	// any important user messages?
	if (!empty($corzblog['admin_warning'])) {
		foreach($corzblog['admin_warning'] as $admin_warning) {
			echo do_message($admin_warning[0], $admin_warning[1], $admin_warning[2]);
		}
	}

	// @ to prevent effin auto-spammers showing up as php errors (notices)

	$i = @$_POST['number'];
	$blog_title = do_slashes(@$_POST['blogtitle']);
	$id_title = $cbparser->make_valid_id($blog_title);


	// let's parse it!
	$new = $cbparser->bb2html(@$_POST['blogform-text'], $id_title);

	// grab _text before it gets transformed by spell-checker.
	$form_textarea = '';
	if (!empty($cbparser->_text)) {
		$form_textarea = $cbparser->_text;
	}


	// check the spelling..
	if ($corzblog['spell_checker']) {
		$spelling->_parse_bbcode = false;
		// we work with the new string because it has been XSS filtered
		// then simply disable bbcode parsing temporarily so example bbcode doesn't initiate the parser /twice/ (_text would become entities!)
		$new = $spelling->check_spelling($new);
	}

	// possible cbparser messages..
	if (!empty($cbparser->_warning_message)) {
		echo '
'.$cbparser->_warning_message.'
<div class="clear-tiny"></div>';
	}

	echo '

<div class="blog-entry">
<div id="'.$id_title.'">
<!--*g*-->
<h1>'.$blog_title.'</h1>
<!--*g*-->'.$new.'<!--*g*-->
</div>
<div class="byline">
posted by '.$corzblog['blogger'].' @ '.$date.'
</div>
<hr class="cb-hr" /><br />
</div>
',do_delete_butt();

	// display spelling suggestions..
	if ($corzblog['spell_checker']) {
		$spelling->suggest_words();
		$spelling->echo_spelltime();
	}
	// the bbcode entry form..
	$cbparser->do_bb_form($form_textarea, '', $i, true, $blog_title, true, $post_track, $track_value, 'blogform', true, true, false);
	if ($corzblog['spell_checker']) {
	}
}

echo '
</div>';



if (!$corzblog['sidebar_first']) { echo sidebar(); }

echo '
<div class="clear-small"></div>';

if (($state != 'preview') and ($state != 'first edit')) { // no footer when editing, makes for easier navigation
	do_foot();
}

echo '
</body>
</html>';



function do_delete_butt() {
global $arc_file, $corzblog, $edit_authorized, $mark_number;

	if (!$edit_authorized) { return; }

	if (!is_numeric($mark_number)) { $mark_number = $_POST['number']; }
	$string = '
<form id="delete-form" method="post" action="'. $_SERVER['SCRIPT_NAME'] .'">
<div class="delete-form">
	<input type="submit" name="delete" id="delete" value="delete this blog" title="Delete this '.$corzblog['blog_is'].'!" onclick="return doConfirm()" />
	<input type="hidden" name="number" value="'.$mark_number.'"/>';
	if ($arc_file) {
		$string .=  '
	<input type="hidden" name="arc-name" value="'.$arc_file.'"/>';
	} elseif (isset($_POST[$corzblog['about_name'].'-blog'])) {
		$string .=  '
	<input type="hidden" name="'.$corzblog['about_name'].'-blog" value="true"/>';
	}
	$string .= '
</div>
</form>';
	return $string;
}

if (!empty($GLOBALS['do_debug'])) {//:debug:
	debug('$GLOBALS: '."\t".print_r($GLOBALS, true)."\nCOMPLETED OUTPUT FOR edit.php\n");//:debug:
	debug_out();//:debug:
}//:debug:

?>