<?php // ۞// text { encoding:utf-8 ; bom:no ; linebreaks:unix ; tabs:4sp ; }
/*

	Easy Peezy PHP Spell-Checker Demo

	This script is to demonstrate the capabilities of the easy peezy php
	spell-checker. Simply load it in your web browser and play with it.

	This script contains a full-blown implementation of the spell-checker,
	with spelling suggestions, AJAX add-to-dictionary facility and more.

	Make Big Fun Now!

	;o) Cor

	(c) 2006->tomorrow! cor + corz.org

*/


// prefs..
//include_once 'spelling.php';

// get these colors from corzblog..
include_once '../init.php';

// the init also loads the spell-checker, so we don't have to do this here..
//$spelling = new spelling();

$site_header = $_SERVER['DOCUMENT_ROOT'].'/inc/header.php';//distro	$site_header = '';

$site_styles = $_SERVER['DOCUMENT_ROOT'].'/inc/css/menu-top.css';//distro	$site_styles = '';


// custom spelling options..
// many of these are the defults anyway, but I put them here to demonstrate the options..
$spelling->_default_user_dic = 'public.dic';

// add to dictionary in the demo?
$spelling->_authorized = true;

// do any AJAX stuff..
$spelling->check_ajax();

$spelling->_dictionary_links = false;

$spelling->_dim_color				= $blog_scheme['spelling_dim'];//'#FFFF00'; // like a highlighter pen through the word.
$spelling->_spelling_highlight		= $blog_scheme['spelling_highlight'];//'#FFFFCC'; // when spelling options are dimmed, what color to use?


// If you enable this, bbcode will be transformed to HTML in the preview..
$spelling->_parse_bbcode = true;


// some string that will test all the options..
$string_to_check = 'Misspelled wyrdz comr baaack hoghlighted!';


// If you plan to support IE7/8 users, include the path to your HTML5 shiv..
$HTML5_shiv = '';	//distro	$HTML5_shiv = '';	// $HTML5_shiv = '/inc/js/html5.js';



// ok, let's go spell-check..
//

// spit out the demo page..
if (isset($_POST['checkspelling'])) {
	if (!empty($_POST['corzspell'])) { $string_to_check = $_POST['corzspell']; }
}
echo '<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="initial-scale=1.0, width=device-width" />
<title>php spell check test page. fast spell-checking and word suggestion with &quot;sounds-like&quot; and fuzzy matching.. corz easy peezy php spell-checker v',$spelling->_version,'</title>
<meta name="description" content="a lean, fast, php spell checker. useful for spell-checking all sorts of documents. my site comments now use it, amongst other things. the spell-checker can also suggest words for you using levenshtein and metaphone algorithms" />';
if (isset($HTML5_shiv)) {
	echo '
<!--[if lt IE 9]><script src=',$HTML5_shiv,'</script><![endif]-->';
}
echo '
<link rel="stylesheet" href="/blog/inc/themes/original/original.css" type="text/css" media="screen" />';
if (file_exists($site_styles)) {
	echo '
<link rel="stylesheet" href="',$site_styles,'" type="text/css" media="screen" />';
}
echo '
</head>
<body>';
if (file_exists($site_header)) {
	include $site_header;
}
$bbp_notice = '';
if ($spelling->_parse_bbcode) {
$bbp_notice = '<br /><div style="font-size: 42%; margin-top: 0;">&thinsp;(bbcode &gt; HTML parsing enabled)</div>';
}
echo '
<div id="spellchecker">
	<h1>Check your spelling..',$bbp_notice,'</h1>';

	// do spell-checking..
	if ((isset($_POST['checkspelling'])) and (!empty($string_to_check))) {
		echo '
	<blockquote>
			',$spelling->check_spelling($string_to_check),'
	</blockquote>';
	}

	if ($spelling->_parse_bbcode) { $bb_string = ' <span onmouseover="this.style.backgroundColor=\'#fff\'" onmouseout="this.style.backgroundColor=\'transparent\'" title="If you enter any bbcode tags, the whole post is considered to be bbcode">bbcode</span> or'; } else { $bb_string = ''; }

	echo '
	<hr style="text-align:left;margin-left:0;" /><br />

	<div id="nosuggest">
		<small>[misspelled words come back <span style="background-color:'.$spelling->_spelling_highlight.'">highlighted</span>]</small>
	</div>
	<form name="blogform" id="blogform" method="post" action="'.$_SERVER['SCRIPT_NAME'].'">
	<div class="form">
		<label><strong>enter x|html or',$bb_string,' plain text here..</strong><br />
		<textarea name="corzspell" id="corzspell" rows="10" cols="60">',$string_to_check,'</textarea><br />
		</label>';

		$spelling->output_spell_options();

		echo '
		<div id="check-it">
			<input type="submit" name="checkspelling" id="checkspelling" value="check it!" title="check your spelling!" />
		</div>
	</div>
	</form>
	<div style="height:4rem;"></div>';

	// format dubious words list..
	if ((isset($_POST['checkspelling'])) and (!empty($string_to_check))) {
		if ($spelling->_do_suggest) {
			$spelling->suggest_words();
		} else {
			if (!empty($spelling->_misspelled_words)) {
				echo '
	<div class="spelling" id="mis-spelling">
		<h4>spelling..</h4>
		<code>Found these dubious words:</code>
		<div class="dubious-words">
			',$spelling->make_list_of_bad_words(),'
		</div>
	</div>
	<br />';
				}
			}
		$dict_str = 'these <em>user</em> dictionaries';
		if (count($spelling->_user_word_lists) == 1) { $dict_str = 'this <em>user</em> dictionary'; }
		if (!empty($spelling->_misspelled_words)) {
			echo '
	<br />
	Current spell-check dictionary: <span class="teletype">',basename($spelling->_default_word_list),'</span><br />
	Also using ',$dict_str,': <span class="teletype">',$spelling->get_user_lists(),'</span>
	<br />
	<br />
	<span class="teletype">Total time taken: '.substr($spelling->_total_time, 0, 5).' seconds</span><br />';
		}
	}
echo '
</div>
<div class="clear-big"></div>';
include 'footer.php';
echo '
</body>
</html>';

?>