<?php // ۞// text { encoding:utf-8 ; bom:no ; linebreaks:unix ; tabs:4sp ; }
//echo '<pre>GLOBALS:',htmlentities(print_r($GLOBALS,true)),'</pre>';//:debug

// blog init..
require_once '../init.php';

/*
	scheme-edit.php		v0.9.3

	This version does corzblog AND site schemes, all-together now!

	The corzblog color-scheme editor..

	This brings up your current color scheme for editing, with funky dynamic color inputs and a cool JavaScript Color
	Picker, courtesy of David Durman, with a few wee tweaks from me, of course.

	You can switch between all available schemes, editing and updating the color values, as well as create and edit new
	schemes, either a direct copy of the current scheme, or a new scheme from the currently selected colors.

	There is a demo output area where you can see all the colors in action, live. The background color for that area is
	controlled by whatever you have set as your background color preference.

	NOTE: Whatever scheme you are working on becomes the default scheme for *your* view of your blog, so you can preview
	the actual pages as they would actually appear using the new scheme, browse around and such. Your visitors still see
	whatever scheme you have set in your master preferences (/admin.php).

	As well as being the resident corzblog scheme editor, it would be trivial to use this for your own projects, and it
	was coded with this in mind. All you need is an ini file with one or more sections in it. Let scheme edit do the
	rest.

	Of course, it goes without saying that for this to work, the ini file must be writeable by the server process. If
	you are running php as a CGI, it probably already is. If not, do chmod 777 on the file before attempting to save
	any changes.

	;o) Cor

	NOTE: If you make a copy of a scheme and name it "something-backup", it will then be ignored when displaying lists
	of schemes (in the scheme selector)

*/


//** Prefs..

// the CSS file we will draw basic style elements from, generally the default style sheet ("original").
// or better yet, if this is corzblog we're in, start with the "current theme"..
$scheme_edit['back_end_theme'] = $corzblog['current_theme'];

// default color scheme to load when none is selected..
$scheme_edit['default_scheme'] = $corzblog['current_scheme_name'];


// scheme data is stored in this file..
//
$scheme_edit['schemes_ini'] = $corzblog['path'].'/inc/themes/'.$corzblog['current_theme'].'/'.$corzblog['current_theme'].'.ini';


// this gets used to set background colors in the demo. For corzblog, it's "bg_color", e.g. (in the ini)..
//
// [scheme_name]
// bg_color = "#ffffff"
//
// regardless of what you are doing with your outer page styles, this color will always be used for the preference color area.
//
$scheme_edit['bg_color_name'] = 'bg_color';


// The demo area has a background which changes color dynamically as you alter your background color preference, which
// is why you specified it (above). In addition to this, we can show the background color as a clickable label along
// with the other demo colors, its background the /opposite/ color, so you can see it - like the main color readout,
// except in amongst the other demo colors. It's a bit ugly, but quite handy, your call..
//
$scheme_edit['bg_demo_block'] = true;


// if you prefer, you can have scheme-edit force the background background (sic) color to the extreme end of
// opositeness, i.e. white or black. This affects the color readout and demo color block ($scheme_edit['bg_demo_block'], if enabled).
$scheme_edit['force_blackwhite'] = false;
//
// remember, the actual background changes to match the currently selected color, so these things are purely optional!


// Add missing values?
// When you create a new scheme with the <SAVE> button, scheme-editor can scan all your CSS files for %%tokens%% and
// add any that are missing from the scheme. Nifty.
$scheme_edit['add_missing_prefs'] = true;


// remove empty prefs..
//
// If you wipe the value for a preference and save your scheme, scheme-edit will delete that preference from your ini.
// Or not..
$scheme_edit['remove_empty_prefs'] = false;


// When saving the colors, to avoid warnings (see below) we immediately refresh the page. If you have anti-hammer
// capabilities on your site, you will probably want to set this to slightly above the hammer threshold..
// (values in seconds, decimal fractions are ok).
//
$scheme_edit['hammer_delay'] = 1;//distro:	$scheme_edit['hammer_delay'] = 0;	// == no delay.


// When you refresh a page that has previously sent POST data (a form), your browser will warn you about re-submitting
// this data. To avoid this, scheme-edit can refresh the page immediately without the POST data so that if you later
// refresh the scheme, you can do so without any warnings.
//
// NOTE: If you have $scheme_edit['hammer_delay'] (above) set, this will be respected during the refresh. Because of this, loading
// schemes will always be faster with $scheme_edit['avoid_warnings'] set to false. When saving schemes there is *always* a refresh, so
// you can see the new prefs into your inputs.
//
$scheme_edit['avoid_warnings'] = 1;



$scheme_edit['die_err_msg'] = '<!DOCTYPE HTML SYSTEM>
<html>
<body>
<pre>There was an error writing to <strong>'.$scheme_edit['schemes_ini'].'</strong>

Please make the file writeable (maybe <strong>chmod 777</strong>)
then go back and try again (or simply refresh this page).</pre>
</body>
</html>';


// If you wish to support IE7/8 users, add an HTML5 shiv..
$scheme_edit['HTML5_shiv'] =  '';	//$scheme_edit['shiv'] =  '/inc/js/html5.js';



//
// end prefs.





//** Begin..
//

// scanning for CSS files where..
$scan_path = array('themes/');

// this is in addition to any css files found inside your current theme directory..
$scan_files = array('scheme-edit.css', 'admin.css');
$missing_array = array();


// authorized to make changes?
$color_authorized = false;
if ($corzblog['is_authorized']) { $color_authorized = true; }


// user cancelled rather than login, or pressed "reset" on edit page..
if (isset($_GET['cancel']) or isset($_POST['reset'])) {
	unset($_SESSION['scheme_edit']);
	unset($_SESSION['current_scheme_name']);
	if ($scheme_edit['avoid_warnings']) {
		uSleep($scheme_edit['hammer_delay'] * 1200000);
		die(header('Location: http://'.$_SERVER['HTTP_HOST'].$_SERVER['SCRIPT_NAME']));
	}
}


//** Set Default Scheme

// which theme is the default scheme?
$current_scheme_name = $scheme_edit['default_scheme'] ;


// override current scheme name with session scheme name, if it exists..
if (!empty($_SESSION['scheme_edit']['current_scheme_name'])) {
	$current_scheme_name = $_SESSION['scheme_edit']['current_scheme_name'];
}

//** Load a scheme..

// user loads a scheme..		// it has two functions, better check..
if (!empty($_POST['scheme-selector']) and !isset($_POST['delete'])) {
	$current_scheme_name = $_POST['scheme-selector'];
	$_SESSION['scheme_edit']['current_scheme_name'] = $current_scheme_name;
	if ($scheme_edit['avoid_warnings']) {
		//2do ... check it's in schemes array, first
		$_SESSION['scheme_edit']['current_scheme_name'] = $current_scheme_name;
		// remember most recent sort action - we will use this until set otherwise..
		$_SESSION['scheme_edit']['sort'] = @$_POST['sort'];

		uSleep($scheme_edit['hammer_delay'] * 1200000);
		die(header('Location: http://'.$_SERVER['HTTP_HOST'].$_SERVER['SCRIPT_NAME']));
	}
}


// read the prefs from the schemes ini..
$blog_scheme_config = grab_ini($scheme_edit['schemes_ini']);


// invalid scheme specified - use default scheme..
if (!isset($blog_scheme_config[$current_scheme_name]) or !is_array($blog_scheme_config[$current_scheme_name])) {
	$current_scheme_name = $scheme_edit['default_scheme'];
}


// assign the current theme array to $blog_theme, for later use..
$blog_scheme = $blog_scheme_config[$current_scheme_name];


// now we know which scheme we are working with.
// when this is set, corzblog styles will be overridden by this value.
$_SESSION['current_scheme_name']	= $current_scheme_name;		// string - name
$_SESSION['current_scheme']			= $blog_scheme;				// array - the scheme values




//** POST Variables..

// which string to use for the NO AUTH/login page..
switch (true) {
    case !empty($_POST['delete']):
        $act_str = 'delete';
        break;
    case !empty($_POST['scheme_copy_name']) or !empty($_POST['scheme_new_name']) :
        $act_str = 'create';
        break;
    case !empty($_POST['prefs_array']):
        $act_str = 'save';
        break;
    default:
        $act_str = 'modify';
        break;
}

$die_auth_msg = '<!DOCTYPE html>
<html lang="en">
<head>
<meta name="viewport" content="initial-scale=1.0, width=device-width" />
<meta charset="utf-8">
<title>You have not the authoritee!</title>
<style media="screen">
/*<![CDATA[*/
<!--
html { font-size: 62.5%; }
body {
	font-family: Tahoma, "Lucida Grande", "Trebuchet MS", Trebuchet, Verdana, sans-serif;
	color: #000;
	width: 600px;
	margin: 0 auto;
}
h1, .warnform {
	font-size: 175%;
	margin-top: 4rem;
}
.auth-container {
	margin-top: 6rem;
}
.auth-text, .auth-note {
	color: #dd6a15;
}
.auth-note {
	font-size: 67%;
}
#warnform {
	width: 300px;
	margin-top: 2rem;
}
#notice {
	margin-top: 4rem;
	font-size: 90%;
}
//-->
/*]]>*/
</style>
'.$auth->getAuthCode().'
</head>
<body>
<h1>You have no authority to '.$act_str.' schemes!</h1>
<form id="login" method="post" action="'.$_SERVER['SCRIPT_NAME'].'">
<div class="auth-container">
'. $auth->getLoginForm(true).'
</div>
</form>
<noscript>
press your back button to return to the edit page
</noscript>';
if (empty($_POST['delete'])) {
	$die_auth_msg .= '
<div id="notice">
	Note: if login is successful, your changes will be applied immediately.
</div>';
}
$die_auth_msg .= '<script type="text/javascript">
//<![CDATA[
<!--
document.write("<form id=\"warnform\" method=\"post\" action=\"\"><div class=\"warnform\"><input title=\"this button needs javascript\" type=\"button\" name=\"back\" value=\" cancel \" onclick=\"location.href=\'http://'.$_SERVER['HTTP_HOST'].$_SERVER['SCRIPT_NAME'].'?cancel\'\" \/><\/div><\/form>");
//-->
//]]>
</script>
</body>
</html>';




//2do add-missing to here, too

//** Copy A Scheme..

if (!empty($_POST['scheme_copy_name'])	// name sent/stored, but no colors, so must be a copy operation..
	or (!empty($_SESSION['scheme_edit']['scheme_name']) and empty($_SESSION['scheme_edit']['prefs_array']))) {

	if ($color_authorized === true) {

		// new login..
		if (!empty($_SESSION['scheme_edit']['scheme_name'])) {
			$new_scheme_name = $_SESSION['scheme_edit']['scheme_name'];
			unset($_SESSION['scheme_edit']['scheme_name']);
		} else {
			$new_scheme_name = $_POST['scheme_copy_name'];
		}

		$blog_scheme_config[$new_scheme_name] = $blog_scheme;
		$blog_scheme_config[$new_scheme_name]['name'] = $new_scheme_name;


		if (!write_ini_array_to_file($blog_scheme_config, $scheme_edit['schemes_ini'])) {
			die($scheme_edit['die_err_msg']);
		}
		$_SESSION['scheme_edit']['current_scheme_name'] = $new_scheme_name;
		uSleep($scheme_edit['hammer_delay'] * 1200000);
		die(header('Location: http://'.$_SERVER['HTTP_HOST'].$_SERVER['SCRIPT_NAME']));

	} else {
		if (!isset($_SESSION['scheme_edit']['scheme_name'])) {// <-- in case their password fails one or more times.
			// store the name in the session. If login is successful, we will apply next time around..
			$_SESSION['scheme_edit']['scheme_name'] = $_POST['scheme_copy_name'];
		}
		die($die_auth_msg);
	}
}





//** Delete A Scheme..

if (!empty($_POST['delete'])) {
	if ($color_authorized === true) {
		unset($blog_scheme_config[$_POST['delete']]);
		if (!write_ini_array_to_file($blog_scheme_config, $scheme_edit['schemes_ini'])) {
			die($scheme_edit['die_err_msg']);
		}
		$_SESSION['scheme_edit']['current_scheme_name'] = $scheme_edit['default_scheme'];
		uSleep($scheme_edit['hammer_delay'] * 1200000);
		die(header('Location: http://'.$_SERVER['HTTP_HOST'].$_SERVER['SCRIPT_NAME']));

	} else {
		// we won't store delete actions, it's trivial to click that again and we avoid a big can of worms.
		die($die_auth_msg);
	}
}




//** Save colors to current/new scheme..
//
if (!empty($_POST['prefs_array']) or !empty($_SESSION['scheme_edit']['prefs_array'])) {

	if ($color_authorized === true) {

		$save_name = $current_scheme_name;
		$got_new = false;

		if (!empty($_SESSION['scheme_edit']['scheme_name'])) {
			$save_name = $_SESSION['scheme_edit']['scheme_name'];
			$got_new = true;
		}
		if (!empty($_SESSION['scheme_edit']['prefs_array'])) {
			$replace_with = $_SESSION['scheme_edit']['prefs_array'];
		}

		if (!empty($_POST['scheme_new_name'])) {
			$save_name = trim($_POST['scheme_new_name']);
			$got_new = true;
		}

		if (!empty($_POST['prefs_array'])) {
			$replace_with = $_POST['prefs_array'];
		}


		// new scheme - create new scheme based on current scheme..
		// Note: "name" is never sent by the form. Either it passes through from $current_scheme_name for an existing
		// scheme, or else we set it here, for a new scheme..
		if ($got_new) {
			$blog_scheme_config[$save_name] = $blog_scheme_config[$current_scheme_name];
			$blog_scheme_config[$save_name]['name'] = $save_name;
		} // alternativelty, we could remove it on load and always set it on save. hmm.


		// merge the new preferences in (the easy way!)..
		$blog_scheme_config[$save_name] = array_merge($blog_scheme_config[$save_name], $replace_with);

		// add missing prefs..
		if ($got_new and $scheme_edit['add_missing_prefs'] == true) {
			$missing_prefs = get_missing_prefs();
			$blog_scheme_config[$save_name] = array_merge($missing_prefs, $blog_scheme_config[$save_name]);
		}

		// filter..
		if ($scheme_edit['remove_empty_prefs']) {
			$removed = array_filter($blog_scheme_config[$save_name], 'isit_empty'); //2do - isitempty
			$blog_scheme_config[$save_name] = $removed;
		}


		// write out the updated ini array, or exit..
		if (!write_ini_array_to_file($blog_scheme_config, $scheme_edit['schemes_ini'])) {
			die($scheme_edit['die_err_msg']);
		}

		// slightly redundant, but safer..
		unset($_SESSION['scheme_edit']['scheme_name']);
		unset($_SESSION['scheme_edit']['prefs_array']);

		// it's all good - we can set the possibly new current scheme name into the session..
		$_SESSION['scheme_edit']['current_scheme_name'] = $save_name;

//		// set a cookie..
//		setcookie('scheme', $save_name, time() + (365*24*60*60), '/');	// a year

		// refresh the page..
		uSleep($scheme_edit['hammer_delay'] * 1200000);
		die(header('Location: http://'.$_SERVER['HTTP_HOST'].$_SERVER['SCRIPT_NAME']));

	} else {

		// just like unauthorized new schemes, we store it in the session for next time around..
		// we need to sanitize this..

		if (!isset($_SESSION['scheme_edit']['prefs_array'])) {
			$_SESSION['scheme_edit']['prefs_array'] = $_POST['prefs_array'];
		}
		if (!empty($_POST['scheme_new_name'])) {
			if (!isset($_SESSION['scheme_edit']['scheme_name'])) {
				$_SESSION['scheme_edit']['scheme_name'] = $_POST['scheme_new_name']; // we re-use this variable
			}
		}
		die($die_auth_msg);
	}
}




//// regardless of how we got here, set the currently-editing scheme as the current viewing scheme in the session..
//$_SESSION['scheme_edit']['current_scheme_name'] = $current_scheme_name;



//** init..

$i = 1;
$init_bg = '';
$first_key = '';
$first_value = '';
$demo_string = '';
$col_inputs_string = '';
$non_col_inputs_string = '';





//** sort the prefs..

$sort_type = false;
$names_checked = $values_checked = $none_checked = '';


if (isset($_SESSION['scheme_edit']['sort'])) {
	$sort_type = $_SESSION['scheme_edit']['sort'];
//	unset($_SESSION['scheme_edit']['sort']);
}

if (isset($_POST['sort']) and !empty($_POST['sort'])) {
	$sort_type = $_POST['sort'];
}


switch ($sort_type) {

	case 'values':
		// sort by values..
		asort($blog_scheme);
		$values_checked = 'checked';
		break;

	case 'names':
		// sort by keys - i.e. pref names..
		ksort($blog_scheme);
		$names_checked = 'checked';
		break;

	default:
		// no sorting
		$none_checked = 'checked';
}






//** The Loops..



// setup some HTML to spit out later (loop once, create twice).
foreach ($blog_scheme as $key=>$value) {


	// hex color values..
	//
	if (substr($value, 0, 1) == '#') {
		$demo_insert = 'style="color: '.$value.'"';
		if ($key == $scheme_edit['bg_color_name']) {
			if ($scheme_edit['bg_demo_block']) {
////				$demo_insert = 'style="background-color:'.invert_colour($value).'; color: '.$value.';"';
			} else {
				$demo_insert = 'style="display:none"';
			}
			$init_bg = $value; // grab this now
		}
		$i += 1;
		$demo_string .= '
		<span class="color-view" '.$demo_insert.' id="'.$key.'"><label for="prefs_array['.$key.']">'.$key.'</label></span>&nbsp;';

		// we store these to set the color picker to the correct color on load..
		if (!$first_value) { $first_value = $value; }
		if (!$first_key) { $first_key = $key; }

		$col_inputs_string .= '
		<label class="colorlabel">'.$key.': <input id="prefs_array['.$key.']" name="prefs_array['.$key.
			']" type="text" class="color-inp" value="'.$value.'" style="background-color: '.$value.
			'" onClick="setCurrentInput(this);" onFocus="this.select();" /></label>'; // setting the event handlers locally saves a *lot* of trouble!


	// everything else..
	//
	} else {
		if ($key != 'name') { // for internal use only!
			$non_col_inputs_string .= '
			<div class="noncolor-row"><label class="noncolorlabel">'.$key.': <input id="prefs_array['.$key.
				']" name="prefs_array['.$key.']" type="text" class="noncolorinput" value="'.$value.
					'"  onClick="setCurrentInput(this);" onFocus="this.select();" /></label></div>';
		}
	}
}


// for spitting out..
$JS_fbw = ($scheme_edit['force_blackwhite']) ? 'true' : 'false';




//** Page Proper..
//
echo '<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="initial-scale=1.0, width=device-width" />
<title>scheme editor for corzblog..</title>
<meta name="author" content="http://corz.org/" />
<meta name="publisher" content="http://',$_SERVER['HTTP_HOST'],'" />
<meta name="description" content="set the colors for the current corzblog theme" />
<meta name="generator" content="http://corz.org/engine?download=corzblog.zip" />
<link rel="stylesheet" href="/blog/inc/themes/',$scheme_edit['back_end_theme'],'/',$scheme_edit['back_end_theme'],
	'.css?colors='.$current_scheme_name.'" type="text/css" media="screen" />
<link rel="stylesheet" href="/blog/inc/themes/scheme-edit.css?colors='.$current_scheme_name.'" type="text/css" media="screen" />';
if (file_exists($corzblog['path'].'/inc/themes/'.$scheme_edit['back_end_theme'].'/scheme-edit.css')) {
	echo '
<link rel="stylesheet" href="',$corzblog['blogzpath'],'inc/themes/',$scheme_edit['back_end_theme'],'/scheme-edit.css?colors='.
	$_SESSION['scheme_edit']['current_scheme_name'].'" type="text/css" media="screen" />';
}
// admin user..
if ($color_authorized === true) {
	if (isset($scheme_edit['HTML5_shiv']) and !empty($scheme_edit['HTML5_shiv'])) {
		echo '
<!--[if lt IE 9]><script src="',$scheme_edit['HTML5_shiv'],'"></script><![endif]-->';
	}
	//*>	Begin JavaScript..
	echo '
<script type="text/javascript" src="/blog/inc/js/colorpicker.js"></script>
<script type="text/javascript">
//<![CDATA[
<!--
var current_input;
var current_demo;
var hex;

// this is called when you click on an input..
function setCurrentInput(tt) {

	current_input = tt;
	var len = tt.id.length;
	current_demo = tt.id.substring(12,len-1); // e.g.. "bg_color" or "a_active"
	// set the current pref name and color/picker..
	document.getElementById("current-color").innerHTML = "current color: <span id=\"curr-col\">" + current_demo + \'</span>\';
	document.getElementById("curr-col").style.color = tt.value;
	cp.setHex(tt.value);
}


function SetDemoBG(hexColor) {
	// the main background area..
	document.getElementById("colors-demo").style.backgroundColor = hexColor;

	// now any demo color block, if the user enabled that. (may be hidden - i.e. set to display: none)
	var demoBlock = document.getElementById("',$scheme_edit['bg_color_name'],'");
	var isDisplayed = window.getComputedStyle(demoBlock, null).getPropertyValue("display");
	if (isDisplayed != "none") {
		var opcol = returnOpposite(hexColor)
		demoBlock.style.backgroundColor =  opcol;
		demoBlock.style.color = hexColor;
	}
}

function decimalToHex(decimal) {
  var hexnum = decimal.toString(16);
  if (hexnum.length == 1) hexnum = "0" + hexnum;
  return hexnum;
}
function hexToDecimal(hexnum) { return parseInt(hexnum,16); }

function returnOpposite(colour) {
	colour = colour.substr(1)
	var forceBlackWhite = ',$JS_fbw,';
	var thisRed = hexToDecimal(colour.substr(0,2));
	var thisBlue = hexToDecimal(colour.substr(2,2));
	var thisGreen = hexToDecimal(colour.substr(4,2));
	if (forceBlackWhite) {
		if ( ((thisRed * 1) + (thisBlue * 1) + (thisGreen * 1)) < 384 ) {
			thisRed = 255; thisBlue = 255; thisGreen = 255;
		} else {
			thisRed = 0; thisBlue = 0; thisGreen = 0;
		}
	} else {
		thisRed = 255 - thisRed; thisBlue = 255 - thisBlue; thisGreen = 255 - thisGreen;
	}
	return "#" + decimalToHex(thisRed) + decimalToHex(thisBlue) + decimalToHex(thisGreen);
}


function DeleteScheme() {
	var ds = document.getElementById("scheme-selector");
	var SelectedScheme = ds.options[ds.selectedIndex].value;

	if (doConfirm(SelectedScheme)) { /* Oh! This feels clever! */
		document.getElementById(\'switch\').innerHTML += "<input type=\"hidden\" name=\"delete\" value=\"" + SelectedScheme + "\"/>";
		document.getElementById(\'switch\').submit();
	}
}

function MakeNewPref() {
	var prefName = prompt("Enter a name for the preference : \n\nPlease ensure it contains only alphanumerics and underscores.\nAlso, it must not begin with a number.\n\n", "some_preference");
	if (document.getElementById("prefs_array[" + prefName + "]")) {
		alert("\"" + prefName + "\" already exists!");
		return;
	}

	// Javascript switch sucks!
	var valid = true;
	if ( prefName == "" )							{ valid = "is empty!"; }
	if ( prefName == "null" || prefName == null )	{ valid = "is null and void!"; }
	if ( /[0-9]/.test(prefName.substr(0,1)) )		{ valid = "starts with a number!" }
	if ( is_int(prefName) )							{ valid = "is a number!"; }
	if ( !/^[a-zA-Z0-9_]+$/.test(prefName) )		{ valid = "contains illegal characters!"; }

	if ( valid == true) {

		// store current inputs so new ones do not get wiped..
		var f = document.forms["ColorForm"];
		var a = new Array();
		for(var i = 0; i < f.length; i++) {
			if (f.elements[i].type == "text") {
				a[i] = f.elements[i];
				a[i][1] = f.elements[i].value;
			}
		}
		document.getElementById("non-hex-colors").innerHTML += "<div class=\'noncolor-row\'><label class=\'noncolorlabel\'>" + prefName + ": <input id=\'prefs_array[" + prefName + "]\' name=\'prefs_array[" + prefName + "]\' type=\'text\' class=\'noncolorinput\' value=\'\' onFocus=\'this.select();\' /></label></div>";
		// put back the values..
		for(var i = 0; i < a.length; i++) {
			f.elements[i].value = a[i][1];
		}
	} else {
		alert("\"" + prefName + "\" " + valid );
	}
}

function is_int(value) {
  if ( (parseFloat(value) == parseInt(value)) && !isNaN(value) ) {
      return true;
  } else {
      return false;
  }
}


function doConfirm(ss) {
	adJextive = [
		"superb",
		"awesome",
		"emotionally engaging",
		"truly captivating",
		"incredible",
		"reasonably okay if you like that sort of thing",
		/* "derivative and uninspiring", */ /* just kidding! */
		"beautiful"
	]
	randnum = Math.floor ( Math.random() * adJextive.length );
	return confirm("You really want to delete a scheme as " + adJextive[randnum] + " as \'" + ss + "\'?");
}

//-->
//]]>
</script>';
}

//** -------- End JavaScript -----------


echo '
</head>
<body>
<div class="uplink"><a href="../" title="go up to the blog">up to the blog</a></div>
<div class="content" id="colorchoose">
<div class="clear"></div>';


//** The Color Picker..

if ($color_authorized === true) {


	echo '
	<noscript>
		<div id="warning">
			You NEED JavaScript for this page to be funky!<br />
			<br />
			Note: You can still edit and save the values for the theme, but the Color Picker, along with all the auto-fill goodies, will not work.
		</div>
	</noscript>

	<div id="color-picker" class="cp-default">
		<div class="picker-wrapper">
			<div id="picker" class="picker"></div>
			<div id="picker-indicator" class="picker-indicator"></div>
		</div>
		<div class="slide-wrapper">
			<div id="slide" class="slide"></div>
			<div id="slide-indicator" class="slide-indicator"></div>
		</div>
	</div>';


	//** Color Value Output..

	echo '
	<div id="color-values">
		<h1>editing &quot;',$current_scheme_name,'&quot;..</h1>
		<h3 id="current-color">current color: <span id=\'curr-col\'>',$first_key,'</span></h3>
		<ul id="curr-ul">
			<li>rgb: <span id="rgb">rgb(255,0,0)</span></li>
			<li>hsv: <span id="hsv">hsv(0.2,1,1)</span></li>
			<li>hex: <span id="hex">#FF0000</span></li>
		</ul>
	</div>';


	//** Begin Scheme Controls..
	echo '
		<div id="scheme-controls">';


	// Scheme Selector..
	//

	// start the form. we'll put stuff in it.
	echo '
			<form id=\'switch\' method="post" name=\'switch\' action="',$_SERVER['SCRIPT_NAME'],'" >';



//** Sort Controls..
	echo '
		<div id="sort-buttons">
			<input type="radio" id="sort-by-names" name="sort" value="names" title="sort the preferences by their names - this probably creates the most readable page.
[note: this will immediately load/revert the scheme]" ',$names_checked,' onclick="document.getElementById(\'switch\').submit();" /><label for="sort-by-names" title="sort the preferences by their names - this creates the most readable page.
[note: this will immediately load/revert the scheme]"> sort by names.. </label>

			<input type="radio" id="sort-by-values" name="sort" value="values" title="sort the preferences by their values - this can be useful for grouping preferences.
[note: this will immediately load/revert the scheme]" ',$values_checked,' onclick="document.getElementById(\'switch\').submit();" /><label for="sort-by-values" title="sort the preferences by their values - this can be useful for grouping preferences.
[note: this will immediately load/revert the scheme]"> values.. </label>

			<input type="radio" id="sort-by-none" name="sort" value="none" title="do not sort the preferences - list them in the same order as inside the ini file.
[note: this will immediately load/revert the scheme]" ',$none_checked,' onclick="document.getElementById(\'switch\').submit();" /><label for="sort-by-none" title="do not sort the preferences - list them in the same order as inside the ini file.
[note: this will immediately load/revert the scheme]"> none..</label>
		</div>';


	echo '
		<div id="selector-form">';

	echo '
			<select name="scheme-selector" id="scheme-selector" title="here you can select a scheme from the currently available color schemes">';
	foreach ($blog_scheme_config as $ini_section) {
		if (substr($ini_section['name'], -7) != '-backup') {
			$selected = '';
			if ($current_scheme_name == $ini_section['name']) { $selected = ' selected'; }
			echo '
				<option value="',$ini_section['name'],'"',$selected,'>',$ini_section['name'],'</option>';
			}
		}

	echo '
			</select>
			<input type="submit" id="load-butt" value="load" title="load/revert the selected scheme..
	[note: clicking a sort option also does this]" />';

	//** Delete Scheme Button..
	echo '
			<input type="button" id="delete-butt" value="delete" title="delete the currently selected scheme from your color schemes..
[note: this cannot be undone!]" onClick="DeleteScheme();return false;"/>';

	// end the selector form..
	echo '
		</div>
		</form>';


	//** Copy Scheme Button (form)..
	echo '

		<form id="scheme-copy" method="post" name="scheme-copy" action="',$_SERVER['SCRIPT_NAME'],'" >
		<div class="form">
			<input type="text" size="7" class="copyname" id="scheme_copy_name" name="scheme_copy_name" title="enter the name for your copied scheme then click [copy]" />
			<input type="submit" id="copy-butt" value="copy" title="create a new color scheme based on the current color scheme (a copy).." />
		</div>
		</form>';

	// box and close the scheme-controls..
	echo '

	</div>
	<div class="clear"></div>';


	//** Clickable Demo Color Output..
	echo '
	<form id="ColorForm" method="post" name="ColorForm" action="',$_SERVER['SCRIPT_NAME'],'" >
	<div id="colors-demo" title="Color Demo Area: the color of each will change dynamically to match the currently picked color for that preference.
Note: you can click the text here to immediately select the corresponding input.">';
	echo $demo_string;
	echo '
	</div>
	<div class="clear"></div>

	<div id="color-input-output">';


	//** Dynamic color inputs
	//   non-hex-color inputs and SAVE/NEW..
	echo $col_inputs_string;
	echo '
	</div>
	<div class="clear"></div>
	<div id="non-color-inputs">
		<div class="clear"></div>
		<h3 title="non-hex colors, image paths and other theme-specific preferences..">other elements..</h3>
		<div id="non-hex-colors">
			',$non_col_inputs_string,'
		</div>
		<div class="clear-tiny"></div>';


//** Add a new preference (JavaScript-activated)..
//
echo '
<input type="button" value="new preference" onclick="MakeNewPref()" title="Add a New Preference
[Requires JavaScript]"/>';
	$add_note = '';
	if ($scheme_edit['remove_empty_prefs']) {
		$add_note = '
[NOTE: Empty preferences will be removed!]';
	}
	echo '
		<input type="text" id="scheme_new_name" name="scheme_new_name" title="If you wish to save the current colors to a new scheme, enter its name here.',$add_note,'" />
		<input type="submit" id="save-butt" value="save" title="save the above preferences to the current scheme, or a completely new color scheme.',$add_note,'" />
		<input type="submit" id="new-butt" value="new" title="create a completely new, blank color scheme." />
		<input type="hidden" name="scheme" value="',$current_scheme_name,'"/>
	</div>
	</form>
	<div class="clear"></div>';





//** Tips!
//
echo '

	<div id="tips">
		<h3>tips:</h3>
		<ul>
			<li>Click inside any color input (or demo text) to activate changes for that color preference. Pick to change color!</li>
			<li>On some browsers, only when you <em title="thereafter it\'s click. click. click. BUT.. see the next tip.." style="font-weight: bolder;">first</em> click on the picker (or slider) can you hold the button down for live color adjustment. </li>
			<li>On some browsers, if you click and drag the picker or slider <em title="importantly, don\'t slide outside the boundaries of the image itself" style="font-weight: bolder;">slightly</em> then let go, you can get live color by simply hovering. Click to pick.</li>
			<li>To quickly create a new color: Add a pref. Set it to "#". Save. It will now appear among the other color inputs.</li>
			<li>Whatever scheme you select here becomes your active scheme for viewing corzblog. And there\'s your preview function right there! Of course, everyone else sees whatever is set in your prefs. The big reset button resets this for you, too.</li>
		</ul>
	</div>
	<div class="clear-small"></div>

<script type="text/javascript">
//<![CDATA[
<!--

cp = ColorPicker(document.getElementById("slide"), document.getElementById("picker"),
	function(hex, hsv, rgb, mousePicker, mouseSlide) {
		currentColor = hex;
		ColorPicker.positionIndicators(
			document.getElementById("slide-indicator"),
			document.getElementById("picker-indicator"),
			mouseSlide, mousePicker
		);

		idFocused = "";
		var e, i = 0;
		while (e == document.getElementsByTagName ("input")[i++]) {
			if (e.type == "text") e.onfocus = function () { idFocused = this; }
		}

		// set current color values in RGB/HSV/Hex..
		document.getElementById("hex").innerHTML = hex;
		document.getElementById("rgb").innerHTML = "rgb(" + rgb.r.toFixed() + "," + rgb.g.toFixed() + "," + rgb.b.toFixed() + ")";
		document.getElementById("hsv").innerHTML = "hsv(" + hsv.h.toFixed() + "," + hsv.s.toFixed(2) + "," + hsv.v.toFixed(2) + ")";

		// this will do nicely..
		document.getElementById("curr-col").style.color = hex;

		// set curent color pref input to picked color..
		if ( typeof current_input != "undefined" && current_input.className == "color-inp" ) {
			current_input.style.backgroundColor = hex;
			current_input.value = hex;
		}

		// set the demo colors.. (but only for color inputs!) //  && document.getElementById(current_demo) != null
		if (typeof current_demo != "undefined" && current_input.className == "color-inp" ) {
			document.getElementById(current_demo).style.color = hex;
			if (current_demo == "',$scheme_edit['bg_color_name'],'") {
				SetDemoBG(hex);
				document.getElementById("curr-col").style.backgroundColor =  returnOpposite(hex);

			}
		}
	});

// Focus on first control, give the user a hint to how things work.
document.getElementById("prefs_array[',$first_key,']").focus();

// on load, set the first preference color..
cp.setHex("',$first_value,'");

// finally, set the demo background to the scheme background color
SetDemoBG("',$init_bg,'");

setCurrentInput(document.getElementById("prefs_array[',$first_key,']"))

//-->
//]]>
</script>
<noscript>LOL! Don\'t be silly!</noscript>';
	//** Reset Button..
	//
	echo '
<form id="reset" method="post" action="'.$_SERVER['SCRIPT_NAME'].'">
<div class="reset-form"><input id="reset-butt" name="reset" type="submit" value="reset" title="Reset the scehem editor to the current default scheme and wipe any temporary scheme-related session data."/></div></form>';


	// logout..
	echo '
<form id="logout" method="post" action="'.$_SERVER['SCRIPT_NAME'].'">
<div class="logout-form">',$auth->getLogoutButton(true),'</div></form>
<div class="admin-user" title="Just like the user selector, these buttons will whisk you directly back to your previous page.">
	<h4>quick selector:</h4>';
// we put the user controls unisde a special "admin-user" div, so we can style them differently when logged in.



	//** Simple User Scheme Selector..
	//

}

// what regular user sees..
echo '
	<ul id="user-scheme-controls">';

// add a reset button to the choices..
array_push($blog_scheme_config, array('name'=>'reset'));


$refer_uri = '';
if (isset($_SERVER['HTTP_REFERER'])) { $refer_uri = $_SERVER['HTTP_REFERER']; }


foreach ($blog_scheme_config as $ini_section) {
	if (substr($ini_section['name'], -7) != '-backup') {
		echo '
<li><form method="post" action="'.$_SERVER['SCRIPT_NAME'].'" class="user-submit-form">
	<input type="submit" class="user-scheme-submit" value="',$ini_section['name'],'" title="Select ',$ini_section['name'],'"/>
	<input type="hidden" name="ajax" value="true"/>
	<input type="hidden" name="scheme" value="',$ini_section['name'],'"/>
	<input type="hidden" name="goblog" value="',$refer_uri,'"/>
</form></li>';
	}
}

//2do.. if IE user - post message - REFRESH!!!!

echo '
</ul>
<div class="clear"></div>';


// close "admin-user"
if ($color_authorized === true) {
echo '
</div>
</div>
<script type="text/javascript">
//<![CDATA[
<!--
// bypass "cool" focusing on first load..
window.scrollTo(0, 0);
document.getElementById(\'scheme_copy_name\').focus();
//-->
//]]>
</script>
<noscript><!-- JavaScript Input Focus --></noscript>';

}

echo '
<div id="page-bottom"></div>
<script type="text/javascript">
//<![CDATA[
<!--
// how mad is needing this?...
parent.document.body.style.zoom = "100%";
//-->
//]]>
</script>
</body>
</html>';



/*

	fin

		  */








// Basic. Does what it says on the tin..
// I nicked this from the php manual, pretty much..
//
function write_ini_array_to_file($ini_array, $data_file) {
	$ini_data = ";  ۞ utf-8; unix line-breaks
;
; corzblog color schemes ini file.
;
; These values are inserted into the generated CSS (and elsewhere) at run-time.
;
; If it isn't immediately apparent.. the mechanism is in place for you to create
; variables here, and have them immediately available for use in your scheme's
; dynamic CSS file as %%tokens%%. Nifty, huh!
;
; If you want to edit your schemes in a funky web GUI with color picker and many
; other time-saving goodies, load /blog/inc/scheme-edit.php into your browser.
;
; ;o) Cor
;
; ps. when you update your schemes via the GUI, a single backup of this file is
; made inside /blog/inc/data/backup/. If you made an error, you have until you
; /next/ update your schemes to grab the old data!
;
";
	foreach ($ini_array as $key => $value) {
		$ini_data .= "[".$key."]\n";
		foreach ($value as $key2 => $value2) {
			if (is_array($value2)) {
				for($i=0; $i < count($value2); $i++) {
					$ini_data .= $key2."[]=\"".$value2[$i]."\"\n";
				}
			} elseif ($value2 == '') {
				$ini_data .= $key2."=\n";
			} else {
				$ini_data .= $key2."=\"".$value2."\"\n";
			}
		}
	}
	// finally, write the string data to the ini file..
	return write_data_to_file($data_file, $ini_data);
}


/*
	write out some data to a new file..

	usage:

		bool ( string {full file path}, string {data to write});

	this function returns true on success,
	false on failure.

	This is about as robust as it gets.

													*/
function write_data_to_file($data_file, $data) {

	$writable = false;

	if (!file_exists($data_file)) {
		$fp = fopen($data_file, 'wb');
		fwrite ($fp, '');
		fclose ($fp);
	}

	// do a simple backup..
	copy($data_file, $GLOBALS['corzblog']['path'].'/inc/data/backup/'.basename($data_file).'.bak');

	if (is_writable($data_file)) {
		$fp = fopen($data_file, 'wb');
		$lock = flock($fp, LOCK_EX);
		if ($lock) {
			fwrite ($fp, $data);
			fflush($fp);
			flock($fp, LOCK_UN);
			$writable = true;
		} else {
			$GLOBALS['errors']['write_data_to_file'] = "couldn't lock $data_file";
			$writable = false;
		}
		fclose ($fp);
		clearstatcache();
	} else {
		$GLOBALS['errors']['write_data_to_file'] = "can't write to $data_file";
		$writable = false;
	}
	return $writable;
}



// my_function..
function get_missing_prefs() {
  global $missing_array;

	// scan current schemes.. (also grab empty values)
	foreach ($GLOBALS['blog_scheme_config'] as $scheme) {
		foreach ($scheme as $name=>$val) {
			$missing_array[$name] = "";
		}
	}
	scan_for_CSS_files();
	return $missing_array;
}


function scan_for_CSS_files() {
  global $missing_array, $level, $scan_path;

	for ($search=0,$search_path=''; $search <= $level; $search++) {
		if (stristr($scan_path[$search], $GLOBALS['scheme_edit']['back_end_theme'])) {
			$search_path .= $scan_path[$search];
		}
	}
	$dirhandle = opendir($search_path);
	while ($file = readdir($dirhandle)) {

		if ($file{0} != '.') {
			if (is_file($search_path.$file)) {
				$fext = substr($file,strrpos($file,'.'));
				if($fext == '.css') {
					$css_vals = extract_tokens_from_CSS($GLOBALS['corzblog']['path'].'/inc/'.$search_path.$file);
					$missing_array = array_merge($missing_array, $css_vals);
				}
			} elseif (is_dir($search_path.$file)) {
				$scan_path[++$level] = ($file.'/');
				scan_for_CSS_files();
				$level--;
			}
		}
	}
}

function extract_tokens_from_CSS($css_file) {
	$css_sheet = file_get_contents($css_file);
	preg_match_all("/%%(((?!%%).)*)%%/i", $css_sheet, $matches);
	$css_vals = array_flip($matches[1]);
	foreach ($css_vals as $my_pref=>$iszero) {
		$css_vals[$my_pref] = '';
	}
	return $css_vals;
}



// callback function for array_filter..
// this ensures values of "0" are not interpreted as FALSE.
function isit_empty($var) {
	return (!trim($var) == '');
}



//:debug: end
if (!empty($GLOBALS['do_debug'])) {
	if (!empty($_POST)) {
		debug('$GLOBALS: '."\t".print_r($GLOBALS, true)."\nCOMPLETED OUTPUT FOR scheme-editor.php\n\n\n");//:debug:
		debug_out();//:debug:
	}
}

?>