<?php // ۞// text { encoding:utf-8 ; bom:no ; linebreaks:unix ; tabs:4sp ; }
require 'init.php';
header('content-type: application/rss+xml');

// log the hit..
require_once $_SERVER['DOCUMENT_ROOT'].'/inc/init.php'; // and does other stuff.

/*
	outputs an RSS (0.91 spec) feed for corzblog
	see rdf.php for details of what this file does

		© Cor @ corz.org ;o) 2003->
*/

if (!function_exists('str_split')) {
	function str_split($str, $len=1, $brk=':') {
	return explode($brk, chunk_split($str, $len, $brk));
	}
}

echo '<?xml version="1.0" encoding="UTF-8"?>'."\n";
echo '<!DOCTYPE rss PUBLIC "-//Netscape Communications//DTD RSS 0.91//EN"';
echo ' "http://www.rssboard.org/rss-0.91.dtd">'."\n";
echo '<rss version="0.91">'."\n\n";
echo '<channel>'."\n";
echo '<title>',$corzblog['mysite_clean'],'</title>'."\n";
echo '<link>',$corzblog['blog_url'],'</link>'."\n";
echo '<description>',strip_tags($corzblog['description']),'.. powered by corzblog</description>'."\n";
echo '<language>en-gb</language>'."\n";
echo '<copyright>content (c) ',date('Y'),' - ',$corzblog['host'],
', corzblog syndication (c) 2003 - ',date('Y'),' http://corz.org/ </copyright>'."\n";
echo '<managingEditor>',mashed_mail($corzblog['mail_addy']),'</managingEditor>'."\n";
echo '<webMaster>',mashed_mail($corzblog['mail_addy']),'</webMaster>'."\n\n";
echo '<image>'."\n";
echo '<title>',$corzblog['mysite_clean'],'</title>'."\n";;
echo '<url>',$corzblog['blog_url'],'inc/img/corzblog.png</url>'."\n";
echo '<link>',$corzblog['blog_url'],'</link>'."\n";
echo '</image>'."\n\n";

// open and split the blog into an array of blog entries..
$fp = fopen($corzblog['blog_file'], 'rb');
$file_contents = @fread($fp, filesize($corzblog['blog_file'])); // @ you may be updating
fclose($fp);
$whole_blog = explode('<!--*end*-->', $file_contents);

// start the loop..
$total_articles = count ($whole_blog);
for ($i=0;$i < $total_articles;$i++) {
	$z = $i + 1;
	if ($z == $total_articles) {
		break; // we reached the end of the articles
	} else {
		// okay, we have an article
		$blog = $whole_blog[$i];
		// split the article into its parts..
		$parts = explode('<!--*g*-->', $blog);
		$blog_title = trim(strip_tags($parts[1])); // the title
		// we need a valid "encoded" version of the link..
		$enc_title = do_valid_id($blog_title);
		$the_blog = strip_tags($parts[2]);
		$snippet = str_split($the_blog, 256); // the description

		// now create the <item> element..
		echo '<item>'."\n";
		echo '<title>',$blog_title,'</title>'."\n";
		echo '<description>',$snippet[0],' ...</description>'."\n";
		echo '<link>',$corzblog['blog_url'],'index.php#',$enc_title,'</link>'."\n";
		echo '</item>'."\n\n";
	}
}

echo '</channel>'."\n";
echo '</rss>';
?>
