<?php // ۞//  text { encoding:utf-8 ; bom:no ; linebreaks:unix ; tabs:4sp; }
/*

	corzblog  ~  index.php

	This is the main script used to display blogs, sorting out what you are
	supposed to be seeing and presenting that to the reader.

	A part of corzblog.. http://corz.org/blog/

	;o) Cor

	(c) copyright 2003->today -> cor @ corz.org

*/

require 'init.php';
//require 'inc/cbparser.php';
doc_type();

$archive_view = $perma_view = $about_view = $all_blogs = $archive = $subtit = '';
$cb_title = $corzblog['mysite'];

if (!empty($_GET['blog'])) { $blog_to_show = $_GET['blog']; } else { $blog_to_show = ""; } // catch human explorers.

if (isset($_GET['archive'])) {

	$archive = do_slashes($_GET['archive']);

	/*
	The "about" blog..	*/
	if (($archive == $corzblog['about_name'].'-'.$corzblog['blog_is']) or ($archive == $corzblog['about_name'])) {
		$about_view = true;
//		$cb_title .= ' <small>('.$corzblog['about_name'].')</small>';
		$corzblog['description'] = $corzblog['about_description'];
		$corzblog['blog_file'] = $corzblog['about_name'].$corzblog['blog_ext'];
		$archive = $corzblog['about_name'].'-'.$corzblog['blog_is']; // so permalinks work.

	/*	this allows the corzoogle engine, robot links
		machine, etc., to easily link to the current blogz.blog..	*/
	} elseif ($archive == substr($corzblog['blog_file'], 0, (0 - strlen($corzblog['blog_ext'])))) {

		//$cb_title = $corzblog['mysite_clean'];
		//2do.
	/*
	it's a permalinked view of *this* {month}s {blog}!	*/
	} elseif ($archive == $arc_period) {
		$perma_view = true;
		$subtit = ' [permalinked view] ';
		$corzblog['description'] = str_replace('-', ' ', $blog_to_show)." ".$subtit;

	/*
	a little something from the archives, perhaps..	*/
	} else {
		if (file_exists($corzblog['archive_dir'].$archive.$corzblog['blog_ext'])) {
			$archive_view = true;
			$subtit = str_replace('_', ' ', $archive);
			$corzblog['description'] .= ' &nbsp;'.$corzblog['arc_description'];
			$corzblog['blog_file'] = $corzblog['archive_dir'].$archive.$corzblog['blog_ext'];
			$corzblog['mysite'] .= ' - '.$archive;
			if (!empty($blog_to_show)) {
				$perma_view = true;
				$subtit = ' [permalinked view] ';
				$corzblog['description'] = str_replace('-', ' ', $blog_to_show)." ".$subtit;
			}

		} else { // oops!
			$subtit = '('.$archive.' does not exist, sorree)';
		}
	}
} else { // no $_POST['archive'] was set
	$archive = $arc_period;// ??//:2do
}

echo '
<title>',strip_tags($corzblog['description']),':  ',$corzblog['mysite_clean'],'</title>';

// CSS..
output_style_links();

// close <head>..
echo '
</head>
<body>';




// custom header..
if ($corzblog['custom_header']) { include $corzblog['custom_header']; }

echo '
<div id="blog-container">';

echo blog_header($cb_title, $corzblog['description']);

// grab the blog entries right now.. (used in sidebar)
$corzblog['blog_entries'] = get_blog_entries($corzblog['blog_file']);

// some webmasters/designers may prefer this up here..
if ($corzblog['sidebar_first']) { echo sidebar(); }

echo '
<div id="blogzcol">';

// grab the bog entries..
if (!empty($corzblog['blog_entries'])) {


	$edit_idx = 0;

	// run through the blog antries array..
	foreach($corzblog['blog_entries'] as $this_blog) {

		// grab its parts into an array..
		$blog_parts = get_blog_parts($this_blog);

//		[0]	blog body
//		[1]	title
//		[2]	id title
//		[3]	raw title (includes HTML tags)
//		[4] plain text part of "posted by" line

		$blog_links = '';

		/*
			blog permalinks..
									 */

		if ($corzblog['permalinks']) {
			// we rewrite the links for neat mod_rewrite flat links..
			if ($corzblog['rewrite_links']) {
				// not for SEO, it makes no difference, just looks neat.
				$href = $corzblog['blog_url'].$archive.'/'.$blog_parts[2];
			} else {
				$href = $corzblog['blog_url'].'?archive='.$archive.'&amp;blog='.$blog_parts[2];
			}
			// Firefox doesn't deal too well with new lines in titles. Too bad!
			$blog_links = '
<form id="edit-'.$edit_idx.'" action="'.$corzblog['blogzpath'].'edit.php" method="post">
<div class="blog-links">
<a class="blog-permalink imglink" href="'.$href.'" title="permalink for \''.$blog_parts[1].'\' (you can always get to this '.
$corzblog['blog_is'].' from this link)" id="permalink-'.$blog_parts[2].'" ></a>';
		}

//	<img src="'.$blog_scheme['permalink_img'].'" alt="permalink for \''.$blog_parts[1].
//	'\' (you can always get to this '.$corzblog['blog_is'].' from this link)" onmouseover="this.src=\''.
//	$blog_scheme['permalink_hover_img'].'\'" onmouseout="this.src=\''.$blog_scheme['permalink_img'].'\'"/>

		// admin stuff..
		//

		// 2do.. permalinks? and for "future" perma-links? hmmm.. a lot of work
		if ($corzblog['is_authorized'] and !$perma_view) { // for now we simply ignore permalinked pages

//			$blog_links .= '
//<input class="right" name="edit" type="image" src="'.$blog_scheme['edit_img'].'" value="'.
//$edit_idx.'" onmouseover="this.src=\''.$blog_scheme['edit_hover_img'].'\'" onmouseout="this.src=\''.
//$blog_scheme['edit_img'].'\'" title="Edit \''.$blog_parts[1].'\'" alt="edit-button" />';

			$blog_links .= '
<input class="blog-edit-butt" name="edit" type="submit"  value="'.
$edit_idx.'" title="Edit \''.$blog_parts[1].'\'" alt="edit-button" />';
			switch (true) {
				case $archive_view:
				$blog_links .= '
<input type="hidden" name="arc-name" value="'.$archive.'-'.$edit_idx.'" />
<input type="hidden" name="arc-edit" value="true" />';
					break;

				case $about_view:
					$blog_links .= '
<input type="hidden" name="about" value="true" />';

				default :
						$blog_links .= '
<input type="hidden" name="blog-number" value="'.$edit_idx.'" />';
			}
		}
		$blog_links .= '
</div>
</form>';

		$this_blog = '
<article>
<div class="blog-entry">
<div id="'.$blog_parts[2].'">'.
$blog_parts[3].
$blog_parts[0].'
</div>
<div class="byline">
'.$blog_parts[4].'
</div>
<hr class="cb-hr" />'.$blog_links.'
</div>
</article>';

		// single blog mode (permalink)
		if (!empty($blog_to_show)) {
			if (trim($blog_parts[2]) == trim($blog_to_show)) {

				// convert any relative links to absolute links..
				$this_blog = str_replace('src="'.$corzblog['images_folder'],	 'src="'.$corzblog['blog_url'].$corzblog['images_folder'], $this_blog);
				$this_blog = str_replace('href="'.$corzblog['images_folder'],	'href="'.$corzblog['blog_url'].$corzblog['images_folder'], $this_blog);
				$this_blog = str_replace('href="'.$corzblog['files_folder'],	'href="'.$corzblog['blog_url'].$corzblog['files_folder'], $this_blog);
				$this_blog = str_replace('href="'.$corzblog['audio_folder'],	'href="'.$corzblog['blog_url'].$corzblog['audio_folder'], $this_blog);

				$all_blogs = $this_blog;
				break;
			}
		} else { // or else add this entry to the page..
			$all_blogs .= $this_blog;
		}

		$edit_idx += 1;
	}
}

$all_blogs = trim($all_blogs);

if (!empty($blog_to_show) and empty($all_blogs)) {
	echo do_cbtimer();
	$jump_link = make_jump_link ('now jumping to an existing blog..', 1.25, $corzblog['blogzpath'], false, false);
	echo do_message('You specified a non-existant blog!', $jump_link, true);

} elseif (empty($all_blogs)) {

//	if () {
//		// jump back in time!
//
//	} else {

		$all_blogs = '
<article>
<div class="blog-entry">
	<div class="clear-small"></div>
	<div class="clear"></div>
	<h3 class="empty-message">
		So far, '.$corzblog['blogger'].' has been too busy to write a '.$corzblog['blog_is'].' this '.$corzblog['arc_frequency'].
			', why not check out the archives!'.$corzblog['no_blog_message'].'
	</h3>
	<div class="clear"></div>
	<div class="clear-small"></div>
</div>
</article>';
//	}
}


// any important user messages?
if (!empty($corzblog['admin_warning'])) {
	foreach($corzblog['admin_warning'] as $admin_warning) {
		echo do_message($admin_warning[0], $admin_warning[1].'<br /><br />', $admin_warning[2], true);
	}
}

// spit out the blogs..
echo "\n\n".$all_blogs;

echo '
</div>';

if (!$corzblog['sidebar_first']) { echo sidebar(); }

do_foot();


if ($corzblog['is_authorized']) {
echo '
<form id="logout" method="post" action="'.$_SERVER['SCRIPT_NAME'].'">
<div class="auth-logout">';
	echo $auth->getLogoutButton(true);
	echo '</div>
</form>';
}


echo '
</body>
</html>';

if (!empty($GLOBALS['do_debug'])) {//:debug:
	debug('$GLOBALS: '."\t".print_r($GLOBALS, true)."\nCOMPLETED OUTPUT FOR index.php\n");//:debug:
	debug_out();//:debug:
}//:debug:

?>