<?php // ۞// text { encoding:utf-8 ; bom:no ; linebreaks:unix ; tabs:4sp ; }
//echo '<pre>_POST:',print_r($_POST,true),'</pre>';//:debug
//exit;
/*

	corzblog admin	v3.3

	this script is used to configure your installation.

	a part of corzblog.. http://corz.org/blog/

	;o) Cor

	(c) copyright 2003->today -> cor @ corz.org

*/

// init..
require 'init.php';


if (isset($_GET['ajax'])) {
	switch (true) {
		case isset($_GET['SetMyTab']):
			$_SESSION['corzblog']['open_tab'] = $_GET['SetMyTab'];
			exit;
		case isset($_GET['ResizeMe']):
			$_SESSION['corzblog']['info_sizes'] = $_GET['ResizeMe'];
			exit;
	}
}


// the default info string (when it's not showing something else)
$tips_string = '<ul><li><strong>*</strong>&nbsp;The save button appears below every tab, so if you are editing your sidebar prefs, rather than scroll down to save, simply switch to a shorter tab!</li><li title=\'Unless you lock the tabs by clicking - but that is cheating!\'><strong>*</strong>&nbsp;You can get to <em>all</em> the preferences, <em>in order</em>, using only the &lt;TAB&gt; key.</li><li><strong>*</strong>&nbsp;You can resize and move this panel to somewhere more convenient - simply click in an empty space and drag around - its position will be remembered for the entire session.<br /><br />You can also set the position permanently and more, in your preferences - see the advanced tab for details.</li><li><strong>*</strong>&nbsp;The dropdown preferences are created dynamically, for example, if you add a folder to your blog directory, it will appear in the folder dropdowns the instant you load your prefs.</li><li><strong>*</strong>&nbsp;You can click the main title (&quot;preferences..&quot;) to revert your settings to their most recently saved version.</li><li><strong>*</strong>&nbsp;Click any tab to lock the tab, click again to unlock.</li></ul>';



// switch to which pref tab initially.. (default 1)
$open_tab = 1;
if (isset($_POST['open_tab']) and is_numeric($_POST['open_tab'])) {
	$_SESSION['corzblog']['open_tab'] = $_POST['open_tab'];
}
if (isset($_SESSION['corzblog']['open_tab'])) {
	$open_tab = $_SESSION['corzblog']['open_tab'];
}


$info_sizes = false;
if (isset($_SESSION['corzblog']['info_sizes'])) {
	$info_sizes = explode(',', $_SESSION['corzblog']['info_sizes']);
}

$do_info = true;
if (!$corzblog['is_authorized']) {
	$do_info = false;
} elseif (isset($corzblog['info_sizes']) and !empty($corzblog['info_sizes'])) {
	if ($corzblog['info_sizes'] == 'none') {
		$do_info = false;
	} elseif ($corzblog['info_sizes'] == 'reset') {
		unset($_SESSION['corzblog']['info_sizes']);
		$info_sizes = 'reset';
	} else {
		$info_sizes = explode(',', $corzblog['info_sizes']);
	}
}

// check for user adding new links to a link-group..
// we'll use these arrays right away, to create the prefs.

if (isset($_POST['add-link-0'])) { $corzblog['main_links'][] = add_link(); }
if (isset($_POST['add-link-100'])) { $corzblog['side_links'][] = add_link(); }



// Non-JavaScript up/down/delete..
$non_js_save = false;
for ($i=1; $i <= 150; $i++) {
	if (array_key_exists('move-link-up-'.$i.'_x', $_POST)) {
		move_link_up($i);
		$non_js_save = true;
	}
}
for ($i=1; $i <= 150; $i++) {
	if (array_key_exists('move-link-down-'.$i.'_x', $_POST)) {
		move_link_down($i);
		$non_js_save = true;
	}
}
for ($i=1; $i <= 150; $i++) {
	if (array_key_exists('delete-link-'.$i.'_x', $_POST)) {
		delete_link($i);
		$non_js_save = true;
	}
}


/*
	let's go!
				*/


// prepare some data for the prefs tabs (dropdown lists)..

// current themes list..
$corzblog['themes_list'] = get_themes();

// current schemes list..
$corzblog['schemes_list'] = get_schemes();

// spelling word lists..
$corzblog['word_lists_list'] = get_word_lists($corzblog['path'].'/inc/spelling');
$corzblog['user_word_lists_list'] = get_word_lists($corzblog['path'].'/inc/spelling/'.$corzblog['user_dic_folder']);


// the top-level directories (not including ./inc/)
$corzblog['top_dirs'] = get_dirs($corzblog['path']);


// grab the pref tabs arrays..
require 'inc/admin-tabs.php';	// load: $corzblog['corzblog_prefs']


// page header..
doc_type();

$jump_add = '';
$description_txt = 'edit your preferences..';

// for <TAB> keying..
$tab_idx_count = count($corzblog['corzblog_prefs']);

do_header(); // out of the way.

if (!$corzblog['is_authorized']) {
	echo $auth->getAuthCode(); // include the javascript hashing functions.
}

// custom header..
if ($corzblog['custom_header']) { include $corzblog['custom_header']; }


// save the prefs to the ini files(s)..
if ((isset($_POST['save']) or $non_js_save) and $corzblog['is_authorized']) {
	save_prefs();
}

echo '
<div id="blog-container">';

echo blog_header($corzblog['mysite'], $description_txt);

// sidebar..
if ($corzblog['sidebar_first']) { echo sidebar(); }

echo '
	<div id="controlz">';

// any important user messages?
if (!empty($corzblog['admin_warning'])) {
	foreach($corzblog['admin_warning'] as $admin_warning) {
		echo '<div class="clear-small"></div>',do_message($admin_warning[0], $admin_warning[1].'<div class="clear-tiny"></div>', $admin_warning[2], true);
		$jump_link = '<br />[<a href="'.$corzblog['self'].
			'" title="Please read the warning messages carefully before clicking this!" id="warning-return-link">return to prefs and try again</a>]';
	}
}

// Jump!
if (!empty($do_jump)) {
	echo do_message('<br />'.$do_jump, $jump_link);
} else {
	// make the prefs tabs..
	//
	create_prefs($corzblog['corzblog_prefs']);
	if ($corzblog['is_authorized']) {
		create_dragdrop();
		echo '
<script>
//<![CDATA[
<!--
switchIt(',$open_tab,');';
if ($do_info) { echo '
CheckAutoSave();'; }
echo '
function ReloadPage() {
	window.location="',$_SERVER['SCRIPT_NAME'],'";
}
//-->
//]]>
</script>
<noscript><!-- JavaScript Only --></noscript>';
	}
}

echo '
	</div>'; // id="controlz"

// sidebar..
if (!$corzblog['sidebar_first']) { echo sidebar(); }


do_foot();


echo '
</body>
</html>';




/*
	the functions..	 */


// make the preference tabs..
function create_prefs($preference_tabs) {
global $auth, $corzblog, $open_tab, $tips_string, $info_sizes, $do_info;

	$tt_str = 'corzblog configuration.. <br /><br />Click here to REVERT your settings to their most recently saved version.';
	$pt_string = 'preferences';
	if (!$corzblog['is_authorized']) {
		$pt_string = 'login';
		$tt_str = 'login to make changes to corzblog..';
	}
	echo '
	<form method="post" action="'.$_SERVER['SCRIPT_NAME'].'">
	<div class="prefs">
		<h1 title="',strip_tags($tt_str),'"><span ';
		if ($corzblog['is_authorized']) {
			echo 'onclick="ReloadPage()" onmouseover="insertInfo(\'Preference:\', \'',$tt_str,'\')" onmouseout="clearInfo()" ';
		} else {
			echo ' onclick="document.getElementById(\'auth_login\').focus();" ';
		}
		echo ' id="main-title">',$pt_string,'..</span></h1>';

	// the funky titles first..
	create_tab_titles($preference_tabs);

	echo '
		<div class="prefs-tab">';

	// and their individual tabs..
	$counter = 1;
	$tab_shift = 100;

	foreach($preference_tabs as $section => $tab) {

		// are they authorised to view this preference tab?
		if (($tab[$section][1] == 'public') or ($corzblog['is_authorized'])) {
			echo '
			<div class="section-tab" id="tab-',$counter++,'" title="',make_safe_pop_title($tab[$section][0]),'" >';
			array_shift($tab);
			output_prefs_tab($tab, $tab_shift);
			// close this prefs tab..
			echo '
			</div>';

		} elseif ($section == 'user') {	// otherwise do a login form..

			echo '
<style media="screen">
/*<![CDATA[*/
<!--
.pref-title { display: none; }
//-->
/*]]>*/
</style>
			<input type="hidden" id="open_tab" value="1" />
			<div id="tab-',$counter++,'" title="',make_safe_pop_title($tab[$section][0]),'">';
			echo '
				<div id="user">';
				$open_tab = 1; // we could leave it possibly hidden, awaiting hover, but this is clearer..
				if ($GLOBALS['corzblog']['use_pajamas']) { echo $auth->getAuthCode(); }
				echo $auth->getLoginForm(true);
			echo '
				</div>
			</div>';
		}
		$tab_shift += 100;
	}

	echo '
		</div>';

	// save & logout buttons..
	if ($corzblog['is_authorized']) {

		$sstr = 'Click here to save the current configuration.<br /><br />';
		$sstr .= 'It is advisable to do this immediately after adding new links!<br /><br />';
		$sstr .= 'Note: to revert to your most recently saved preferences, simply click the main title (&quot;preferences..&quot;) or click the &quot;config&quot; link from the menu.';

		echo '
			<input type="hidden" name="open_tab" id="open_tab" value="1" />
			<div class="clear-small"></div>
			<div class="pref-save">
				<input class="savebutt" tabindex="10000" title="clicking here to save your preferences"
				onmouseover="insertInfo(\'Save:\', \'',$sstr,'\')"
				onmouseout="clearInfo()" type="submit" name="save" id="save" value="save" />
			</div>
			<div onmouseover="insertInfo(\'Logout:\', \'Click here to logout of (terminate) your admin session. \')" onmouseout="clearInfo()">
				'.$auth->getLogoutButton(true).'
			</div>';
	}


	// information panel..
	//
	echo '
	</div>
	</form>';

	if ($corzblog['is_authorized']) {
		if ($do_info) {
			echo '
	<div class="cell4" id="info-panel" ';

			if (is_array($info_sizes)) {
				echo ' title="Info Panel Initial Dimensions (x,y,w,h): [',$info_sizes[0],',',$info_sizes[1],',',$info_sizes[2],',',$info_sizes[3],']"';
			}
			echo '>
		<div id="info-title">tips:</div>
		<div id="info-text">',$tips_string,'</div>
		<div id="sizer">
			<div id="size-taller" class="size-control"><img src="',$GLOBALS['blog_scheme']['infobutt_taller_img'],'" class="sizebutt" id="butt-size-taller" alt="button control for resizing" title="make the info panel taller" width="16" height="16" onclick="ResizeSizeMe(this)" onmouseover="insertInfo(\'Make Taller:\', \'Make this information panel taller\')" onmouseout="clearInfo()" /></div>
			<div id="size-shorter" class="size-control"><img src="',$GLOBALS['blog_scheme']['infobutt_shorter_img'],'" class="sizebutt" id="butt-size-shorter" alt="button control for resizing" title="make the info panel shorter"  width="16" height="16" onclick="ResizeSizeMe(this)" onmouseover="insertInfo(\'Make Shorter:\', \'Make this information panel shorter\')" onmouseout="clearInfo()"/></div>
			<div id="size-narrower" class="size-control"><img src="',$GLOBALS['blog_scheme']['infobutt_narrower_img'],'" class="sizebutt" id="butt-size-narrower" alt="button control for resizing" title="make the info panel narrower" width="16" height="16" onclick="ResizeSizeMe(this)" onmouseover="insertInfo(\'Make Narrower:\', \'Make this information panel narrower\')" onmouseout="clearInfo()"/></div>
			<div id="size-wider" class="size-control"><img src="',$GLOBALS['blog_scheme']['infobutt_wider_img'],'" class="sizebutt" id="butt-size-wider" alt="button control for resizing"  title="make the info panel wider" width="16" height="16" onclick="ResizeSizeMe(this)" onmouseover="insertInfo(\'Make Wider:\', \'Make this information panel wider\')" onmouseout="clearInfo()"/></div>
		</div>
		<noscript> (JavaScript Required)</noscript>
	</div>';
		} else { // this prevents us having to put JS conditions *everywhere*..
			echo '
	<div id="info-panel" style="display:none;"><div id="info-title"><div id="info-text"></div></div></div>';
		}
	}

}




// the titles..
function create_tab_titles($preference_tabs) {
global $corzblog;

	static $counter = 1;
	echo '

		<div class="prefs-title" title="Preference Tabs. Click any title to lock the tab, click again to unlock.">';

	$master_tab_shift = 100;
	foreach($preference_tabs as $section => $tab) {

		if (($tab[$section][1] == 'public') or ($section == 'user') or ($corzblog['is_authorized'])) {
			echo '
			<a class="pref-title" id="sw-',$counter,'" title="',make_safe_pop_title($tab[$section][0]),'" tabindex="',$master_tab_shift,
			'" onclick="lockIt(',$counter,')" onfocus="switchIt(',$counter,');insertInfo(\'',$section,':\', \'',$tab[$section][0],
				'\')" onblur="clearInfo()" onmouseover="switchIt(',$counter++,');insertInfo(\'',$section,':\', \'',$tab[$section][0],
				'\')" onmouseout="clearInfo()">',$section,'</a>';
		}
		$master_tab_shift += 100;
	}
	echo '
		</div>
		<div class="clear"></div>';
}


function make_safe_pop_title($title_string) {

	// we don't want to split entities..
	$tring = html_entity_decode($title_string, NULL, 'UTF-8');
	if (strlen(strip_tags($tring)) > 64) {
		$title_string =  htmlspecialchars(substr(strip_tags($tring), 0, strpos($tring, '.', 12))).' &hellip;';
	} else {
		$title_string = strip_tags($title_string);
	}
	return $title_string;
}



function output_prefs_tab($tab_of_prefs, $tab_shift) {
	global $do_info;

	$counter = 1;
	foreach($tab_of_prefs as $pref_name => $pref_fields) {
//if (!empty($GLOBALS['do_debug'])) { debug("\n".'$pref_fields:: '."\t".print_r($pref_fields, true)."\n\n"); }//:debug:

		// prepare the entries..
		if (($GLOBALS['corzblog'][$pref_name]) and ($pref_fields[0] == 'checkbox'))	// is it already set?
			{ $ck = 'checked="checked"'; } else { $ck = ''; }

		$title = make_safe_pop_title ($pref_fields[3]);

		switch (true) {


			// this one is a link array..
			case substr($pref_fields[0], 0, 5) == 'group':
				echo '
			<h5>',$pref_fields[1],'</h5>
			<div class="clear"></div>';
				switch (true) { // this could be fully automatic, but I like to keep the "names"
					case strstr($pref_fields[0], 'top'):
						create_link_group($pref_fields, 0, $tab_shift);
						break;
					case strstr($pref_fields[0], 'side'):
						create_link_group($pref_fields, $GLOBALS['corzblog']['link_splitter'], $tab_shift);
						break;
				}
				break;



			// spit out a single prefs row of /some/ kind..
			default :
				switch (true) {

					// check-box
					case $pref_fields[0] == 'checkbox':
						$label_type =  'check-label';
						$label_type2 =  'check-box';
						break;

					// drop-down!
					case $pref_fields[0] == 'dropdown':
						$label_type =  'dropdown-label';
						$label_type2 =  'drop-down';
						break;

					// standard 'text' input..
					default:
						$label_type =  'pref-label';
						$label_type2 =  'pref-input';
				}


				echo '
			<div class="prefs-tablerow"  id="row-',$pref_name,'" title="',$title,'" onmouseover="insertInfo(\'',
										$pref_fields[1],'\', \'',$pref_fields[3],'\')" onmouseout="clearInfo()">
				<div class="',$label_type,'"><label for="',$pref_name,'"';

				// pref-specific attributes and properties..
				//
				if ($pref_name == 'password') {
					echo ' onclick="ShowHidePass();" ';
				}

				// close the tag..
				echo '>',$pref_fields[1],'</label></div>';




				// List Box..
				//

				if ( $pref_fields[0] == 'dropdown' ) {
					echo '<div class="',$label_type2,'">
					<select name="',$pref_name,'" id="',$pref_name,'" tabindex="',($tab_shift+$counter++),'" >';

					foreach ($pref_fields[2][1] as $this_value) {
						$sel_insert = '';
						if ( $this_value == $pref_fields[2][0]) {
							$sel_insert = 'selected="selected"';
						}
						echo '
						<option value="',$this_value,'" ',$sel_insert,'>',$this_value,'</option>';
					}
					echo '
					</select>
				</div>';

				} else {

					// 'text' input..
					//
					$disp_field = $pref_fields[2];


					//** Special cases..

					// users can now use relative paths for their included files, remove system paths from old prefs..
					if ($pref_name == 'custom_header' or $pref_name == 'custom_footer' or $pref_name == 'custom_metadata' or $pref_name == 'html5_shiv') {
						$disp_field = str_replace($_SERVER['DOCUMENT_ROOT'], '', $disp_field);
						$disp_field = str_replace(realpath($_SERVER['DOCUMENT_ROOT']), '', $disp_field);
					}


					//2do.. insert current theme UNLESS they changed it (store & check)
//					if ($pref_name == 'current_scheme_name') {
//					}


					echo '
					<div class="',$label_type2,'"><input tabindex="',($tab_shift+$counter++),'" type="',
						$pref_fields[0],'" id="',$pref_name,'" name="',$pref_name,'" ',$ck,'';

					// don't insert password into field (user can do this mindfully)
					if (!empty($disp_field) and $pref_name != 'password') {
						echo ' value="',$disp_field,'"';
					}


					// pref-specific attributes and properties..
					if ($pref_name == 'autosave_info' and $do_info) {
						echo ' onclick="CheckAutoSave();" ';
					}


					// special conditions..
					if ($pref_name == 'password') {
						echo 'autocomplete="off" ';
					}
					echo ' />
					</div>';
				}


			echo '
			</div>';
		}

		echo '
			<div class="clear"></div>'; // no-space!

		// spaces between 'sections', but not for the last entry.
		if (isset($pref_fields[4]) and (end($tab_of_prefs) != $pref_fields)) {
			echo '
			<div class="clear-minute"></div>';
		}
	}
}




function create_link_group($pref_array, $idx_add, $tab_shift) {	// 'group-something'

	$user_links = tokenize_links($pref_array[2], 'encode');
	$idx = 1;
	$idx += $idx_add;
	$insert_info = 'onmouseover="insertInfo(\''.$pref_array[1].'\', \''.$pref_array[3].'\')" onmouseout="clearInfo()"';
	echo '
			<div id="linksrows-',$idx,'" ',$insert_info,'>';

	foreach($user_links as $array => $elements) {


		// new link row starts here..
		echo '
				<div class="prefs-linkrow" title="',$pref_array[1],' no. ',$idx,'" id="linkrow-',$idx,'">
					<span class="link-label">text.. </span>
					<span class="link-input"><input class="link-text" tabindex="',($tab_shift+$GLOBALS['tab_idx_count']++),
						'" type="text" id="text-',$idx,'" name="',$idx,'[text]"';
		if (!empty($elements['text'])) { echo ' value="', htmlspecialchars($elements['text']),'"'; }
		echo ' title="Enter the text for this link [NOTE: you can use {tokens}]" />';


		// Move UP..	[2do.. we could write these with JavaScript (DOM) to ensure non-JS browsers don't see them - or do fall-backs
		echo '
					<input class="control-butt" type="image" id="link-up-butt-',$idx,'" name="move-link-up-',$idx,
						'" src="',$GLOBALS['blog_scheme']['link_up_butt_img'],
						'" title="move this link up" onclick="MoveLinkUpButt(',$idx,');return false;" ';
		if ($idx == ($idx_add+1)) { echo 'style="display:none"'; }
		echo '/></span>
					<br />
					<div class="clear"></div>

					<span class="link-label">url.. </span>
					<span class="link-input"><input class="link-url" tabindex="',($tab_shift+$GLOBALS['tab_idx_count']++),
						'" type="text"  id="url-',$idx,'" name="',$idx,'[url]"';
		if (!empty($elements['url'])) { echo ' value="',htmlspecialchars($elements['url']),'"'; }
		echo ' title="Enter the URL for this link [NOTE: you can use {tokens}]" />';


		// Move DOWN..
		echo '
					<input class="control-butt" type="image" id="link-down-butt-',$idx,'" name="move-link-down-',$idx,
						'"  src="',$GLOBALS['blog_scheme']['link_down_butt_img'],
						'" title="move this link down" onclick="MoveLinkDownButt(',$idx,');return false;" ';
		if ($idx == (count($user_links)+ $idx_add)) { echo 'style="display:none"'; }
		echo '/></span>
					<br />
					<div class="clear"></div>

					<span class="link-label">title.. </span>
					<span class="link-input"><input class="link-title" tabindex="',($tab_shift+$GLOBALS['tab_idx_count']++),
																					'" type="text" name="',$idx,'[title]"';
		if (!empty($elements['title'])) { echo ' value="',$elements['title'],'"'; }
		echo ' title="Enter the pop-up title text for this link [NOTE: you can use {tokens}]" />';

		// Delete..
		echo '
					<input class="control-butt" type="image" name="delete-link-',$idx,'" src="',$GLOBALS['blog_scheme']['delete_butt_img'],
							'" title="delete this link" onclick="DeleteLinkButt(',$idx,'); return false;" />
					</span><br />';

		$prop_string = '';
		if (isset($elements['props'])) {
			$prop_string = htmlspecialchars($elements['props']);
		}
		echo '
					<a href="#" class="js-link"><img src="',$GLOBALS['blog_scheme']['prop_butt_right_img'],
						'" class="prop-butt" title="edit advanced properties for this link" id="prop-butt-img-',$idx,
						'" alt="JavaScript button to open advanced properties" onclick="OpenPropInput(',$idx,'); return false;" /></a>
					<input class="link-props" type="text" value="',$prop_string,'" name="',$idx,'[props]" id="props-',$idx,
										'" style="display:none;" tabindex="',($tab_shift+$GLOBALS['tab_idx_count']),'" />
					<noscript>
						<input class="link-props" type="text" value="',$prop_string,'" name="',$idx,'[props]" tabindex="',
																			($tab_shift+$GLOBALS['tab_idx_count']),'" />
					</noscript>';

		echo '
					<div class="clear-tiny"></div>
				</div>';

		$idx++;
	}
	echo '
				<div class="clear-tiny"></div>
				<input class="add-link" type="submit" value="Add New Link" name="add-link-',$idx_add,'" title="Add a new link to the ',$pref_array[1],'
NOTE: please save the configuration before attempting to move new links up and down." onmouseover="insertInfo(\'New Link:\', \'Add a new link to the &quot;',$pref_array[1],'&quot; link group.<br /><br /><strong>NOTE: Please SAVE the configuration before attempting to move new links up and down!</strong>\')" onmouseout="clearInfo()" />
				<div class="clear-small"></div>
			</div>';
}



function add_link() {
	$GLOBALS['open_tab'] = 6;
	return array(
    'text' => 'new link',
    'url' => 'http://www.example.com',
    'title' => 'Example Pop-Up Title!');
}



/*
	Non-JavaScript versions of move up/down/delete button actions..
																*/

function move_link_up($link_number) {

	global $corzblog;
	if ($link_number == 1) { return; }

	switch (true) {
		case $link_number < ($corzblog['link_splitter'] * 1) :
			if (isset($_POST[$link_number-1])) {
				$tmp_array = $_POST[$link_number-1];
				$_POST[$link_number-1] = $_POST[$link_number];
				$_POST[$link_number] = $tmp_array;
				return;
			}
			break;
		case $link_number < ($corzblog['link_splitter'] * 2) :
			if (isset($_POST[$link_number-1])) {
				$tmp_array = $_POST[$link_number-1];
				$_POST[$link_number-1] = $_POST[$link_number];
				$_POST[$link_number] = $tmp_array;
				return;
			}
			break;
	}
}

function move_link_down($link_number) {

	global $corzblog;

	switch (true) {
		case $link_number < ($corzblog['link_splitter'] * 1) :
			if (isset($_POST[$link_number+1])) {
				$tmp_array = $_POST[$link_number+1];
				$_POST[$link_number+1] = $_POST[$link_number];
				$_POST[$link_number] = $tmp_array;
				return;
			}
		case $link_number < ($corzblog['link_splitter'] * 2) :
			if (isset($_POST[$link_number+1])) {
				$tmp_array = $_POST[$link_number+1];
				$_POST[$link_number+1] = $_POST[$link_number];
				$_POST[$link_number] = $tmp_array;
				return;
			}
		default :
	}
}

function delete_link($link_number) {

	global $corzblog;

	switch (true) {
		case $link_number < ($corzblog['link_splitter'] * 1) :
			if (isset($_POST[$link_number])) {
				unset($_POST[$link_number]);
			}
			break;
		case $link_number < ($corzblog['link_splitter'] * 2) :
			if (isset($_POST[$link_number])) {
				unset($_POST[$link_number]);
			}
			break;
	}
}





function save_prefs() {

	global $config_array, $corzblog, $jump_link, $do_jump;

	unset($_POST['save']); // the submit button itself.

	// grab new submitted prefs into a new array..
	$new_config = $_POST;

	// in-case!
	reset($new_config);

	// move links to a new array..
	while (list($key) = each($new_config) ) {

		if (is_numeric($key)) {

			// we split links into groups of 100 - probably only a handful in each are used..
			switch (true) {
				case $key < ($corzblog['link_splitter'] * 1) :
					$new_main_links[] = $new_config[$key];
					break;
				case $key < ($corzblog['link_splitter'] * 2) :
					$new_side_links[] = $new_config[$key];
					break;
				// you could add other link groups here..
			}
			unset($new_config[$key]);
		}
	}


	// run through known preference fields; if they were NOT posted, they must have been UN-set..
	foreach($corzblog['corzblog_prefs'] as $pref_tab) {

		// this basically, removes the first element from the array (the properties part)
		array_shift($pref_tab);
		foreach($pref_tab as $pref => $value) {

			// scan UNset values..
			if (empty($new_config[$pref])) {
				// the 'password' field.. don't store blank passwords
				if ($pref == 'password') {
					// revert to old password..
					if (file_exists($config_array['password'])) {
						$new_config[$pref] = $config_array['password'];
					} else {
						$new_config[$pref] = $corzblog['password'];
					}
				} else { // if you really NEED a blank password, set it inside your pajamas module
					$new_config[$pref] = false;
				}
			}	/*	your password is only changed if you do it mindfully.	*/
		}
	}



	// create the link entries..

	// main..
	if (isset($new_main_links) and is_array($new_main_links) ) {
		foreach($new_main_links as $url_array) {

//			$url_array['text'] = make_clean_key($url_array['text']);
			$saved_main_links[$url_array['text']] = array('url' => $url_array['url'], 'title' => $url_array['title']);
			if (!empty($url_array['props'])) {
				$saved_main_links[$url_array['text']]['props'] = $url_array['props'];
			}
		}
	} else { // for ini saving..
		$new_main_links = array();
	}
	// side
	if (isset($new_side_links) and is_array($new_side_links) ) {
		foreach($new_side_links as $url_array) {
//			$url_array['text'] = make_clean_key($url_array['text']);
			$saved_side_links[$url_array['text']] = array('url' => $url_array['url'], 'title' => $url_array['title']);
			if (!empty($url_array['props'])) {
				$saved_side_links[$url_array['text']]['props'] = $url_array['props'];
			}
		}
	} else {
		$new_side_links = array();
	}


	// no longer required..
	unset($new_config['main_links']);
	unset($new_config['side_links']);


	// blog file name has been switched..
	// so, by what name are these works known?
	if ($new_config['blog_file'] != $corzblog['blog_file']) {
		if (!switch_blognames($corzblog['blog_file'], $new_config['blog_file'])) {
			unset($new_config['blog_file']);
			$corzblog['admin_warning'][] = array('Your blog name preference has been reverted!', '', true);
		}
	}


	// write out the ini file(s)..
	//
	if ( !isset($saved_side_links) or !is_array($saved_side_links) ) { $saved_side_links = array(); }
	if (write_cb_ini($corzblog['ini_file'], $new_config)
	  and write_cb_ini($corzblog['main-links_ini_file'], $saved_main_links)
		and write_cb_ini($corzblog['side-links_ini_file'], $saved_side_links)) {
			$jump_link = make_jump_link('please hold..', 1.25, $corzblog['self'], true, 'continue with prefs'); // final parameter = Non-JavaScript string
			if (empty($corzblog['admin_warning'])) {
				$do_jump = 'Preferences successfully saved!';
			} else {
				$do_jump = 'Preferences saved, but with warnings.';
			}

	}

	// reset this so the admin don't get confused..
//	$_SESSION['current_scheme_name'] = $new_config['current_scheme'];	// string - name

//	unset($_SESSION['scheme_edit']);
	unset($_SESSION['current_scheme']);
	unset($_SESSION['current_scheme_name']);
//	unset($corzblog['current_scheme_name']);

	//bug - need to check for available schemes in newly set theme - assign default. (needs a "default"!)

}



function do_header() {
	global $corzblog, $tips_string, $do_info;
	echo '
<title>',$corzblog['mysite_clean'],' configuration..</title>';
output_style_links();
echo '
<link rel="stylesheet" href="',$corzblog['blogzpath'],'inc/themes/admin.css?colors='.$corzblog['current_scheme_name'].'" type="text/css" media="screen" />';
if (file_exists($corzblog['path'].'/inc/themes/'.$corzblog['current_theme'].'/admin.css')) { echo '
<link rel="stylesheet" href="',$corzblog['blogzpath'],'inc/themes/',$corzblog['current_theme'],'/admin.css?colors='.$corzblog['current_scheme_name'].'" type="text/css" media="screen" />';
}
echo '
<script>
//<![CDATA[
<!--';

if ($corzblog['is_authorized']) {
	echo '
// a validator-friendly way to refresh a page..
function jsPause(seconds, url) {
	setTimeout( function() {
		window.location = url;
	}, seconds * 2000 );
}
/*
	this stuff is only used here; so it is pointless to load
	it into the browser for *every* page, we keep it locally.
	also, we are using php to fill in some of the variables.
*/

var lock = 0;
var total = ',count($corzblog['corzblog_prefs']),';

// we store these so resize doesn\'t unset them..
var StoreX = "none";
var StoreY = "none";


// switch the preference tabs..
function switchIt(tabId) {
	document.getElementById("open_tab").value=tabId;
	for (var i = 1; i <= total; i++) {
		var MyTab=document.getElementById("tab-"+i);
		var MyTitle=document.getElementById("sw-"+i);
		if (MyTab) {
			if (lock == 0) {
				if (i == tabId) {
					MyTab.style.display = "block";
					MyTitle.style.backgroundColor = "',$GLOBALS['blog_scheme']['butt_bg_selected'],'";
					MyTitle.style.color = "',$GLOBALS['blog_scheme']['butt_txt_selected'],'";

				} else {
					MyTab.style.display = "none";
					MyTitle.style.backgroundColor = "',$GLOBALS['blog_scheme']['butt_bg'],'";
					MyTitle.style.color = "',$GLOBALS['blog_scheme']['butt_txt'],'";
				}
			}
		}
	}
	return false;
}

function lockIt(tabId) {
	for (var i = 1; i <= total; i++) {
		var MyTab=document.getElementById("tab-"+i);
		if (MyTab) {
			if (i == tabId) {
				if (lock == i) {
					lock = 0;
				} else {
					lock = 0;
					switchIt(tabId)
					lock = i;
				}
			}
		}
	}
	AJAXSetMyTab(tabId);
}


function getXMLHttp() {
	var xmlHttp
	try { xmlHttp = new XMLHttpRequest(); }
	catch(e)  {
		try  { xmlHttp = new ActiveXObject("Msxml2.XMLHTTP"); }
		catch(e) {
			try { xmlHttp = new ActiveXObject("Microsoft.XMLHTTP"); }
			catch(e) {
				return false;
			}
		}
	}
	return xmlHttp;
}

function AJAXSetMyTab(tabId) {
	var xmlHttp = getXMLHttp();
	xmlHttp.open("GET", "',$corzblog['self'],'?ajax=true&SetMyTab=" + tabId, true);
	xmlHttp.send();
}

function AJAXSetMyInfoSize(pane,dragged) {
	var xmlHttp = getXMLHttp();

	var infoX = "none";
	var infoY = "none";
	var DinfoX = pane.offsetLeft;
	var DinfoY = pane.offsetTop;

	if (dragged == true) {
		infoX = DinfoX;
		StoreX = DinfoX;
		infoY = DinfoY;
		StoreY = DinfoY;
	} else {
		infoX = StoreX;
		infoY = StoreY;
	}
	var infoW = pane.clientWidth;
	var infoH = pane.clientHeight;

	pane.title = "Info Panel Current Dimensions (x,y,w,h): [" + DinfoX + "," + DinfoY + "," + infoW + "," + infoH + "]"

	var SendInfo = infoX + "," + infoY + "," + infoW + "," + infoH

	if ( document.getElementById("autosave_info") != null ) {
		if ( document.getElementById("autosave_info").checked == true ) {
			document.getElementById("info_sizes").value = SendInfo;
		}
	}

	xmlHttp.open("GET", "',$corzblog['self'],'?ajax=true&ResizeMe=" + SendInfo, true);
	xmlHttp.send();
}


function OpenPropInput(PropInput) {
	document.getElementById("props-" + PropInput).style.display = "block";
	var ThisPropButtImg = document.getElementById("prop-butt-img-" + PropInput);
	ThisPropButtImg.src = "',$GLOBALS['blog_scheme']['prop_butt_down_img'],'";
	ThisPropButtImg.onclick = function (){ClosePropInput(PropInput);};
}

function ClosePropInput(PropInput) {
	document.getElementById("props-" + PropInput).style.display = "none";
	var ThisPropButtImg = document.getElementById("prop-butt-img-" + PropInput);
	ThisPropButtImg.src = "',$GLOBALS['blog_scheme']['prop_butt_right_img'],'";
	ThisPropButtImg.onclick = function (){OpenPropInput(PropInput);};
}


function DeleteLinkButt(rowID) {
	if (doConfirm()) {
		document.getElementById("text-" + rowID).value = "";
		document.getElementById("linkrow-" + rowID).style.display = "none";
	}
}


function ShowHidePass() {
	var passInput = document.getElementById("password");
	if ( passInput.type == "password" ) {
		passInput.type = "text";
	} else {
		passInput.type = "password";
	}
}


//2do.. regexp arrays

function MoveLinkUpButt(LinkID) {

	var AboveID = LinkID-1;
	if (AboveID == 0) { return false; } // och well...

	var AboveDiv = document.getElementById("linkrow-" + AboveID);
	var ThisDiv = document.getElementById("linkrow-" + LinkID);

	var AboveContent = AboveDiv.innerHTML;
	var ThisContent = ThisDiv.innerHTML;

	// switch all the inner id/button/onclick numbers to match the new order
	var search = "name=\"" + AboveID;
	var replace = "name=\"" + LinkID;
	AboveContent = AboveContent.replace(new RegExp(search, "gi"), replace);
	ThisContent = ThisContent.replace(new RegExp(replace, "gi"), search);

	var search = "id=\"" + AboveID;
	var replace = "id=\"" + AboveID;
	AboveContent = AboveContent.replace(new RegExp(search, "gi"), replace);
	ThisContent = ThisContent.replace(new RegExp(replace, "gi"), search);

	var search = "butt-" + AboveID;
	var replace = "butt-" + LinkID;
	AboveContent = AboveContent.replace(new RegExp(search, "gi"), replace);
	ThisContent = ThisContent.replace(new RegExp(replace, "gi"), search);

	var search = "Butt\\\(" + AboveID;
	var replace = "Butt(" + LinkID;
	AboveContent = AboveContent.replace(new RegExp(search, "gi"), replace);

	var search = "Butt\\\(" + LinkID;
	var replace = "Butt(" + AboveID;
	ThisContent = ThisContent.replace(new RegExp(search, "gi"), replace);

	// switch the two div\'s contents HTML around..
	AboveDiv.innerHTML = ThisContent;
	ThisDiv.innerHTML = AboveContent;

	// hide innapropriate controls..
	if (!document.getElementById("linkrow-" + (AboveID-1))) {
		document.getElementById("link-up-butt-" + LinkID).style.display = "block";
		document.getElementById("link-up-butt-" + AboveID).style.display = "none";
	}
	if (!document.getElementById("linkro w-" + (LinkID+1))) {
		document.getElementById("link-down-butt-" + AboveID).style.display = "block";
		document.getElementById("link-down-butt-" + LinkID).style.display = "none";
	}
}


function MoveLinkDownButt(LinkID) {

	var BelowID = LinkID+1;
	if (!document.getElementById("linkrow-" + BelowID)) { return false; }

	var BelowDiv = document.getElementById("linkrow-" + BelowID);
	var ThisDiv = document.getElementById("linkrow-" + LinkID);
	var BelowContent = BelowDiv.innerHTML;
	var ThisContent = ThisDiv.innerHTML;

	// switch all the inner id/button/onclick numbers to match the new order
	var search = "name=\"" + BelowID;
	var replace = "name=\"" + LinkID;
	BelowContent = BelowContent.replace(new RegExp(search, "gi"), replace);
	ThisContent = ThisContent.replace(new RegExp(replace, "gi"), search);

	var search = "id=\"" + BelowID;
	var replace = "id=\"" + LinkID;
	BelowContent = BelowContent.replace(new RegExp(search, "gi"), replace);
	ThisContent = ThisContent.replace(new RegExp(replace, "gi"), search);

	var search = "butt-" + BelowID;
	var replace = "butt-" + LinkID;
	BelowContent = BelowContent.replace(new RegExp(search, "gi"), replace);
	ThisContent = ThisContent.replace(new RegExp(replace, "gi"), search);

	var search = "Butt\\\(" + BelowID;
	var replace = "Butt(" + LinkID;
	BelowContent = BelowContent.replace(new RegExp(search, "gi"), replace);

	var search = "Butt\\\(" + LinkID;
	var replace = "Butt(" + BelowID;
	ThisContent = ThisContent.replace(new RegExp(search, "gi"), replace);

	// switch the two div\'s contents HTML around..
	BelowDiv.innerHTML = ThisContent;
	ThisDiv.innerHTML = BelowContent;

	if (!document.getElementById("linkrow-" + (LinkID-1))) {
		document.getElementById("link-up-butt-" + LinkID).style.display = "none";
		document.getElementById("link-up-butt-" + BelowID).style.display = "block";
	}
	if (!document.getElementById("linkrow-" + (BelowID+1))) {
		document.getElementById("link-down-butt-" + LinkID).style.display = "block";
		document.getElementById("link-down-butt-" + BelowID).style.display = "none";
	}
}
';

	if ($do_info) {
		echo '

function insertInfo(infoTitle, infoText) {
	if ( document.getElementById("info-title") == null ) { return; }
	document.getElementById("info-title").innerHTML = infoTitle;
	document.getElementById("info-text").innerHTML = infoText;
}

function clearInfo() {
	if ( document.getElementById("info-title") == null ) { return; }
	document.getElementById("info-title").innerHTML = "tips:";
	document.getElementById("info-title").title = "hover your mouse over something ELSE!";
	document.getElementById("info-text").innerHTML = "',$tips_string,'";
}



function ResizeSizeMe(dirbutt) {

	var direction = dirbutt.id
	var len = dirbutt.id.length;
	direction = dirbutt.id.substring(10,len);
	var infopane = document.getElementById("info-panel");

	switch (direction) {
		case "taller":
			var curheight = infopane.clientHeight;
			infopane.style.height = (curheight + 15) + "px";
			break;
		case "shorter":
			var curheight = infopane.clientHeight;
			infopane.style.height = (curheight - 35) + "px";
			break;
		case "wider":
			var curwidth = infopane.clientWidth;
			infopane.style.width = (curwidth + 15) + "px";
			break;
		case "narrower":
			var curwidth = infopane.clientWidth;
			infopane.style.width = (curwidth - 35) + "px";
			break;
	}

	AJAXSetMyInfoSize(infopane, false);
}';
	}
	echo '
function doConfirm() {
	return confirm("really delete this link?");
}';
} else {
	echo '
function switchIt(tabId) {}';
}

if (!$do_info) {
	echo '
function insertInfo(infoTitle, infoText) {}
function clearInfo() {}';
}
echo '
window.onerror=function(){
	onerror = errreport;
	function errreport(msg,url,line) {
	var errtxt = "Error: " + msg + "\n" + "URL: " + url + "\n" + "Line Number: " + line + "\n\n";
	alert(errtxt);
	return true;
	}
}
//-->
//]]>
</script>
</head>
<body>';
}




// drag and drop information div..
//
function create_dragdrop() {
	global $do_info;
	if (!$do_info) { return; }
	global $info_sizes;
	echo '
<script>
//<![CDATA[
<!--
var doc = document;
var myCanvas = doc.getElementById("info-panel");

var OrigPos = true;

if (myCanvas.addEventListener) {
	myCanvas.addEventListener("mousedown", drag, false);
} else if (myCanvas.attachEvent) {
	myCanvas.attachEvent("onmousedown", drag);
} else {
	myCanvas.setAttribute("onmousedown", drag);
}
';

	if (is_array($info_sizes)) {
		echo '
var setpane = document.getElementById("info-panel");';
		if ($info_sizes[0] != 'none') {
			echo '
SwitchSizerButtons();
setpane.style.left = ',$info_sizes[0],' + "px";
setpane.style.top  = ',$info_sizes[1],' + "px";';
		}
echo '
setpane.style.width = (',$info_sizes[2],' - 10) + "px";
setpane.style.height = (',$info_sizes[3],' - 10) + "px";
OrigPos = false;

var is = document.getElementById("info_sizes");
var orig_size = is.value;

function CheckAutoSave() {
	var asi_cb = document.getElementById("autosave_info");
	var ip_is = document.getElementById("row-info_sizes");

	if ( asi_cb.checked == true ) {
		ip_is.style.display = "none";
		orig_size = is.value;
	} else {
		is.value = orig_size;
		ip_is.style.display = "block";
	}
}
';
	}

	echo '
function drag(e) {

	var ipane = document.getElementById("info-panel");
	var mousePosition = [0, 0];
	if (!e) var e = window.event;
	var dragObj = e.target ? e.target : e.srcElement;

	if (e.button == 0 || e.button == 1) {
		if (window.attachEvent) {
			mousePosition[0] = e.offsetX;
			mousePosition[1] = e.offsetY;
			e.returnValue = false;
		} else {
			mousePosition[0] = e.offsetX || e.layerX;
			mousePosition[1] = e.offsetY || e.layerY;
			e.preventDefault();
		}

		document.body.onmousemove = function(e) {
			if (!e) var e = window.event;
			dragObj.style.left = e.clientX - mousePosition[0] + "px";
			dragObj.style.top = e.clientY - mousePosition[1] + "px";

			if (OrigPos) {
				SwitchSizerButtons();
				OrigPos = false;
			}
		}

		document.onmouseup = function() {
			document.body.onmousemove = null;
			document.body.onselectstart = null;
			AJAXSetMyInfoSize(ipane, true);
		}

	}

	document.body.onselectstart = function() {
		return false;
	};
}


/* un-hooked info panel from corner - switch control buttons to new logical directions */
function SwitchSizerButtons() {

	// switch sizer buttons..
	document.getElementById("butt-size-taller").src = "',$GLOBALS['blog_scheme']['infobutt_shorter_img'],'";
	document.getElementById("butt-size-shorter").src = "',$GLOBALS['blog_scheme']['infobutt_taller_img'],'";
	document.getElementById("butt-size-wider").src = "',$GLOBALS['blog_scheme']['infobutt_narrower_img'],'";
	document.getElementById("butt-size-narrower").src = "',$GLOBALS['blog_scheme']['infobutt_wider_img'],'";

	// move sizer to top..
	document.getElementById("sizer").style.top = "2px";
	document.getElementById("sizer").style.left = "2px";

	// move info title to foot..
	document.getElementById("info-title").style.top = "auto";
	document.getElementById("info-title").style.bottom = "5px";
	document.getElementById("info-title").style.marginBottom = "0";

//	// move info text to above title..
//	document.getElementById("info-text").style.top = "auto";
//	document.getElementById("info-text").style.bottom = "26px";

}

//-->
//]]>
</script>
<noscript><!-- JavaScript Only --></noscript>';
}




if (!empty($GLOBALS['do_debug'])) { //:debug:
	debug("\n".'$_SERVER variables..'."\n\n");//:debug:
	while (list($key, $val) = each($_SERVER)) {//:debug:
	debug($key.chr(9).$val."\n"); }//:debug:
	debug('$_REQUEST: '."\t".print_r($_REQUEST, true)."\n\n");//:debug:
	debug('$_GET: '."\t".print_r($_GET, true)."\n\n");//:debug:
	debug('$_POST: '."\t".print_r($_POST, true)."\n\n\n");//:debug:
	debug('$GLOBALS: '."\t".print_r($GLOBALS, true)."\nCOMPLETED OUTPUT FOR admin.php\n\n\n");// :debug
	debug_out();//:debug:
}// :debug
?>