<?php  // ۞//  text { encoding:utf-8  ;  bom:no  ;  linebreaks:unix  ; tabs:4sp ; }
if (isset($corzblog['version'])) { return; } else {  $corzblog['version']='3.6b'; }
if  (realpath ($_SERVER['SCRIPT_FILENAME'])        ==       realpath (__FILE__))  {
                                             die ( 'to err is human, human!' ); }/*

	corzblog main initialization	[init.php v3.5.3]

		a part of corzblog.. http://corz.org/blog/

	This script gathers up all the preferences and gets everything ready for you

	If you need to set the blog path ("blogzpath") manually, that setting is
	just below these notes.

	Scroll for advanced corzblog prefs.

	;o) Cor

	(c) copyright 2003->tomorrow -> cor @ corz.org

*/


/*
	Note: it's probably not wise to edit this file
	unless you know what you are doing.

													*/



//**	System Stuff..
//*



// debug init..
if (file_exists(realpath($_SERVER['DOCUMENT_ROOT']).'/inc/debug.php')) {//:debug:
//echo '<pre>$DEBUGGING MODULE LOADED OK'."\n".'</pre>';//:debug

	include_once $_SERVER['DOCUMENT_ROOT'].'/inc/debug.php';//:debug:
	$GLOBALS['do_debug'] = 1;//:debug:
//	debug("\n".'$_SERVER variables..'."\n\n");//:debug:
//	while (list($key, $val) = each($_SERVER)) {//:debug:
//	debug($key.chr(9).$val."\n"); }//:debug:
//	debug('$_REQUEST: '."\t".print_r($_REQUEST, true)."\n\n");//:debug:
//	debug('$_GET: '."\t".print_r($_GET, true)."\n\n");//:debug:
//	debug('$_POST: '."\t".print_r($_POST, true)."\n\n\n");//:debug:
}//:debug:



ob_start();
@session_start();
require 'inc/functions.php';
$errz = new cbErrHandler();
$errz->cbstartErrorHandler();



//**	Paths..
/*

	automatically generated by your webserver..
	(it's usually best to leave these alone)
												*/
$corzblog['host'] = $_SERVER['HTTP_HOST'];
$corzblog['self'] = $_SERVER['SCRIPT_NAME'];
$corzblog['root'] = realpath($_SERVER['DOCUMENT_ROOT']);

/*
	Path from site root..

	If you are having problems, you can set this manually, e.g..

		$corzblog['blogzpath'] = '/blog/';

	This next line should work it out automatically, though..
															*/
$corzblog['blogzpath'] = substr(str_replace("\\", '/', dirname(__FILE__)), strlen($corzblog['root'])).'/';


// file system path to blog folder
$corzblog['path'] = $corzblog['root'].substr($corzblog['blogzpath'], 0, -1);


// your main configuration ini file..
$corzblog['ini_file'] = $corzblog['path'].'/inc/data/.ht_corzblog.ini';

// grab the configuration from the ini file..
$config_array = grab_ini($corzblog['ini_file']);

// "links" ini files..
$corzblog['main-links_ini_file'] = $corzblog['path'].'/inc/data/main-links.ini';
$corzblog['side-links_ini_file'] = $corzblog['path'].'/inc/data/side-links.ini';

// cbparser guide (placed under posting form)
$cb_guide_path = $corzblog['path'].'/inc/cbguide.php';

// some arbitrary value, larger than your largest link group..
$corzblog['link_splitter'] = 100;

// construct the full blog URL..
$prot_add = ''; // admins, please use SSL!
if (!empty($_SERVER['HTTPS']) and $_SERVER['HTTPS'] != 'off') { $prot_add = 's';}
$corzblog['blog_url'] = 'http'.$prot_add.'://'.$corzblog['host'].$corzblog['blogzpath'];

// we set these for extra features in the spell-checker	(find/replace)..
$corzblog['blogform_name'] = 'blogform';
$corzblog['blogform_area'] = $corzblog['blogform_name'].'-text';



// pre-un-authentication..

if (isset($_POST['logout'])) {
	unset($_SESSION['scheme_edit']);
	unset($_SESSION['current_scheme_name']);
}



//**	Authentication..
/*

	If you wish, in your preferences, instead of a password string, enter the
	location of the password file. It should be a simple text file containing
	only this password and should reside in a safe directory, preferably out of
	site root, possibly for site-wide pajamas authentication.
															*/
// use pajamas?..
if (isset($config_array['use_pajamas'])) {
	$corzblog['use_pajamas'] = $config_array['use_pajamas'];
} else {
	$corzblog['use_pajamas'] = true;
}

// technically, we *always* use pajamas, even for plain text passwords..

if ($corzblog['use_pajamas']) {
	$pj_module = 'pj';
} else {
	$pj_module = 'plain';
}
//2do.. add shaggie


// load pajamas..
include_once $corzblog['path'].'/inc/pajamas/pajamas.php';

// pajamas id..
if (isset($config_array['pajamas_id'])) {
	$corzblog['pajamas_id'] = $config_array['pajamas_id'];
} else {
	$corzblog['pajamas_id'] = $_SERVER['HTTP_HOST']; //$_SERVER['HTTP_HOST'] is a smart default for a site-wide login
}

// start pajamas session..
$auth = new pajamas($corzblog['pajamas_id']);



// override some pajamas preferences..
if (!empty($config_array['password'])) {
	if (file_exists($config_array['password'])) {
		$auth->_login_password = $corzblog['password'] = file_get_contents($config_array['password']);
	} else {
		$auth->_login_password = $corzblog['password'] = $config_array['password'];
	}
} else {
	$corzblog['password'] = $auth->_login_password;
}

if (!empty($config_array['auth_timeout'])) { $auth->_session_time = $config_array['auth_timeout']; }
$corzblog['auth_timeout'] = $auth->_session_time;

$auth->_default_module = $pj_module;
$auth->_code_location = $corzblog['blog_url'].'inc/pajamas/modules/client-side/md5.js';
$auth->_no_autocomplete = true;
$auth->_createForms = false;
$auth->_check_ip = false;

// check now..
$corzblog['is_authorized'] = $auth->auth_user();




//**	Divert Spammers..
/*
	Set a token when guests access index.php
	Only allow visitor access to add.php if index.php was visited /first/.
*/
if (isset($config_array['divert_spammers'])) {
	$corzblog['divert_spammers'] = $config_array['divert_spammers'];
} else {
	$corzblog['divert_spammers'] = false;
}

//<link rel="stylesheet" href="'.$config_array['site_css'].'" type="text/css" media="screen" />
//<link rel="stylesheet" href="'.$corzblog['blogzpath'].'inc/themes/'.$config_array['current_theme'].'/'.$config_array['current_theme'].'.css" type="text/css" media="screen" />
if ($corzblog['divert_spammers'] == true) {
	if ($corzblog['is_authorized'] or stristr($_SERVER['SCRIPT_NAME'], 'index.php')) { $_SESSION['corzblog']['correct_route'] = "1"; }

	// now check for that..
	if (!isset($_SESSION['corzblog']['correct_route']) and stristr($_SERVER['REQUEST_URI'], 'add.php')) { die(doc_type().'
<title>spam is not good, you know.</title>
<style media="screen">
/*<![CDATA[*/
<!--
html { font-size: 75%; }
body { background-image: url(); }
#feckoff {
	width: 720px;
	max-width: 800px;
	margin: 0 auto;
	margin-top: 4rem;
}
#feckoff-header {
	font-size: 10rem;
	margin: 0 0 2.5rem;
}
#feckoff-info {
	margin-bottom: 3rem;
}
#try-here {
	margin: 6rem 0;
	font-size: 175%;
	text-align: center;
}
//-->
/*]]>*/
</style>
</head>
<body>
<div id="feckoff">
	<h1 id="feckoff-header">
		Hold It!
	</h1>
	<h2 id="feckoff-info">
		You cannot access this page without first accessing the main blog page!
	</h2>
	<h3 id="really-take-a-hike">
		This is not a page to promote your blog.<br />
		Nor is it a place to dump your spam.<br />
		It is the place where <em>I blog.</em><br />
		You couldn\'t post here, even if you <em>*really*</em> wanted to.<br />
		<br />
		Still want in so badly?
	</h3>
	<h2 id="try-here">
		<a href="'.$corzblog['blog_url'].
			'" title="That\'s where the actual content is , see!" id="link-go-now">Try here!</span></a>
	</h2>
</body>
</html>');
	}
}



//**	user override file names

if (!empty($config_array['blog_file'])) { $corzblog['blog_file'] = $config_array['blog_file']; }
else { $corzblog['blog_file'] = 'blogz.blog'; }

//	whatever you use as your $corzblog['blog_file'] extension (above) will become
//	the global blog extension the default is ".blog", you could even
//	specify '.html' I guess. This works it out..

$corzblog['blog_filename_parts'] = explode('.', $corzblog['blog_file']);

// we will use this name for titles, etc.
$corzblog['blog_is'] = end($corzblog['blog_filename_parts']); // "blog"
$corzblog['blog_ext'] = '.'.$corzblog['blog_is']; // ".blog"






//**	"User" Prefs..


if (!empty($config_array['mysite'])) { $corzblog['mysite'] = $config_array['mysite'];
} else { $corzblog['mysite'] = 'my blog'; }
$corzblog['mysite_clean'] = strip_tags($corzblog['mysite']); // for use in titles, etc..


if (!empty($config_array['blogger'])) { $corzblog['blogger'] = $config_array['blogger'];
} else { $corzblog['blogger'] = 'new corzblogger'; }

if (!empty($config_array['mail_addy'])) { $corzblog['mail_addy'] = $config_array['mail_addy'];
} else { $corzblog['mail_addy'] = 'webmaster@'.$corzblog['host']; }
$corzblog['mashed_addy'] = mashed_mail($GLOBALS['corzblog']['mail_addy']);



//**	general prefs..


// this is the main sub-header, and also the rss feed description
if (!empty($config_array['description'])) { $corzblog['description'] = $config_array['description'];
} else { $corzblog['description'] = "I'm so happy with my blog I could slip a few bucks to corz.org!"; }


if (!empty($config_array['about_name'])) { $corzblog['about_name'] = $config_array['about_name'];
} else { $corzblog['about_name'] = 'about'; }
$corzblog['about_link'] = $corzblog['blogzpath'].$corzblog['about_name'].'-'.$corzblog['blog_is']; // used internally.

// other descriptions..
if (!empty($config_array['about_description'])) { $corzblog['about_description'] = $config_array['about_description'];
} else { $corzblog['about_description'] = 'This page is about me, or my band, or my dog, or something..'; }



//**	date and time..


if (!empty($config_array['time_zone'])) { $corzblog['time_zone'] = $config_array['time_zone'];
} else { $corzblog['time_zone'] = 'Europe/London'; }


// init..
// enter your own timezone..
if ((int)PHP_VERSION >= 5) { //:2do.. also use time diff input for time zone (auto-check for int)
	date_default_timezone_set($corzblog['time_zone']); // php5
}

if (!empty($config_array['time_diff'])) { $corzblog['time_diff'] = $config_array['time_diff'];
} else { $corzblog['time_diff'] = 0; }
$adjustment = ($corzblog['time_diff'] * 60 * 60);

if (!empty($config_array['feed_time_diff'])) { $corzblog['feed_time_diff'] = $config_array['feed_time_diff'];
} else { $corzblog['feed_time_diff'] = '+00:00'; }

if (!empty($config_array['date_format'])) { $corzblog['date_format'] = $config_array['date_format'];
} else { $corzblog['date_format'] = 'D jS F g:i a'; }
$date = date($corzblog['date_format'], time() + $adjustment);





// Newsfeed date..  W3DTF formatted date - alter the last part to match your timezone
// MUST be W3DTF formatted, or rfd feed dies!
$today = date('Y-m-d\TH:m:s',time() + $adjustment) . $corzblog['feed_time_diff'] ; // (mine is GMT +/-00)  //:2do.. pref for this?


if (!empty($config_array['truncate'])) { $corzblog['truncate'] = $config_array['truncate'];
} else { $corzblog['truncate'] = 18; }





//**	Archive Prefs


// archive message
if (!empty($config_array['arc_description'])) { $corzblog['arc_description'] = $config_array['arc_description'];
} else { $corzblog['arc_description'] = '(archives)'; }


// permalinks?
if (isset($config_array['permalinks'])) { $corzblog['permalinks'] = $config_array['permalinks'];
} else { $corzblog['permalinks'] = true; }

//	mod_rewritten permalinks..
if (isset($config_array['rewrite_links'])) { $corzblog['rewrite_links'] = $config_array['rewrite_links'];
} else { $corzblog['rewrite_links'] = false; }



/*
	(automatic) archiving and permalinking..

	for accessing the current blog as an archive named *this month*.
	mainly used for the permalinks.

	Essentially, we have to see into the future and produce a permalink
	based on what the archive *will* be called, once it's archived.

	the idea is that this will be transparent to the user.
*/

/*
	archive frequency
	blogs will be archived every ????

	choose from 'month' (the default), or 'quarter'.

	currently only 'month' and 'quarter' are supported
*/
if (isset($config_array['arc_frequency'])) { $corzblog['arc_frequency'] = $config_array['arc_frequency'];
} else { $corzblog['arc_frequency'] = 'monthly'; }

switch(substr($corzblog['arc_frequency'], 0, 4)) {

//	case 'week':
//		$corzblog['arc_frequency'] = 'week';
//		break;

	case 'quar':
		$this_month = date('m');
		$arc_period = 'Q'.ceil((integer) $this_month / 3);
		$corzblog['arc_frequency'] = 'quarter';
		break;

	default: // monthly
		$arc_period = strtolower(date('M'));
		$corzblog['arc_frequency'] = 'month';
}
$arc_period = date('Y').'-'.$arc_period;






// folders..

if (!empty($config_array['images_folder'])) { $corzblog['images_folder'] = $config_array['images_folder'];
} else { $corzblog['images_folder'] = 'img'; }

if (!empty($config_array['files_folder'])) { $corzblog['files_folder'] = $config_array['files_folder'];
} else { $corzblog['files_folder'] = 'stuff'; }

if (!empty($config_array['audio_folder'])) { $corzblog['audio_folder'] = $config_array['audio_folder'];
} else { $corzblog['audio_folder'] = 'audio'; }


/*
	archive directory

	this relative path works fine for 99% of situations
	and archiving will work inside ~user/ type sites, too.	*/

if (!empty($config_array['arc_dir'])) { $corzblog['arc_dir'] = $config_array['arc_dir']; }
	else { $corzblog['arc_dir'] = 'arc'; }

$corzblog['archive_dir'] = $corzblog['arc_dir'].'/';


if (!empty($config_array['no_blog_message'])) { $corzblog['no_blog_message'] = $config_array['no_blog_message'];
} else { $corzblog['no_blog_message'] = ''; }


// archives menu main title
//
if (isset($config_array['arcs_menu_name'])) { $corzblog['arcs_menu_name'] = $config_array['arcs_menu_name'];
} else { $corzblog['arcs_menu_name'] = 'archives'; }




/*
	automatic archiving..	[not yet implemented]2do
												*/
$automatic_archiving = false; // [not used yet]
/*

	allow blogs to roll-back.

	at the end of the month (or whatever period you set) and your blogs get archived,
	you will have an empty blog on the front page. Or..

	you may prefer to roll-back and display the most recent archive, even if they were
	from last month, or before.
							*/
$allow_rollback = false; // [not used yet - will probably just be automatic]
// keep X number of blogs on the front page, regardless of their age..
$rollback_number = 6; // [not used yet]






/*
	spam protection

	prevent known spammers from posting comments [none of those, yet]..
	if it's just you blogging, with a password, this is less important
	*/
$spam_protection = false; // (true/false) default: false







//**	Sidebar Preferences



//	main menu..
if (!empty($config_array['main_menu_name'])) { $corzblog['main_menu_name'] = $config_array['main_menu_name'];
} else { $corzblog['main_menu_name'] = 'blog..'; }

// blogs menu..
if (isset($config_array['blogs_menu_name'])) { $corzblog['blogs_menu_name'] = $config_array['blogs_menu_name'];
} else { $corzblog['blogs_menu_name'] = 'blogs'; }

// links menu..
if (isset($config_array['links_menu_name'])) { $corzblog['links_menu_name'] = $config_array['links_menu_name'];
} else { $corzblog['links_menu_name'] = 'links'; }

// feeds menu name..
if (isset($config_array['feeds_menu_name'])) { $corzblog['feeds_menu_name'] = $config_array['feeds_menu_name'];
} else { $corzblog['feeds_menu_name'] = 'feeds..'; }

// show feed links?
if (isset($config_array['show_feeds'])) { $corzblog['show_feeds'] = $config_array['show_feeds'];
} else { $corzblog['show_feeds'] = true; }



/*
	sidebar links

	you'll probably want to leave the first three roughly as they are.
	I'd personally prefer you left the rest as-is, too!

	remember, you gotta leave a link to corz.org somewhere, preferably the
	"powered by corzblog" button at the foot. what goes around..

	note the commas between quoted entries, and "." (dot) between conconations..
*/

// preset links..
$corzblog['main_links'] = array();
$corzblog['side_links'] = array();


/*
	Main Links..
				*/

// this is your links ini file..
$links_array = grab_ini($corzblog['main-links_ini_file']);
if (empty($links_array)) { // empty? insert default links..
	$corzblog['main_links'][] = array('text' => 'blog home', 'url' => '{path}', 'title' => 'go to current blog!');
	$corzblog['main_links'][] = array('text' => 'add a blog', 'url' => '{path}add.php', 'title' => 'add a fresh blog');
	$corzblog['main_links'][] = array('text' => 'edit blogs', 'url' => '{path}choose.php','title' => 'edit and archiving functions');
	$corzblog['main_links'][] = array('text' => 'configure', 'url' => '{path}admin.php', 'title' => '{mysite} configuration');
}

// fill the links array from the user's links ini file..
$i = 1;
foreach($links_array as $my_link => $my_property) { // "my" is usually something local.
	if ($my_link) {
		$corzblog['main_links'][$i] = array( 'text' => html_entity_decode(stripslashes($my_link), NULL, 'UTF-8'), 'url' => $my_property['url'], 'title' => $my_property['title'] );
		if (!empty($my_property['props'])) {
			$corzblog['main_links'][$i]['props'] = html_entity_decode($my_property['props'], NULL, 'UTF-8');
		}
	} else {
		unset($corzblog['main_links'][$i]);
	}
	$i++;
}

/*
	Side Links..
					*/

$links_menu_links = grab_ini($corzblog['side-links_ini_file']);
if (empty($links_array)) {
	$corzblog['side_links'][] = array('text' => 'corz home', 'url' => 'http://corz.org/', 'title' => 'home of cor, creator of corzblog');
	$corzblog['side_links'][] = array('text' => 'dynamic sig', 'url' => 'http://ampsig.com/', 'title' => 'a beautiful progressive dynamic signature image for the masses');
	$corzblog['side_links'][] = array('text' => 'corz dev blog', 'url' => 'http://corz.org/devblog/','title' => 'cor getting technical');
	$corzblog['side_links'][] = array('text' => 'get ßeta', 'url' => 'http://corz.org/engine?section=beta', 'title' => 'I trust it with my blog™ but it is a ßeta, you decide!');
}
$i = 1;
foreach($links_menu_links as $my_link => $my_property) { // "my" is usually something local.
	if ($my_link) {
		$corzblog['side_links'][$i] = array( 'text' => html_entity_decode(stripslashes($my_link), NULL, 'UTF-8'), 'url' => $my_property['url'], 'title' => $my_property['title'] );
		if (!empty($my_property['props'])) {
			$corzblog['side_links'][$i]['props'] = html_entity_decode($my_property['props'], NULL, 'UTF-8');
		}
	} else {
		unset($corzblog['side_links'][$i]);
	}
	$i++;
}




// if we had more link groups we could maybe wrap this up into a function










/*

//**	Styles..

					*/

// theme..
//$corzblog['current_theme'] = 'foobar';

if (!empty($config_array['current_theme'])) {
	if (file_exists($corzblog['path'].'/inc/themes/'.$config_array['current_theme'])) {
		$corzblog['current_theme'] = $config_array['current_theme'];
	}
}




//**	Color Scheme..



// set default scheme..
if (!empty($config_array['current_scheme_name'])) {
	$corzblog['current_scheme_name'] = $config_array['current_scheme_name'];
}


// tmp variable..
$get_scheme_name = '';

// read the color schemes from the schemes ini..
$blog_scheme_config = grab_ini($corzblog['path'].'/inc/themes/'.$corzblog['current_theme'].'/'.$corzblog['current_theme'].'.ini');


// scheme is set in session (admin editing or user-set scheme), assign current scheme from session..
//
if (isset($_SESSION['current_scheme_name'])) {
	if (array_key_exists($_SESSION['current_scheme_name'], $blog_scheme_config)) {
		$get_scheme_name = $_SESSION['current_scheme_name'];
	}

}

//**	    Scheme sent in COOKIE..
//
if (isset($_COOKIE['scheme']) and !(isset($_SESSION['scheme_edit']['current_scheme_name']))) {
	if (array_key_exists($_COOKIE['scheme'], $blog_scheme_config)) {
		$get_scheme_name = $_COOKIE['scheme'];
		// cookie always overrides session..
		$_SESSION['current_scheme_name'] = $get_scheme_name;
	} else {
		// delete invalid cookie..
		setcookie('scheme', $_COOKIE['scheme'], time() - 86400, '/');
		// nice idea for webmasters would be to create the same-named schemes for each theme they use,
		// that way, if you switch themes, the user can have their same chosen color scheme in your new theme.
	}
}


//**	    Scheme sent in GET/POST..

// GET/POST request overrides everything..		..AND sets a COOKIE.
// cookies /may/ be enabled in _REQUEST, so we check specifically for GET/POST..

$sent_scheme = NULL;
if (isset($_POST['scheme'])) { $sent_scheme = trim($_POST['scheme']); }
if (isset($_GET['scheme'])) { $sent_scheme = trim($_GET['scheme']); }
if (isset($sent_scheme)) {

	if ($sent_scheme == 'reset') {
		setcookie('scheme', '', time() - 86400, '/');
		unset($_SESSION['current_scheme_name']);
		unset($_SESSION['current_scheme']);
	} elseif (array_key_exists($sent_scheme, $blog_scheme_config)) {
		$get_scheme_name = $sent_scheme;
		$_SESSION['current_scheme_name'] = $get_scheme_name;
		unset($_SESSION['current_scheme']);
		setcookie('scheme', $get_scheme_name, time() + (365*24*60*60), '/');	// a year
	}
	if (isset($_REQUEST['goblog'])) { // we also set &ajax=true, for obvious reasons..
		if (trim($_REQUEST['goblog']) != '') {
			$goto = trim(str_replace($_SERVER['QUERY_STRING'], '', $_REQUEST['goblog']));

			//$goto = trim($_REQUEST['goblog']);
		} else {
			$goto = 'http://'.$corzblog['host'].'/';
		}
		die(header('Location: '.$goto));
	}
}


// okay, got it..
if (!empty($get_scheme_name)) {
	$corzblog['current_scheme_name'] = $get_scheme_name;
}


// assign the current theme array to single-dimensional $blog_scheme array, for use in css, etc..
$blog_scheme = $blog_scheme_config[$corzblog['current_scheme_name']];


// place all variables into session so we can get to them in site-wide css, use get_color_tokens() (in comments, etc.)..
if (empty($_SESSION['current_scheme'])) {
	$_SESSION['current_scheme'] = $blog_scheme;
}


// no longer required.. (and potentially large, though realistically, tiny for a php string)
$blog_scheme_config = $sent_scheme = '';





//**	Style Prefs..


// set the stylesheet (with scheme-specific refreshing params)..
$corzblog['style_sheet'] = $corzblog['current_theme'].'.css';


//$corzblog['css_modules_dir'] = $corzblog['root'].'/inc/css/modules';

$corzblog['css_modules_paths'] = array();
$corzblog['css_modules_paths'][] = $corzblog['path'].'/inc/themes/modules';
$corzblog['css_modules_paths'][] = $corzblog['root'].'/inc/css/modules';
$corzblog['css_modules_paths'][] = $corzblog['root'].'/inc/css/snippets';




//	Essential styles..

// in case they didn't set these..
// DO NOT REMOVE THIS SECTION!
// it is required by admin javascript inserts. feel free to set your own colors for these elements in scheme the prefs.
if (!isset($blog_scheme['butt_txt']))			{ $blog_scheme['butt_txt'] = '#fff'; }
if (!isset($blog_scheme['butt_txt_selected']))	{ $blog_scheme['butt_txt_selected'] = '#fff'; }
if (!isset($blog_scheme['butt_bg']))			{ $blog_scheme['butt_bg'] = '#777'; }
if (!isset($blog_scheme['butt_bg_hover']))		{ $blog_scheme['butt_bg_hover'] = '#000'; }


// highlight colour..
if (!isset($blog_scheme['spelling_highlight'])) { $blog_scheme['spelling_highlight'] = '#FFFF00'; }



// setup image locations to point to theme directory..
// if your image preference ends in "_img" or the image location begins with "images/", we will link them automatically, here..
foreach ($blog_scheme as $key=>$value) {
	if (substr($key, -4) == '_img' or substr($value, 0, 7) == 'images/') {
		if (substr($blog_scheme[$key], 0, 1) != '/') { // only if relatively linked in the prefs (redundant for 'images/')
			$blog_scheme[$key] = $corzblog['blogzpath'].'inc/themes/'.$corzblog['current_theme'].'/'.$blog_scheme[$key];
		}
		// if it's a hover image, add it to the preloader array..
		if (stristr($blog_scheme[$key], 'hover')) { $preloader_array[] = $blog_scheme[$key]; }
	}
}

// essential images not set in scheme prefs..
$corzblog['corzblog_logo_img'] = $corzblog['blogzpath'].'inc/img/corzblog.png';
$corzblog['corzblog_logo_hover_img'] = $corzblog['blogzpath'].'inc/img/corzblog_hover.png';

if (isset($blog_scheme['corzblog_logo_img']) and isset($blog_scheme['corzblog_logo_hover_img'])) {
	$corzblog['corzblog_logo_img'] = $blog_scheme['corzblog_logo_img'];
	$corzblog['corzblog_logo_hover_img'] = $blog_scheme['corzblog_logo_hover_img'];
} else {
	// when not set in scheme, it will not be automatically added to preloader, so..
	$preloader_array[] = $corzblog['corzblog_logo_hover_img'];
}


// site-wide styles.. a toolbar or nav menu, perhaps..
if (!empty($config_array['site_css'])) { $corzblog['site_css'] = $config_array['site_css'];
} else { $corzblog['site_css'] = ''; }

// site-wide styles.. a toolbar or nav menu, perhaps..
if (!empty($config_array['html5_shiv'])) { $corzblog['html5_shiv'] = $config_array['html5_shiv'];
} else { $corzblog['html5_shiv'] = ''; }


// make uber-tiny-style-files..
if (isset($config_array['minify_css'])) { $corzblog['minify_css'] = $config_array['minify_css'];
} else { $corzblog['minify_css'] = true; }


// let the browser keep the styles for a while..
if (isset($config_array['cache_styles'])) { $corzblog['cache_styles'] = $config_array['cache_styles'];
} else { $corzblog['cache_styles'] = true; }


// you will probably spot no visible difference..
if (isset($config_array['sidebar_first'])) { $corzblog['sidebar_first'] = $config_array['sidebar_first'];
} else { $corzblog['sidebar_first'] = false; }






//**	Advanced Prefs..


if ( isset($config_array['custom_header']) and !empty($config_array['custom_header']) ) {
	$corzblog['custom_header'] = $corzblog['root'].$config_array['custom_header'];
} else {
	$corzblog['custom_header'] = '';
}

if ( isset($config_array['custom_metadata']) and !empty($config_array['custom_metadata']) ) {
	$corzblog['custom_metadata'] = $corzblog['root'].$config_array['custom_metadata'];
} else {
	$corzblog['custom_metadata'] = '';
}



if ( isset($config_array['custom_footer']) and !empty($config_array['custom_footer']) ) {
	$corzblog['custom_footer'] = $corzblog['root'].$config_array['custom_footer'];
} else {
	$corzblog['custom_footer'] = '';
}






// validation links for HTML and CSS
if (isset($config_array['show_valid_links'])) {
	$corzblog['show_valid_links'] = $config_array['show_valid_links'];
} else {
	$corzblog['show_valid_links'] = true;
}


// show page timer at foot
if (isset($config_array['show_page_timer'])) {
	$corzblog['show_page_timer'] = $config_array['show_page_timer'];
} else {
	$corzblog['show_page_timer'] = false;
}


// info panel position override..
$corzblog['info_sizes'] = '';
if (isset($config_array['info_sizes']) and !empty($config_array['info_sizes'])) {
	$corzblog['info_sizes'] = $config_array['info_sizes'];
}


// Auto-Save size/position of info panel..
if (isset($config_array['autosave_info'])) { $corzblog['autosave_info'] = $config_array['autosave_info'];
} else { $corzblog['autosave_info'] = false; }




// Google Analytics main switch..
if (isset($config_array['ga_code'])) {
	$corzblog['ga_code'] = $config_array['ga_code'];
} else {
	$corzblog['ga_code'] = false;
}








//**	Spell-Checking..



// default spell-checking options..

// show spell-checker? ..
if (isset($config_array['spell_checker'])) { $corzblog['spell_checker'] = $config_array['spell_checker'];
} else { $corzblog['spell_checker'] = true; }

// spell-check right off the bat?
if (isset($config_array['begin_spell_check'])) { $corzblog['begin_spell_check'] = $config_array['begin_spell_check'];
} else { $corzblog['begin_spell_check'] = false; }

// dictionary.com links..
if (isset($config_array['dictionary_links'])) { $corzblog['dictionary_links'] = $config_array['dictionary_links'];
} else { $corzblog['dictionary_links'] = true; }

// dictionary.com links provider..
if (isset($config_array['dictionary_url'])) { $corzblog['dictionary_url'] = $config_array['dictionary_url'];
} else { $corzblog['dictionary_url'] = ''; } // defaults to 'http://dictionary.reference.com/search?q='



// enable suggestion?
if (isset($config_array['enable_suggestion'])) { $corzblog['enable_suggestion'] = $config_array['enable_suggestion'];
} else { $corzblog['enable_suggestion'] = true; }

// use metaphones?
if (isset($config_array['enable_metaphones'])) { $corzblog['enable_metaphones'] = $config_array['enable_metaphones'];
} else { $corzblog['enable_metaphones'] = true; }


// location of word list..
if (isset($config_array['word_list'])) { $corzblog['word_list'] = $config_array['word_list'];
} else { $config_array['word_list'] = $corzblog['word_list'] = 'english.list'; }

// user word lists folder..
if (isset($config_array['user_dic_folder'])) { $corzblog['user_dic_folder'] = $config_array['user_dic_folder'];
} else { $config_array['user_dic_folder'] = $corzblog['user_dic_folder'] = 'user'; }

if (isset($config_array['user_dic'])) { $corzblog['user_dic'] = $config_array['user_dic'];
} else { $config_array['user_dic'] = $corzblog['user_dic'] = 'corz.dic'; }




if ((substr($corzblog['self'], strrpos($corzblog['self'], '.')) == '.php') and ($corzblog['spell_checker'])) {


	// include the spell-checker..
	if (file_exists($corzblog['path'].'/inc/spelling.php')) {
		include_once $corzblog['path'].'/inc/spelling.php';
		$spelling = new spelling();
		if (!class_exists ('spelling')) {
			$corzblog['spell_checker'] = false;
		}
	}

	if ($corzblog['spell_checker']) {

		// spelling overrides..
		$spelling->_spelling_highlight			= $blog_scheme['spelling_highlight'];
		$spelling->_dim_color					= $blog_scheme['spelling_dim'];
		$spelling->_dictionary_links			= $corzblog['dictionary_links'];
		if ($corzblog['dictionary_url']) {	$spelling->_dictionary_link_provider = $corzblog['dictionary_url']; }
		$spelling->_default_word_list			= 'spelling/'.$corzblog['word_list'];
		$spelling->_user_dic_folder				= 'spelling/'.$corzblog['user_dic_folder'];
		$spelling->_default_user_dic			= $corzblog['user_dic'];
		$spelling->_enable_suggestion			= $corzblog['enable_suggestion'];
		$spelling->_enable_metaphones			= $corzblog['enable_metaphones'];



		// authorized to add to dictionary?..
		$spelling->_authorized = $corzblog['is_authorized'];

		// deal with any AJAX requests..
		$spelling->check_ajax();
	}
}



// can you believe we still need to check for this? Damn IE!
$blog_scheme['UA'] = strtolower(@$_SERVER['HTTP_USER_AGENT']);
if (trim($blog_scheme['UA']) == '')  { $blog_scheme['UA'] = '-'; }




// Load cbparser now..
require_once 'inc/cbparser.php';
$cbparser = new cbparser();
//$cbparser->_spammer_file = '/inc/data/spammer_strings.txt';
$cbparser->_mail_addy = $corzblog['mail_addy'];

//unused..
//textview_delims="#663399"
//textview_variable="#0fcd0a"
$cbparser->_highlight_string = $blog_scheme['textview_string']; // '#E53600';
$cbparser->_highlight_comment = $blog_scheme['textview_comment'];	//old='#FFAD1D';
$cbparser->_highlight_keyword = $blog_scheme['textview_keyword'];	// old='#47A35E';
$cbparser->_highlight_bg = $blog_scheme['ccc_bg'];	// ffffff
$cbparser->_highlight_default = $blog_scheme['textview_default'];	//old='#3F6DAE';
$cbparser->_highlight_html = $blog_scheme['textview_html'];	//old='#0D3D0D';






// finalize debug output..
function debug_out() {//:debug:
	if (!empty($GLOBALS['do_debug'])) { debug('out'); }//:debug:
}//:debug:


?>