<?php	/* --- ۞---> text { encoding:utf-8;bom:no;linebreaks:unix;tabs:4sp; } */
if (realpath ($_SERVER['SCRIPT_FILENAME'])       ==      realpath (__FILE__))  {
				  usleep(1000000); header('Location: spelling-demo.php'); die; }
/*

	cor's easy peezy php spell-checker

	originally a part of corzblog.. http://corz.org/blog/

		I lost and greatly missed my pspell!

		I didn't need a full-scale spell-check, just a typo check, really, however, this code turned out to be a *lot*
		faster than I anticipated, so I went all the way and had it do fuzzy matching and suggestions and all sorts.

		It comes with its own GUI which you can slip into whatever you are using to create the text, with spell-check
		options, dictionary additions, bad-word replacement, ignore, fuzziness, and so on. Quite neat, and can be seen
		working away here:

			http://corz.org/blog/inc/spelling-demo.php


		I've included three highly useful word lists† with the spell-checker..

		basic.list			...		around 13,000 common and simple words, names, etc.
		english.list		...		around 43,500 words, covers most thing. highly useful.
									this is what I mostly use, and add general words to.
		english_big.list	...		over 110,000 words, quite comprehensive, probably overkill.

		These are derived from a wide selection of free word lists, expanded to my particular specs. Everything in
		basic.list is inside english.list, and english_big.list contains both of these, pretty much. Do feel free to use
		your own word list, there are loads out there. (if using your own lists, see caveats (below))

	notes:

		Bigger lists take longer to check, but it is *very* fast. A 2000 word blog, checked against the 110,000 word
		list at corz.org takes around 0.15 seconds. Well, I'm impressed!

		† technically, these are lists, not "dictionaries" because there are no word definitions.


	usage:

		Here's your spell-checking code, at the simplest level..

			// include the script..
			include '/full/path/to/spelling.php';

			// initialize the spell-checker..
			$spelling = new spelling();

			// when you need to spell-check a string..
			$string = $spelling->check_spelling($string);

			That's it!

		The string can be plain text or bbcode or x|html. If you send bbcode/x|html, it will only check the "real"
		words, not the contents of your tags, id's, etc.

		You can specify default word lists and a "user" word lists folder, and *every* file inside that folder will be
		added to the word list. This is useful for any personal/ medical/technical dictionaries you might have, just
		chuck them all in that folder. You can also leave this folder empty, no problem.

		You can override any of the built-in defaults by specifying them *after* including the spell-checker, but
		*before* calling the check_spelling function, like this..

			// override spelling prefs..
			$spelling->_default_word_list = $_SERVER['DOCUMENT_ROOT'].'/inc/spelling/english.list';
			$spelling->_user_dic_folder = $_SERVER['DOCUMENT_ROOT'].'/inc/spelling/user/';


		The check_spelling function has many optional parameters, so you can switch things on and off as required. See
		the public variables & functions (methods) inisde the class for the full set.


		If you only want to know what words were misspelled, there is global array available containing all those
		words..

			$spelling->_misspelled_words

		So you can check that after the spell-check, perhaps do something like this..

			if (isset($spelling->_misspelled_words)) {
				echo '<small>[<strong>note:</strong> improbable words have been
				<span style="background-color:#FFFF00">highlighted</span>]</small>';
			}

		If you want the list returned in a nice box with "add to dictionary" and "ignore" links, use..

			$spelling->make_list_of_bad_words()

		You can get a readout of what user word lists were used in the spell-check by accessing..

			$spelling->_user_word_lists


		The spell-checker has a few built-in GUI elements you may find useful, for instance..

			$spelling->output_spell_options();

		Will get you that groovy bar with the spell-schecker options checkboxes in it.

		If you want a printout of the spelling suggestions, rather than parse the list yourself, just do..

			$spellling->suggest_words();

		Which will output a neat div filled with the suggested alternative spellings (as well as add/ignore and
		find/replace links). See the demo for some css and layout suggestions.

		Oh yes! I've created a "spelling-demo", which is a fully working, fully-fledged spell-checker for your fun and
		amusement. As well as a working example of how to implement the spell-checker, it's a handy place to test stuff
		out, and even *gasp* .. do spell-checking!

		It features a form for text input with all your spell options underneath, configurable spelling suggestions,
		AJAX add-to-dictionary and ignore links and one-click Search-and-Replace of dubious words. All these goodies are
		inside the spelling class, the demo shows you how to get to them. The link is now above!

		Look inside the corzblog code (init.php, edit.php, add.php) for another easy peezy php spell-checker
		implementation.


	caveats:

		1.	The word list must be in UNIX format, that is, it must have standard "\n" line breaks. If you are using a
			DOS/Windows "\r\n" or mac "\r" word list, open it in any decent text editor and convert its line breaks to
			UNIX format before use.

		2.	All words in the word list must be lower-case (that's "foo", not "Foo" or "FOO").

		3.	Files beginning with a "." (dot), or ending with an ".txt" extension cannot and will not be used as word
			lists. ALL other files in the /user/ word list folder will be treated as word lists.

		4.	If *every* word seems to be misspelled, check caveat 1.

		5.	Do $spelling->output_spell_options(); INSIDE the form you are sending (the one with the textarea in it), or
			else the options will be ingored (browsers can only send one form at a time, syat).


	bugs & foibles:

		If a misspell is say, "str", words containing it ("strobe" or "astral", for example) will come back part-
		highlighted.


	have fun!

	;o) Cor

	(c) 2006->tomorrow! ~ cor + corz.org ;o)

	Please view the license for this free software, here:

		http://corz.org/free-scripts-licence.nfo

*/


class spelling {


	var $_version					= '0.8.3';


	// default word lists..			(relative to *this* directory - where spelling.php lives)
	public $_default_word_list			= 'spelling/english.list';
	public $_user_dic_folder			= 'spelling/user';
	public $_default_user_dic			= 'user.dic';
	/*
		If you like, you can specify a single word list that also acts as your user list (so words are added to it),
		even run everything in one directory, e.g..

			public $_default_word_list			= 'my.list';
			public $_user_dic_folder			= '';
			public $_default_user_dic			= 'my.list';

		NOTE: You can also supply ther FULL path for the _default_word_list and _user_dic_folder preferences, and the
		spell-checker will use those, instead.
	*/

	public $_spelling_highlight			= '#FFFF00'; // like a highlighter pen through the word.
	public $_dim_color					= '#FFFFCC'; // when spelling options are dimmed, what color to use?


	/*
		dictionary link					[default: public $_dictionary_links =  true;]

		If your server is extremely slow, you can fall back on *only* this, but it's neat to leave it enabled at all
		times, I think. All misspelled words will be wrapped in a link which will take you directly to a dictionary.com
		(or whatever) search for the wonky word.

		Thank Tokyorose for this neat idea!

	*/
	public $_dictionary_links			= true;


	/*
		dictionary link provider

		By default, corzblog uses dictionary dot com for the dictionary links, but you can choose another provider,
		here. Please enter the full URL up to and including the query parameter, e.g..

		http://www.foobar.com/spelling?word=

	*/
	public $_dictionary_link_provider	= 'http://dictionary.reference.com/search?q=';



	/*
		Suggest spellings?						[default: public $_do_suggest =  false;]

		Suggest alternative spellings?

		If you want more than a simple typo check (with optional dictionary.com links), set this to true. Now the
		spell-checker will use the user- defined word lists (set above) to suggest words it considers to be "close" to
		the misspelled word.

		It uses a levenshtein algorithm to decide which words are possible matches. The complexity of the algorithm is
		O(x*y), where x and y are the length of the misspelled word and reference word, respectively. Essentially, it
		calculates the number of changes it would take to make word x into word y.

		On my server, this adds only around 0.2 seconds to a 2000 word post checked against a 46,000 word list with six
		misspelled words

		This is best left at false, enabling automatic user override.

	*/
	public $_do_suggest				= false;



	/*
		Parse bbcode?									[default: public $_parse_bbcode =  true;]

		When enabled, cbparser parses bbcode into html (with cbparser). Part of
		spell-checkers standard operation is to remove HTML tags, so the
		transformed bbcode (now HTML) is spel-checked as plain text.

		You can disable bbcode parsing if you like. cbparser will still spell-
		check bbcode, but may get confused about what is words and what is
		bbcode tags, e.g. "reftxt".

	*/
	public $_parse_bbcode			=	true;


	/*
		cbparser location..					[default: public $_cbparser_location =  'cbparser.php';]

		Provide the full server path to the cbparser bbcode parser. Or..
		If cbparser.php lives in the same folder as spelling.php, using
		'cbparser.php' alone is fine.

	*/

	public $_cbparser_location					= 'cbparser.php';




	// you can completely disable certain functionality, too..

	// If you want to prevent the suggestion facility altogether, set this to false.
	// users won't be able to see these checkboxes at all.
	public $_enable_suggestion			= true;

	// If you want to disable metaphone matching altogether (perhaps on a very slow server) set this to true.
	// Users won't be able to choose this (or the fuzzy matching) option if you set this to false.
	public $_enable_metaphones			= true;


	// this will be filled with  all the misspelled words
	public $_misspelled_words			= array();


	// you can quickly access the current count of misspelled words at any time..
	public $_bad_word_count			= 0;


	/*
		EXTRA Fuzzy..
		You can make the fuzzy searching EXTRA fuzzy by setting this to true..

		$spelling->_extra_fuzzy = true

		Note: this will return *lots* of matches!
	*/
	public $_extra_fuzzy				= false;


	// Authorize adding to dictionaries..
	public $_authorized				= false;
	// I expect you will set this to true upon some kind of authentication process.


	public $_do_spell_check				= true;


	// You can access the spell-checking timer, like so..
	//
	//	echo 'Total time taken: '.substr($spelling->_total_time, 0, 5).' seconds';
	//
	public $_total_time					= 0;


	// this is returned by check_spelling(), but you can also access it via this..
	public $_original_string = '';

	// if any bbcode->html conversion was performed, this will contain the HTML string..
	// begins as a boolean for easy bbcode->HTML conversion checking.
	public $_html = false;


	var $_user_word_lists = '';



	// private properties..
	//

	/*
		use metaphones?			[default: private $_use_metaphones =  false;]

		This gives you a much wider range of spelling suggestions, basically adding words that "sound like" the
		misspelled words. For instance "backk" wouldn't only match "back", but also back, backs, bake, beck, and buck.

		But this adds a large slice of time onto the spell-checking, but if your spelling is really bad, or you haven't
		a clue what the word is, enable this.

		On my server, this adds around 2 seconds for a 2000 word text checked against a 46,000 word list with six
		misspelled words. Still well within acceptable limits for a full spell-check. The more words you misspell, the
		longer it takes to compute the metaphones. It's still surprisingly fast.

		Note: this is best left at false, so the user can enable if required from the spelling options
	*/
	private $_use_metaphones			= false;

	/*
		allow fuzzier results?		[default: private $_match_fuzzy =  false;]

		Will get you sometimes one or two, sometimes many more results, depending. "woirds" will now match birds,
		boards, cords, fords, lords, swords, thirds, wards, weird, winds, wires, woods, word, words, wordy, works,
		worlds, worms, and wounds!

		Again, leave it at false so it can be chosen from the options.
	*/
	private $_match_fuzzy				= false;


	private $_suggestions				= array();		// we will fill this
	private $_my_path					= '';			// will be set internally in class initialization



	// spell-check user options..
	// these will be set by incoming _POST variables..
	private $_option_spelling			= 'checked="checked"';
	private $_option_suggest			= '';
	private $_option_metaphones			= '';
	private $_option_fuzzy				= '';


	/* constructor (init)..

								*/
	function __construct() {


		$this->_my_path = realpath($_SERVER['DOCUMENT_ROOT']).substr(str_replace("\\", '/', dirname(__FILE__)), strlen(realpath($_SERVER['DOCUMENT_ROOT']))).'/';

		// we put ignored words in here..
		if (!isset($_SESSION['spell-checker'])) {
			@session_name('spell-checker');
			@session_start();
		}

		/*
		user submitted spell-check options..		*/
		if (isset($_POST['spell-checker'])) {

			if (isset($_POST['do-spelling']))			{ $this->_do_spell_check = true; } else { $this->_do_spell_check = false; }
			if (isset($_POST['suggest']))				{ $this->_do_suggest = true; }
			if (isset($_POST['metaphones']))			{ $this->_use_metaphones = true; }
			if (isset($_POST['fuzzy']))					{ $this->_match_fuzzy = true; }

			if ($this->_do_spell_check)		{ $this->_option_spelling = 'checked="checked"'; }
			if ($this->_do_suggest)			{ $this->_option_suggest = 'checked="checked"'; }
			if ($this->_use_metaphones)		{ $this->_option_metaphones = 'checked="checked"'; }
			if ($this->_match_fuzzy)		{ $this->_option_fuzzy = 'checked="checked"'; }
		}
	}




	/*
		Handle AJAX requests..
		We call this as a function, enabling us to do authentication in the calling script, first.
									*/
	public function check_ajax() {
		if (isset($_GET['ajax'])) {
			switch (true) {
				// only one, for now..
				case isset($_GET['AddToDict']):
					$this->add_to_dictionary($_GET['AddToDict']); // ?ajax=true&AddToDict=NewWord
					die;

				case isset($_GET['IngoreWord']):
					$this->ignore_word($_GET['IngoreWord']); // ?ajax=true&IngoreWord=SomeWord
					die;
			}

		}
	}




	/*
		check spelling

		use:

			string $spelling->check_spelling( {string} );

		returns the string with (optionally) the misspelled words
																*/
	public function check_spelling() {

		ini_set ('max_execution_time', 60); // just in case!

		if ((func_num_args() > 0) and func_get_arg(0)) { $string = func_get_arg(0); } else { return; }

		if (trim($string) == '') { return; }

		$this->_original_string = $string = $this->do_slashes($string);

		if (!$this->_do_spell_check) { return $string; }

		// convert bbcode to html..
		if ($this->_parse_bbcode and $this->_cbparser_location !== '') {
			if (stristr($string, '[/')) {
				if (!method_exists('cbparser', 'bb2html')) {
					include_once $this->_cbparser_location;
					$cbparser = new $cbparser();
				}
				$string = $GLOBALS['cbparser']->bb2html($string); // bbcode is now HTML
				// store that, in case calling script needs it..
				$this->_html = $string;
			}
		}


		// start the clock..
		$start_time = array_sum(explode(' ', microtime()));

		// remove html tags, store them..
		// <b>bold</b> becomes.. **%+%**9999bold**%+%**10000, etc.
		$tags = array(); $i = 9999;
		while ($t_string = strstr($string, '<')) {
			$t_string = substr($t_string, 0, strpos($t_string, '>') + 1);
			$string = str_replace($t_string, "**%+%**$i", $string);
			$tags[$i] = $t_string; $i++;
		}

		// we work with $check_string now.
		$check_string = html_entity_decode($string, ENT_NOQUOTES, 'UTF-8');

		// set the full path to the main word lists..
		if (!empty($this->_default_word_list)) {
			if ((!substr($this->_default_word_list, 0, 1) != '/') and (!substr($this->_default_word_list, 1, 1) != ':')) {
				$this->_default_word_list = $this->_my_path.$this->_default_word_list;
			}
		}

		// load the word list(s)..
		$files_as_string = $this->get_file_into_string($this->_default_word_list);

		if (!empty($GLOBALS['errors']['get_file_into_string'])) {
			if ($this->_authorized) {
				return func_get_arg(0).$original_string.'<br /><h2 class="warning">'.$GLOBALS['errors']['get_file_into_string'].'</h2><br />';
			} else {
				return $original_string;
			}
		}

		// set path to user word list..
		if (!empty($this->_user_dic_folder)) {
			if ((substr($this->_user_dic_folder, 0, 1) != '/') and (substr($this->_user_dic_folder, 1, 1) != ':'))  {
				$this->_user_dic_folder = $this->_my_path.$this->_user_dic_folder;
			}
		}
		$files_as_string .= $this->get_user_words($this->remove_trailing_slash($this->_user_dic_folder).'/');


		// add ignored words to the list..
		if (isset($_SESSION['spell_checker'])) {
			$ignored_words = '';
			foreach ($_SESSION['spell_checker']['ignored_words'] as $ignored_word) {
				$ignored_words .= $ignored_word."\n";
			}
			// add to start of list, for quickness..
			$files_as_string = $ignored_words.$files_as_string;
		}


		// prepare the word lists for comparison..
		$words_list = array_flip(explode("\n", $files_as_string)); // it's quicker to check keys (with isset())
//		$check_words_array = array_unique(preg_split('/[^a-zA-Zàáâãäåæçèéêëìíîïðñòóôõö÷øùúûüýþÿ™€£”“’‘©®ß±°Þ»«\']+/', $check_string, -1, PREG_SPLIT_NO_EMPTY)); // could add "-"
		$check_words_array = array_unique(preg_split('/[^a-zA-Zàáâéèêìíòóôùú\']+/', $check_string, -1, PREG_SPLIT_NO_EMPTY)); // could add "-"
		$typos = array(); // for clarity.


		// might be quicker to remove stored html tag from $typos (flip-rem-flip)
		foreach($check_words_array as $check_this) {

			if (strlen(utf8_decode($check_this)) == 1) { continue; } // some characters would report 3 or more without utf8_decode()

			// filter out any unusual "'" results (folk use these as quotes, too)..
			if (substr($check_this, -2) == "'s") { $check_this = substr($check_this, 0, -2); } // "???'s"
			if (substr($check_this, -1) == "'") { $check_this = substr($check_this, 0, -1); } // ???'
			if (substr($check_this, 0, 1) == "'") { $check_this = substr($check_this, 1); } // '???

			if (!empty($check_this) and !isset($words_list[strtolower($check_this)]) and ($check_this != '**%+%**')) {
				$typos[] = $check_this; // array_push, basically.
			}
		}

		$typos = array_values(array_unique($typos));
		$removers = array ('st','nd','rd','th'); // regardless of your word list, we will not catch these.	("1st", after numeric trim == "st")
		$limit = count($typos);
		for ($i=0; $i<$limit; $i++) {
			if (in_array(strtolower($typos[$i]), $removers)) { // quicker, if there's less than 30 misspelled words
				unset($typos[$i]);
			}
		}

		natcasesort($typos);

		// create a global array you can check..
		$this->_misspelled_words = $typos;
		$this->_bad_word_count = count($this->_misspelled_words);

		// suggest..
		if ($this->_do_suggest) {

			$words_list = array_flip($words_list); // and back again


			foreach($words_list as $test) {

				foreach($typos as $this_booboo) { // run through the dubious words, many many times...

					// I like this technique, gives good results.
					$word_score = 4;

					$word_lev = levenshtein(strtolower($this_booboo), $test);
					if ($word_lev < $word_score) { $word_score = $word_lev; }
					if ($this->_use_metaphones) {
						$fuzzy = 1;
						if ($this->_match_fuzzy) {
							$fuzzy = 2;
							if ($this->_extra_fuzzy) { $fuzzy = 3; }
						}
						if (levenshtein(metaphone($this_booboo), metaphone($test)) < $fuzzy) { // think about it!
							$word_score--;
						}
					}
					if ($word_score < 2) {	//2do - put best hits first
						$this->_suggestions[$this_booboo][] = $test;
					}
				}
			}
		}


		// stop the clock..
		$end_time = array_sum(explode(' ', microtime()));
		$this->_total_time = $end_time - $start_time;

		// Now we work with original $string again..
		foreach($typos as $rep_word) {
			$string = str_replace($rep_word, '***1***'.$rep_word.'***2***', $string);
		}

		// Make misspelled words into dictionary.com links..
		if ($this->_dictionary_links) { $string = $this->make_dictionary_links($string, $typos); }

		// Re-insert the html tags..
		$cp = count($tags) + 9998;
		for ($i=9999;$i <= $cp;$i++) {
			$string = str_replace("**%+%**$i", $tags[$i], $string);
		}

		// It's safe to insert <span> now (even if it contains your typos)
		$string = str_replace('***1***', '<span class="spelling-error">', $string);
		$string = str_replace('***2***', '</span>', $string);

		return $string;
	}


	/*
		Spelling Options..

		Returns a small div strip where users can select what spelling options they require.
																						*/
	public function output_spell_options() {

		if (!$this->_do_spell_check) { $this->_option_spelling = ''; }

		echo '
		<div class="spell-options" id="spelloptions" title="note: disabled options are not remembered when you re-load">
			<div id="checkspellinputs">
				<input type="hidden" name="spell-checker" value="spell-checker" />
				<span id="spop" title="Enable automatic spell-checking of your text."><label for="do-spelling" class="spell-option-label">spell-checking:</label>';

		echo '</span>&nbsp;
				<input type="checkbox" value="do-spelling" id="do-spelling" name="do-spelling" ',$this->_option_spelling,' onclick="check_state();" />&nbsp;&nbsp;';


		// this saves us having to write heaps of crazy conditional php inside the JavaScript output!..
		$dummy_mtf = '<span id="mtf"></span><span id="metaphones"></span>';
		$dummy_fmps = '<span id="fmps"></span><span id="fuzzy"></span>';

		if ($this->_enable_suggestion) {
			echo '
				<span id="sgsp" title="I can suggest alternative, (theoretically) correct spellings.">
				<label for="suggest" class="option-label">suggest:</label>
				<input type="checkbox" value="suggest" name="suggest" id="suggest" ',
					$this->_option_suggest,' onclick="check_state();" /></span>';

			if ($this->_enable_metaphones) {
				echo '
				<span id="mtf" title="I can suggest words that \'sound like\' your word. It\'s slower, but returns more alternatives.">
				<label for="metaphones" class="option-label">use metaphones:</label>
				<input type="checkbox" value="metaphones" name="metaphones" id="metaphones" ',$this->_option_metaphones,' onclick="check_state();" /></span>&nbsp;&nbsp;
				<span id="fmps" title="Add more fuzz to the mix, will often more than double your suggestions.">
				<label for="fuzzy" class="option-label">fuzzy match:</label>
				<input type="checkbox" value="fuzzy" name="fuzzy" id="fuzzy" ',$this->_option_fuzzy,' onclick="check_state();" /></span>';
			} else {
				echo '
					',$dummy_mtf,'
					',$dummy_fmps,'';
			}
			echo '
			</div>';
		} else {
			echo '
				<span id="suggest"></span>
				',$dummy_mtf,'
				',$dummy_fmps,'
			</div>';
		}
		echo '
		</div>

<script>
//<![CDATA[
<!--

var spelling_highlight = document.getElementById("spelloptions").style.color;

// init..
check_state();

function dim_all() {
	document.getElementById("sgsp").style.color="',$this->_dim_color,'";
	document.getElementById("suggest").disabled=1;
	dim_metaphones();
}
function dim_metaphones() {
	document.getElementById("mtf").style.color="',$this->_dim_color,'";
	document.getElementById("metaphones").disabled=1;
	dim_fuzzy();
}
function dim_fuzzy() {
	document.getElementById("fmps").style.color="',$this->_dim_color,'";
	document.getElementById("fuzzy").disabled=1;
}
function highlight_suggest() {
	document.getElementById("sgsp").style.color=spelling_highlight;
	document.getElementById("suggest").disabled=0;
}
function highlight_metaphones() {
	document.getElementById("mtf").style.color=spelling_highlight;
	document.getElementById("metaphones").disabled=0;
}
function highlight_fuzzy() {
	document.getElementById("fmps").style.color=spelling_highlight;
	document.getElementById("fuzzy").disabled=0;
}
function highlight_all() {
	highlight_suggest();
	highlight_metaphones();
	highlight_fuzzy();
}

function check_state() {
	highlight_all();
	if (document.getElementById("do-spelling") != null && document.getElementById("do-spelling").checked==0) { dim_all(); }
	if (document.getElementById("suggest").checked==0) { dim_metaphones(); }
	if (document.getElementById("metaphones").checked==0) { dim_fuzzy(); }
}

function getXMLHttp() {
	var xmlHttp
	try { xmlHttp = new XMLHttpRequest(); }
	catch(e)  {
		try  { xmlHttp = new ActiveXObject("Msxml2.XMLHTTP"); }
		catch(e) {
			try { xmlHttp = new ActiveXObject("Microsoft.XMLHTTP"); }
			catch(e) {
				return false;
			}
		}
	}
	return xmlHttp;
}

function AJAXAddToDictionary(Word,List) {
	var xmlHttp = getXMLHttp();
	xmlHttp.onreadystatechange = function()  {
		if (xmlHttp.readyState == 4)  {
			HandleAJAXAddDictResponse(xmlHttp.responseText, Word);
		}
	}
	xmlHttp.open("GET", "'.$_SERVER['SCRIPT_NAME'].'?ajax=true&AddToDict=" + Word + "&Dictionary="+ List, true);
	xmlHttp.send();

}
function HandleAJAXAddDictResponse(Response, Word) {
  document.getElementById("dict-add-div-" + Word).innerHTML = "\<div class=\'spelling-response\'\>" + Response + "\<\/div\>";
}



function AJAXIgnoreWord(Word) {
	var xmlHttp = getXMLHttp();
	xmlHttp.onreadystatechange = function()  {
		if (xmlHttp.readyState == 4)  {
			HandleAJAXIgnoreWord(xmlHttp.responseText, Word);
		}
	}
	xmlHttp.open("GET", "'.$_SERVER['SCRIPT_NAME'].'?ajax=true&IngoreWord=" + Word, true);
	xmlHttp.send();

}
function HandleAJAXIgnoreWord(Response, Word) {
  document.getElementById("dict-add-div-" + Word).innerHTML = "\<div class=\'spelling-response\'\>" + Response + "\<\/div\>";
}


function FindAndReplaceAll(Word, NewWord) {
	var MyTextArea = document.getElementsByTagName("TEXTAREA")[0];
	MyTextArea.value = MyTextArea.value.replace(new RegExp(Word, "gi"), NewWord);
	document.getElementById("dict-add-div-" + Word).innerHTML = "";
	document.getElementById("dict-add-div-" + Word).innerHTML = "\<div class=\'spelling-response\'>Done! All instances of \"" + Word + "\" replaced with \"" + NewWord + "\"\<\/div\>";
}

//-->
//]]>
</script>
<noscript><!-- JavaScript Only Functionality --></noscript>';
	}


	/*
		Suggest likely spellings..		2do.. check it's not being procesed when not required..

		use:

			$spelling->suggest_words( [ bool {return as string}] );

		Set the optional parameter to true to have the output returned as a string.
									*/
	public function suggest_words() {

		if (func_num_args() > 0) { $do_string = func_get_arg(0); } else { $do_string = false; }

		if (empty($this->_misspelled_words) or ($this->_do_suggest == false)) { return; }

		$my_word_list = basename($this->_default_user_dic); // corz.dic // basname is just in case they send full path. set the folder path!!!

		$suggested = '
	<div class="spelling" id="mis-spelling">
		<h4>spelling..</h4>';

		natcasesort($this->_misspelled_words);

		foreach($this->_misspelled_words as $this_booboo) {
			$suggested .= '
		<div class="dict-add-div" id="dict-add-div-'.$this_booboo.'">
			<span class="word-suggestions">dubious word:</span> <strong>'.$this_booboo.'</strong>';

			// ignore a word..
			$suggested .= $this->make_ignore_link($this_booboo);

			// add a word to the user dictionary..
			if ($this->_authorized) {
				$suggested .=  $this->make_add_to_dict_link($this_booboo);
			}

			$suggested .= '
			<br />';
			if (isset($this->_suggestions[$this_booboo])) {
					$suggested .= '
				<span class="word-suggestion">I suggest:</span> ';
				$suggested_words = $this->make_sentence_from_suggest_array($this->_suggestions[$this_booboo], $this_booboo);
				$suggested .= $suggested_words.'<br />';
			} else {
				$suggested .= '
			<span class="word-suggestion">I suggest: <strong>no suggestions, sorree!</strong></span><br />';
			}
			$suggested .=  '
		</div>';
		}
				$suggested .= '
	</div>';

		if ($do_string) { return $suggested; } else { echo $suggested; }
	}




	/*

	get all user word lists and return as one string..
												*/
	private function get_user_words($folder) {

		if (file_exists($folder)) { // also tests for folders
			$files_as_string = '';
			$word_list = array();
			if ($handle = opendir($folder)) {
				while (false !== ($file = readdir($handle))) {
					$fext = substr($file, strrpos($file, '.') + 1);
					if ((ord($file) != 46) and ($fext != 'txt')) { // ignore .htaccess, etc., and .txt files
						$word_lists[] = $file;
					}
				}
				closedir($handle);
			}
			$this->_user_word_lists = $word_lists;
			foreach($word_lists as $word_list) {
				$files_as_string .= "\n".$this->get_file_into_string($folder.$word_list);
			}
			return $files_as_string;
		} else {
			$GLOBALS['errors']['get_user_words'] = 'user word list folder does not exist!"';
			return '';
		}
	}





	/*

		returns a non-volatile file as a string.
													*/
	private function get_file_into_string($file) {

		if (file_exists($file)) {
			return file_get_contents($file);
		} else {
			$GLOBALS['errors']['get_file_into_string'] = 'word list '.$file.' is missing!';
			return;
		}
	}






	/*
		make dictionary links			//2do.. use regex - grab only whole words - '/\b'.$word.'\b/'

		Link to dictionary.com for dubious words. Quicker and easier than
		"suggesting" words. hey! That's what these web services are for!

		string = $this->make_dictionary_links (string {to transform}, array {of misspelled words})
															*/
	public function make_dictionary_links($string, $typos) {
		foreach($typos as $rep_word) {
			$string = str_replace($rep_word, '+++d_l_s+++'.$rep_word.'+++d_l_e+++'.$rep_word.'+++d_l_c+++', $string);
		}
		$string = str_replace('+++d_l_s+++', '<a title="get a presumably authorative definition of this word" href="'.$this->_dictionary_link_provider,  $string);
		$string = str_replace('+++d_l_e+++', '" onclick="window.open(this.href); return false;">',  $string);
		$string = str_replace('+++d_l_c+++', '</a>',  $string);

		return $string;
	}



	/*
		return all the user word lists as a sentence..
													*/

	public function get_user_lists() {
		return $this->make_sentence_from_array($this->_user_word_lists);
	}

	/*
		make an array into sentence..

		Converts an array of values into a sentence with commas between
		the items and a nice full stop at the end.
											  */
	private function make_sentence_from_array($array) {
		if (!is_array($array)) { return false; }
		return implode(', ', $array).'.';
	}




	/*
		Make a sugegstions array into sentence of *active* words..

		Converts an array of values into a sentence with commas between
		the items and a nice full stop at the end.

		The words are active - clicking the word replaces the all occurences of
		the dubious word with the chosen word.
																					*/
	private function make_sentence_from_suggest_array($array, $badword) {

		if (!is_array($array)) { return false; }

		foreach ($array as $sugg_word) {
			//2do.. switch for disabling add-to-dictionary	(or just check if user dic is blank)
			$new_list[] = '<span class="find-replace" id="Find-Replace-'.$sugg_word.
				'" onclick="FindAndReplaceAll(\''.$badword.'\',\''.$sugg_word.'\')" title="click to have this word replace all instances of the dubious word in your text">'.$sugg_word.'</span>';
		}
		return implode(', ', $new_list).'.';
	}




	public function make_list_of_bad_words() {

		foreach ($this->_misspelled_words as $badword) {

			$new_list[] = '
<div class="dict-add-div" id="dict-add-div-'.$badword.'">
	<span class="bad-word">'.$badword.'</span>'.$this->make_ignore_link($badword).$this->make_add_to_dict_link($badword).'
</div>';
		}
		return "\n".implode("\n", $new_list);
	}


	// link creation helper functions for make_list_of_bad_words() and suggest_words()
	private function make_ignore_link($word) {
		return '<a href="?ajax=true&amp;IngoreWord='.$word.'" class="ajax-word-action-link" id="IgnoreWord-Link-'.$word.
				'" onclick="AJAXIgnoreWord(\''.$word.'\');return false;">[ignore]</a>';
	}
	private function make_add_to_dict_link($word) {
		return '<a class="ajax-word-action-link" href="?ajax=true&amp;AddToDict='.$word.'" id="DictAdd-Link-'.$word.
				'" onclick="AJAXAddToDictionary(\''.$word.'\');return false;">[add to dictionary]</a>';
	}



	/*

		Add a word to the user dictionary.

		In the demo, this is triggered by AJAX. This script gets sent something
		like:

			spelling.php?ajax=true&AddToDict=NewWord

		we handle the ajax request, firing the following function(s)..
																	*/

	private function add_to_dictionary($new_word) {

		if (trim($new_word) == '') { return; }

		header('Content-Type: text/plain');
		header('Connection: Close');

		if (!$this->_authorized) {
			echo 'not authorized!';
			return;
		}

		$word_list_location = $this->_my_path.$this->remove_trailing_slash($this->_user_dic_folder).'/'.$this->_default_user_dic;
		$added = false;

		if (!file_exists($word_list_location)) {
			echo 'FAILURE!  adding "',$new_word,'" (',$this->_default_user_dic,' is missing!)';
			return;
		}


		//check for word already existing in list..
		$word_list_array = explode("\n", $this->get_file_into_string($word_list_location));

		if (in_array($new_word, $word_list_array, true)) {
			echo 'FAILURE! adding "',$new_word,'" (already in ',$this->_default_user_dic,'!)';
			return;
		} else {
			$added = $this->append_word_to_dictionary($word_list_location, $new_word);
		}
		if ($added) {
			echo 'SUCCESS! "',$new_word,'" added to ', $this->_default_user_dic;
		} else {
			echo 'FAILURE! Could not write to ',$this->_default_user_dic,'!';
		}
	}


	// remove trailing slash
	private function remove_trailing_slash($path) {
		if (substr($path, -1) == '/') { $path = substr($path, 0, -1); }
		return $path;
	}



	/*
		Ignore some word for the rest of this session..

		This function is usually called with AJAX.

										*/
	public function ignore_word($word) {

		if (trim($word) == '') { return; }
		$word = strtolower($word);

		if (!isset($_SESSION['spell-checker'])) {
			if (!isset($_SESSION['spell_checker']['ignored_words'])) {
				$_SESSION['spell_checker']['ignored_words'] = array();
			}
			$_SESSION['spell_checker']['ignored_words'][] = $word;
			if (in_array($word, $_SESSION['spell_checker']['ignored_words'], true)) {
				echo 'Done! "'.$word.'" will be ignored for the rest of your session.';
			}
		}
	}



	/*
		add a word onto the end of a word list file.

		this function returns true on success, false on failure.
																	*/
	private function append_word_to_dictionary($word_list, $word) {

		$added = false;
		$word = strtolower($word);

		if (!file_exists($word_list)) {
			$GLOBALS['errors']['append_word_to_dictionary'] = "$word_list list does not exist";
			return false;;
		}

		if (is_writable($word_list)) {
			$fp = fopen($word_list, 'ab');
			$lock = flock($fp, LOCK_EX);
			if ($lock) {
				fwrite($fp, "\n$word");
				flock ($fp, LOCK_UN);
				$added = true;
			} else {
				$GLOBALS['errors']['append_word_to_dictionary'] = "couldn't lock $word_list";
				$added = false;
			}
			fclose($fp);
			clearstatcache();
		} else {
			$GLOBALS['errors']['append_word_to_dictionary'] = "can't write to $word_list";
			$added = false;
		}

		return $added;
	}




	// add slashes to a string, or don't..
	private function do_slashes($string) {
		if (get_magic_quotes_gpc()) {
			return trim(stripslashes($string));
		} else {
			return trim($string);
		}
	}



	// a simple output of the total time taken
	//
	function echo_spelltime() {
		echo '
	<span class="spelling-report">spell-checker took '.substr($this->_total_time, 0, 5).' seconds</span>';
	}




	/*
		end main functions
							*/


} // end class::spelling()





/*
	version history


	0.9

		Spell checker will now ignore any .txt files found among the dictionaries.
		.nfo files caused incompatibility issues on certain desktop systems!

		Added option to disable bbcode parsing, if required.


	0.8

		Added a preference for a custom dictionary provider (for the dictionary links).

		Cleaned up a few of the HTML outputs to better fit your CSS, added <noscript> tags, that sort of thing.

		Added a couple of CSS classes, too.

		Improved documentation.

		Some minor internal simplifications.


	0.7.5

		spelling.php is now a class, at last.

		you can now ignore words, this lasts for your browser session


	0.7

		In the list of suggestions, clicking on a word now replaces all instances of the dubious word with the clicked
		word.

		Improved the AJAX for the add-to-dictionary feature. A descriptive message is now posted, REPLACING the
		suggestion section for that word. If there were any errors adding the word to the dictionary, they are posted.



	0.6

		Users can now click an "Add to Dictionary" link, to add a word to their user dictionary.

		In the built-in demo, this is handled with AJAX, which I recommend see the demo for implementation details.

		Currently the authentication is a simpe preference switch, though I would imagine you will want to set this
		switch with whatever authentication system you are using onsite. corzblog uses pajamas for this, of course.


	0.5.3:

		Spell checker will now ignore any .nfo files found among the dictionaries.

		Fixed the missing cols= in the textarea (style overrides this, but
		still)


	0.5-0.5.2:

		For some reason, I didn't keep notes for this version. I was clearly
		doing too much at once!


	0.4:

		improved the JavaScript capabilities of the spelling options form, now it will enable/disable checkboxes, and
		dim/highlight the label text according to the current spell-checking criteria. as ever, the JavaScript was lots
		of fun!

		the checkboxes should act fairly intuitively. they will remember their state, even when disabled. If you switch
		everything on, and then disable the master "spelling" switch, and then enable it again, your previous options
		will remain as before.

		sadly, when a checkbox is disabled, it sends NO variables whatsoever when the form is posted, so the state of
		the checkboxes on a new page is always whatever was sent with the last request. in other words, if you enable
		everything, then disable the master "spelling" switch, then run the spell-check, after the page refreshes, none
		of the checkboxes will be checked.

		I figured this was a fair trade-off for having them do the right thing (ie. dim) when they are no longer active
		in the current spell-check criteria. play with it and you'll see what I mean.

		improved the variable scope arrangements. everything, pretty much, is now inside $spelling()


	0.3:

		improved word suggestion, now we check against metaphones as well as using the levenshtein.

		added ability to enable/disable the various options. created a wee strip with these options in it.

		added "fuzzy" matching, which basically slackens the metaphone criteria.

		added error-checking capabilities. a global errors array now exists for checking.

		fixed a bug where if dictionary.com links contained misspelled words (eg. "ini") it would recurse into itself,
		messing up the text. fixed a few other minor bugs along these lines.

		smartened up the styling. the spelling options and suggestions now come in their own wee div. nice.



	0.2:

		added word suggestion, this works rather well.

		added "user" dictionaries. now you can have a folder and just chuck any old word list in there to have it used
		as a supplimentary word list for the spell-checking.

		created a built-in demo to showcase the spell-checkers capabilities, and demonstrate a working spell-checker
		example to potential webmaster-users.



	0.1:
		basic spell-checking.

		misspelled words get a link to dictionary.com





*/


?>