<?php // ۞// text { encoding:utf-8 ; bom:no ; linebreaks:unix ; tabs:4sp ; }

/*
	corzblog admin/preference tabs..

To add a new preference, simply add a section here, and another inside init.php, to handle the data.

This will probably end up as an ini file.

NOTE: The item arrays are..

	[1st item is special - the name of the pref tab + public/private viewing status]

	'pref tab name' => array( string{title}, string{public/private}),

	[then the items..]

	'pref_var_name' => array(string {item type}, string {clickable label}, string {info + title}, bool{create a small gap after this item - separate groups}),
	'another_pref_var_name' => array(...),
	etc..

	listboxes are slightly different, the  third item is another array, the first value the actual value, the second an array (again!) of available values. See themes_list for an example.
)

*/

// save typing/editing, but makes for BIG pages! ..
$link_info = '<br /><br />You can use &quot;tokens&quot; in any of your link properties. These will be transformed into their real values when the pages are generated, so you can switch things around and they will switch with you. Possible tokens are.. {url}, {path}, {about}, {email}, and {mysite}<br /><br />To add a new link to a group, simply click the &quot;Add New Link&quot; button (below the link group), edit its details and save the configuration. To delete a link, wipe its link text or click the &quot;X&quot; icon next to the link, and save.<br /><br />To revert to your current configuration, simply click the &quot;configure&quot; link from the main sidebar links or refresh this page.<br /><br />Note: You can prepend the link with a &quot;#&quot; symbol (e.g. <strong>#{path}admin.php</strong>), to have the link only display for admins (logged-in). If you have some other pajamas security login onsite (using the same ID), you can # every one of the admin links! Prepend links with a &quot;@&quot; symbol to have them only appear to visitors. Prepend {url} links (<strong>and only {url} links!</strong>) with &quot;!&quot; to force SSL (https).';

$themes_list = implode('</li><li>', $corzblog['themes_list']);

$pt_string = '<br /><br />NOTE: click any title to lock the tab, click again to unlock.<br /><br />This action is remembered, so that when you come back to your prefs it&amp;apos;s still the active tab.';


$corzblog['corzblog_prefs']['user'] = array(

	'user' => array('Change your personal details, addresses, titles and such.'.$pt_string, 'private'),

	'mysite' => array('text', 'site name..', $corzblog['mysite'], 'This is the HUGE title at the top of the page, and loads of other places. You can put anchor tags (links) in here, and corzblog will clean them automatically, where appropriate (e.g. in titles)'),

	'description' => array('text', 'description..', $corzblog['description'], 'This text is displayed under your main site title, and in your newsfeeds. (note: if you want to make anchors, use single-quotes for the properties)', true),

	'blogger' => array('text', 'user name..', $corzblog['blogger'], 'This is what appears in the &quot;posted by&quot; byline. It is also the &quot;creator&quot; in rss/rdf feeds, and other places. Generally, this would be your name.'),

	'mail_addy' => array('text', 'email..',  $corzblog['mail_addy'], 'Your email address, where enquiries about the content should be sent. this is spam-bot &quot;mashed&quot; and used in the rdf/rss feeds and sidebar.', true)

);

$corzblog['corzblog_prefs']['general'] = array(

	'general' => array('General preferences related to your '.$corzblog['blog_is'].', in general.'.$pt_string, 'private'),

	'time_zone' => array('text', 'time zone..', $corzblog['time_zone'], 'Enter your Timezone here.<br /><br />For example, for the United Kingdom, it is &quot;Europe/London&quot; (the default), though you can usually get by with the short code, e.g. &quot;GB&quot;<br /><br />For a full list of the supported time zones, see here..<br /><br />http://www.php.net/manual/en/timezones.php'),

	'time_diff' => array('text', 'time difference..', $corzblog['time_diff'], 'If you run php5 or greater, leave this blank.<br /><br />For php4, this is the difference between your server time and local time (in hours). For example, if you are in the UK, and your server, the US, use 7, or thereabouts.'),

	'feed_time_diff' => array('text', 'RSS time difference..', $corzblog['feed_time_diff'], 'This is used to create a valid (W3DTF formatted) time for the news feeds. Enter a valid time, relative to GMT.<br /><br /> This must take the format &quot;+/-HOURS:MINUTES&quot;, e.g. &quot;+00:00&quot;'),

	'date_format' => array('text', 'date format..', $corzblog['date_format'], 'The date format  for the &quot;posted by&quot; date strings. The default is &quot;D jS F g:i a&quot;, but you might prefer &quot;d.m.y g:i a&quot;. more details.. http://php.net/date', true),

	'about_name' => array('text', '&quot;about&quot; name..', $corzblog['about_name'], 'You can call the about page whatever you like, but remember to rename the file, if you do (the string you set here should be the same as the file name, minus the file extension).'),

	'about_description' => array('text', '&quot;about&quot; description..', $corzblog['about_description'], 'Like your main site description, but just for your &quot;about&quot; page.', true),

	'images_folder' => array('dropdown', 'images folder..', array($corzblog['images_folder'], $corzblog['top_dirs']), 'The folder for images you use in your '.$corzblog['blog_is'].'.<br /><br />If you specify the folder you keep your images in, we can automagically transform their links to and from relative or absolute linking, so, regardless of how you create your link, in regular or permalinked view, they always work! nifty.'),

	'files_folder' => array('dropdown', 'files folder..', array($corzblog['files_folder'], $corzblog['top_dirs']), 'The folder for files; zips, bits and bobs, whatever you like to share from your '.$corzblog['blog_is'].'.<br /><br />If you specify the folder here; we can automagically transform their links to and from relative or absolute linking, so, regardless of how you create your link, in regular or permalinked view, they always work! nifty.'),

	'audio_folder' => array('dropdown', 'audio folder..',  array($corzblog['audio_folder'], $corzblog['top_dirs']), 'The folder for audio files; MP3s, ogg files, whatever you might use in your '.$corzblog['blog_is'].'.<br /><br />If you specify the folder here; we can automagically transform their links to and from relative or absolute linking, so, regardless of how you create your link, in regular or permalinked view, they always work! nifty.', true)
);


$corzblog['corzblog_prefs']['spelling'] = array(

	'spelling' => array('corzblog has a built-in spell-checker, configure it here.'.$pt_string, 'private'),

	'spell_checker' => array('checkbox', 'enable spell-checker..', $corzblog['spell_checker'], 'This is the master switch for the spell checker. If you disable this, the spelling options will not be shown.'),

	'begin_spell_check' => array('checkbox', 'auto-start spell-checker..', $corzblog['begin_spell_check'], 'Check this to have spell-checking enabled right off the bat when editing blogs.<br /><br />Note: if disabled, you can still enable spell-checking as and when needed, but if you want it to start checking from the very first edit, check this.', true),

	'enable_suggestion' => array('checkbox', 'enable suggestion..', $corzblog['enable_suggestion'], 'The corzblog spell-checker can suggest likely words for you. Enable that here.'),

	'enable_metaphones' => array('checkbox', 'enable metaphones..', $corzblog['enable_metaphones'], 'Using &quot;metaphones&quot; enables the spell-checker to suggest words that &quot;sound-like&quot; other words.<br /><br />Note: enabling metaphones also enables fuzzy matching capabilities.', true),

	'word_list' => array('dropdown', 'default word list..', array($config_array['word_list'], $corzblog['word_lists_list']), 'a simple plain text list of words with \n (UNIX) line breaks, inside the &quot;spelling&quot; folder. three word lists are available; &quot;basic.list&quot; (simple but handy), &quot;english.list&quot; (the default, recommended for daily use), and &quot;english_big.list&quot; (a massive list containing every word in existence, well, most of them).<br /><br />Alternatively, you can specify the FULL server path to an alternative word list, if you wish. Blank it to use the default list.'),

	'user_dic_folder' => array('text', 'user word lists folder..', $config_array['user_dic_folder'], 'Any files placed inside this folder (which is inside the &quot;spelling&quot; folder) will be used as word lists for the typo check.<br /><br />This is handy for any scientific / technical / medical / personal word lists you might have.<br /><br />Enter the location relative to the &quot;spelling&quot; folder (the default is &quot;user&quot;), or else enter the FULL server path to your chosen folder.<br /><br />Blank it to use the default folder.'),

	'user_dic' => array('dropdown', 'default user word list..', array($config_array['user_dic'], $corzblog['user_word_lists_list']), 'Your default user &quot;dictionary&quot;.<br /><br />This is the word list you can add words to from the spell-checker interface. It is expected to be inside the user word lists folder.', true),

//	'spelling_highlight' => array('text', 'highlight color..', $corzblog['spelling_highlight'], 'What color to use to highlighting misspelled words? (it looks like a highlighter pen through the word).<br /><br />Enter a standard HTML color value. The default is #FFFF00 (yellow). #f9f063 (bright pink) also works well.', true),

	'dictionary_links' => array('checkbox', 'dictionary links..', $corzblog['dictionary_links'], 'As well as the built-in spell-checker, misspelled words can be transformed into links pointing to the relevant search on dictionary dot com, or a similar provider.<br /><br />This is a useful, lightweight way to get the correct spelling, along with suggestions and definitions. Cheap and effective!<br /><br />Note: it’s okay to leave this enabled at all times, in addition to the built-in spell-checker.'),

	'dictionary_url' => array('text', 'dictionary url..', $corzblog['dictionary_url'], 'By default, corzblog uses dictionary dot com for the dictionary links, but you can choose another provider, here.<br /><br />Please enter the full URL up to and including any query parameter, e.g.<br /><br />&nbsp;&nbsp;<code>http://www.coolspellings.com/search.php?word=</code>', true),

);


$corzblog['corzblog_prefs']['style'] = array(

	'style' => array('Alter the look and feel of your blog.. corzblog themes and schemes..'.$pt_string, 'private'),

	'current_theme' => array('dropdown', 'default theme..', array($corzblog['current_theme'], $corzblog['themes_list']), 'The name of the current theme (and its style sheet, minus the file extension).<br /><br />This defines the LAYOUT of your '.$corzblog['blog_is'].' - you can determine the colors for the various elements separately, with <em>schemes.</em><br /><br /><strong>Your currently available themes:</strong><ul id=themes-list><li>'.$themes_list.'</li></ul>'),

	'current_scheme_name' => array('dropdown', 'color scheme..', array($corzblog['current_scheme_name'], $corzblog['schemes_list']), 'Which set of colors and graphic elements to use for this style. The default is &quot;oranges&quot;.', true),

	'minify_css' => array('checkbox', 'minify css..', $corzblog['minify_css'], 'To reduce download times and speed page load, we can minify the css on-the-fly (as well as gzip compress it, if you have that disabled for some reason). Minification turns the style sheet into a near-unintelligible mess, but it works great!', true),

	'cache_styles' => array('checkbox', 'allow browsers to cache styles..', $corzblog['cache_styles'], 'Normally enabled. If you disable this, the browser is forced to request the style sheet afresh with every request.<br /><br />Unless you are doing lots of development on your site schemes, it&amp;apos;s okay to leave this enabled.<br /><br />We rather cleverly send the name of the scheme along with the style sheet request (as an ?extra=parameter) so if their scheme ever changes (by you changing the default scheme or them changing their preferred scheme) their browser will <em>always</em> grab the styles afresh.<br /><br />For example, if you have four schemes and a visitor tries them all out, at the end of that, they will have four cached style sheets, one for each scheme, and whichever one they decide on, the browser should use its cached copy.<br /><br />But worry not, whichever way you roll out, it works!', true),

	'site_css' => array('text', 'site-wide style sheet..', $corzblog['site_css'], 'If you have a site-wide style sheet that you would like imported before your blog styles, specify its path (from site root) here.<br /><br />You can specify multiple sheets, separating them with commas, e.g.<br /><br /><pre>/inc/css/header.css,/inc/css/footer.css</pre>', true),

	'html5_shiv' => array('text', 'HTML5 shiv (optional)..', $corzblog['html5_shiv'], 'If you plan to support users of old versions of Internet Explorer (IE7/8) you will probably want to include an HTML5 shiv.<br /><br />Enter its path (from site root) here, e.g..<br /><br /><code>/inc/js/html5.js</code>', true),

	'sidebar_first' => array('checkbox', 'sidebar first..', $corzblog['sidebar_first'], 'You may prefer to have your sidebar rendered first (before your blog entries) in the HTML source, for whatever reason, perhaps a customized style sheet, or SEO purpose. You can enable this here. Note: depending on your style sheet, this may or may not affect how your blog looks.', false)
);


$corzblog['corzblog_prefs']['archives'] = array(

	'archives' => array('Preferences related to your archives, and links to archives, etc..'.$pt_string, 'private'),

	'arc_frequency' => array('dropdown', 'archiving frequency..', array($corzblog['arc_frequency'], array('monthly', 'quarterly')), 'How often to archive '.$corzblog['blog_is'].'s?.. Choose from &quot;monthly&quot; (the default), or &quot;quarterly&quot;.<br /><br />IMPORTANTLY, this is used to create permalinks for the *current* '.$corzblog['blog_is'].'. You see, in X days it will be archived to a permanent archive, and this setting allows us to determine the name of that archive in advance. aka. see into the future..<br /><br />But don’t worry about it; after the '.$corzblog['blog_is'].' has been permanently archived, the permalink will always be correct.'),

	'arc_dir' => array('dropdown', 'archive directory..', array($corzblog['arc_dir'], $corzblog['top_dirs']), 'Where your '.$corzblog['blog_is'].' archives (and temporary backups) are stored. NOTE: this folder needs to be writeable by the server process (if php is running as a CGI, you should be good to go, if it is running as a module, either do, in a shell; chmod 777 /path/to/arc, or else use your ftp client to set the folder’s permissions to ALL).<br /><br />See the instructions for more details. On many servers, if you unzipped in place, you should be good to go right off the bat. '),
	/*
	'arc_description' => array('text', 'archive description..', $corzblog['arc_description'], 'If someone is reading an archive, we can display a cute message for them.', true),
	*/
	'permalinks' => array('checkbox', 'enable permalinks..', $corzblog['permalinks'], 'A permalink is a permanent link to a '.$corzblog['blog_is'].' entry. Folk can bookmark it, search engines can pin-point it. This is good.'),

	'no_blog_message' => array('text', 'no blog message..', $corzblog['no_blog_message'], 'This is appended to the message one gets on arriving at the blog when there is no current blog (the &quot;go check out the archives&quot; message).<br /><br />This is tagged directly on to the end of the generated message (which changes depending on your prefs) so if you want line-breaks, add line-breaks, or whatever.<br /><br />You can use any valid HTML in here. &amp;lt;h3&amp;gt; is recommended.<br /><br />Note: Like the links, you should use &apos; rather than &quot; for your properties.'),

	'rewrite_links' => array('checkbox', 'flat (rewritten) links..', $corzblog['rewrite_links'], 'Transform the permalinks (and archive/about links) from dynamic?links=true to nice /flat/links/.<br /><br />It’s SEO-friendly, and human friendly. We love em!<br /><br />NOTE: you need to have mod_rewrite enabled on your server, and the correct rewrite rule in place for this to work.<br /><br />See the instructions (and inside the supplied .htaccess file) for more details.')

);


$corzblog['corzblog_prefs']['sidebar'] = array(

	'sidebar' => array('Sidebar preferences. The sidebar is called the sidebar, but depending on your style sheet it could be the top bar, or bottom bar, or whatever. Anyway, it is the place where the links, news feeds and various menus appear.'.$pt_string, 'private'),

	'main_menu_name' => array('text', 'main menu name..', $corzblog['main_menu_name'], 'This is the top menu in the sidebar. The default is &quot;blog..&quot;'),

	'links_menu_name' => array('text', 'links menu name..', $corzblog['links_menu_name'], 'The name for your links menu.'),

	'blogs_menu_name' => array('text', ''.$corzblog['blog_is'].'s menu name..', $corzblog['blogs_menu_name'], 'YOU might want to call it &quot;blobs&quot;, or something.'),

	'feeds_menu_name' => array('text', 'feeds menu name..', $corzblog['feeds_menu_name'], 'The name for your feeds menu. Only shown if the next item (show rss feeds..) is enabled. '),

	'arcs_menu_name' => array('text', 'archives menu name..', $corzblog['arcs_menu_name'], 'The name for your archives menu (keep it short!).', true),

	'truncate' => array('text', 'truncate menu titles..', $corzblog['truncate'], 'You can set how many characters the &quot;'.$corzblog['blog_is'].'s&quot; menu truncates its titles to. The default is 18 (characters).', true),

	'show_feeds' => array('checkbox', 'show rss feeds..', $corzblog['show_feeds'], 'Readers can always get to your rss/rdf feeds via the regular rss links in the header, but it is good to display feed links in the sidebar, too. These have cool images which you can click to have your feeds validated.', true),

	'main_links' => array('group-top-links', 'main links..', $corzblog['main_links'], 'These are the main links in your sidebar. The first few are best left as is, but hey, it’s your blog.'.$link_info),

	'side_links' => array('group-side-links', 'side links..', $corzblog['side_links'], 'These are the second set of links in your sidebar. These are generally used to promote things you like.'.$link_info)
);


$corzblog['corzblog_prefs']['advanced'] = array(

	'advanced' => array('Advanced Preferences. You shouldn’t ever need to touch these, but hey!'.$pt_string, 'private'),

	'blog_file' => array('text', ''.$corzblog['blog_is'].' file name..', $corzblog['blog_file'], 'Name of the '.$corzblog['blog_is'].' file. NOTE: changing this will change the global blog file extension to whatever you set here.<br /><br />IF you change this (and it’s not advised) this new name and extension will be used ALL OVER, for titles, links, and even the files themselves, so if the web server process doesn’t have write access to your '.$corzblog['blog_is'].' files/directories, remember to manually change the file extension of your blog files to your new name', true),

	'ga_code' => array('text', 'google analytics code..', $corzblog['ga_code'], 'If you have a Google Analytics account (recommended) you can enter your ID here. corzblog will automatically add the Google Analytics JavaScript to your pages', true),

	'custom_header' => array('text', 'custom site header..', $corzblog['custom_header'], 'You can have corzblog insert your site header for you. This is inserted directly after the opening &amp;lt;body&amp;gt; tag.<br /><br />Enter the path to your own custom header file (from site root), e.g..<br /><br /><code>/inc/header.php</code>', true),

	'custom_footer' => array('text', 'custom site footer..', $corzblog['custom_footer'], 'You can have corzblog insert your site footer for you. This is inserted directly before the closing &amp;lt;body&amp;gt; tag.<br /><br />Enter the path to your own custom footer file (from site root), e.g..<br /><br /><code>/inc/footer.php</code>', true),

	'custom_metadata' => array('text', 'custom site metadata..', $corzblog['custom_metadata'], 'You can have corzblog insert your site metadata for you. This is inserted inside the &amp;lt;head&amp;gt; tag.<br /><br />Enter the path to your own custom metadata file (from site root), e.g..<br /><br /><code>/inc/metadata.php</code>', true),

	'show_valid_links' => array('checkbox', 'show validation links..', $corzblog['show_valid_links'], 'corzblog can display validation links where users can click to check your blog is standards compliant for HTML and CSS. These image links appear in the footer.', true),

	'show_page_timer' => array('checkbox', 'show page timer..', $corzblog['show_page_timer'], 'corzblog can display the time taken to generate the page. This is displayed in the footer section.<br /><br />As well as being fairly groovy, this can help with debugging and such.', true),

	'divert_spammers' => array('checkbox', 'divert spammers..', $corzblog['divert_spammers'], 'Entities looking to promote their blog may get hold of a link to your &quot;add.php&quot;, and start visiting it directly.<br /><br />corzblog can post a nice message for these visitors, redirecting them to your blog front page.<br /><br />This &quot;protection&quot; also covers admin.php, choose.php and edit.php.', true),

	'use_pajamas' => array('checkbox', 'pajamas authentication..', $corzblog['use_pajamas'], 'Use Pajamas Authentication? YES! Pajamas is cool. It uses JavaScript to hash your password BEFORE you send it over the wire. Think about it.<br /><br />No longer will internet cafe browsers store your login details! With pajamas, it’s okay to use short, easy to remember passwords, even over plain HTTP.'),

	'password' => array('password', 'change password..', '', 'This is your password for editing and adding '.$corzblog['blog_is'].'s, altering preferences and what-not. You can change that password here.<br /><br />NOTE: if you change this, you will need to login again with your new password.<br /><br />NOTE: password changes are sent in plain text over the wire. Please use SSL (https://) to alter this, or edit the new password into your ini file, manually.<br /><br /><br />Alternatively, paste in the FULL SERVER PATH of a pre-defined password file..<br /><br />It should be a simple text file containing only this password. This file should reside in a safe directory, for possible site-wide pajamas authentication.<br /><br />Note: You can click the label to show/hide the password.'),

	'pajamas_id' => array('text', 'pajamas ID..', $corzblog['pajamas_id'], 'If you have multiple pajamas logins on your site, you may or may not want to set this. If you only have one pajamas login (corzblog) you can ignore this setting.<br /><br />Basically, if all the logins use the same ID, you can have a site-wide pajamas login, which is handy. Or else you can give them each different IDs and keep them separate. Or somewhere inbetween.<br /><br />If you are using a site-wide login, you will probably also want to use the same password file and, of course, <em>the same password.</em><br /><br />This defaults to the hostname of your website.'),

	'auth_timeout' => array('text', 'login time-out..', $corzblog['auth_timeout'], 'How long until your pajamas authorisation session times out? (in minutes) The default is 120 (two hours).', true),

	'autosave_info' => array('checkbox', 'autosave info panel x,y,w,h..', $corzblog['autosave_info'], 'Automatically save the current size and position of your information panel as the new default.<br /><br />This happens whenever you save your preferences.<br /><br />If you uncheck this, and leave the sizes input blank (the default), the size and position will be remembered for the entire session. Think of it as temporary autosave. Checking this preference (and saving your preferences) makes the current size and position the default.'),

	'info_sizes' => array('text', 'info panel (x,y,w,h)..', $corzblog['info_sizes'], 'The size &amp; position of the information panel can be hard-wired here. This overrides any dynamic positioning.<br /><br />The format goes, &quot;x,y,width,height&quot;, e.g.. 8,90,220,450<br /><br />The quickest way to set a fixed position permenently is to enable auto-save, set your panel, then save your prefs. Then disable auto-save - there is your current size and position info already filled in! Now save again to make it permanent.<br /><br />Delete the value (and save) to return to dynamic positioning.<br /><br />Note: the X &amp; Y positions are fixed relative to the viewport (i.e. pinned to the top-left of the browser viewing area).<br /><br />If you want the info panel pinned back to the bottom-right corner of the viewport (or wherever your CSS puts it), enter &quot;reset&quot; (no quotes) into the dimensions input. You also can set only X and Y to &quot;none&quot;.<br /><br />Finally, you can disable the info panel altogether by entering &quot;none&quot;.', true)

);

?>