<?php // ۞// text { encoding:utf-8 ; bom:no ; linebreaks:unix ; tabs:4sp ; }
if  (function_exists('mhash'))             /*   duh!  */         { return; }
if  (realpath ($_SERVER['SCRIPT_FILENAME'])    ==    realpath (__FILE__))  {
        /*  deny direct access  */      die ( 'to err is human, human!' ); }
/*
	homebrew mhash

	computes the hash of a key (salt) and some data.
	for servers without the mhash libraries available.

	gleaned from various sections of the php manual, etc..

		mhash: http://mhash.sourceforge.net/
		FC2104: http://www.ietf.org/rfc/rfc2104.txt
		mina86 at projektcode dot org


	a part fo pajamas..

		http://corz.org/server/security/pajamas.php

	For the most part, this operates as a drop-in replacement for mhash(), so
	if you don't have the mhash libraries available you can, at least with
	the md5 and sha1 hashing algorithms, use this in exactly the same way.

	Feel free to lift for your own projects.

	;o) Cor

	© corz.org 2006->today ~ cor @ corz.org ;o)


	usage:

		string{binary} my_mhash ( string{algorithm}, string{data}, string{key}  [, string{format}] )

			eg.	$tring = my_mhash('sha1', 'MyPassword', 'mySalt==', 'hex');

		can also be used as per regular mhash..

			bin2hex(my_mhash(MHASH_MD5, $data, $key)) === bin2hex(mhash(MHASH_MD5, $data, $key))

	{algorithm}
		can be one of either 'sha1' or 'md5' (you can also supply the php constants,
		MHASH_SHA1, and MHASH_MD5, respectively, so it becomes a drop-in replacement
		for the php function, sorta). If you send some other string, it may or may
		not work, depending on your server's capabilities.

		Any php can do 'md5', you need >=4.3 to do 'sha1', or else use functions/sha1.php


	{format}
		optionally, you can specify a return format, either 'hex' for hexidecimal output,
		or 'b64' for base64 encoded output. hex is probably the most useful.


*/

function my_mhash() {

switch(func_get_arg(0)) {
	case MHASH_SHA1:	$algo = 'sha1'; break;
	case MHASH_MD5:		$algo = 'md5'; break;
	default:			$algo = func_get_arg(0);
}
$data = func_get_arg(1);
if (func_num_args() > 2) { $key = func_get_arg(2);		} else { $key = ''; }
if (func_num_args() > 3) { $format = func_get_arg(3);	} else { $format = ''; }

	// simple key-less format, or else key was empty ('').
	if (empty($key)) { return pack('H*', $algo($data)); } // mhash(MHASH_$algo, $data)  [simple digest]

	if (strlen($key) > 64) {
		$key = pack('H*', $algo($key));
	}
	$key = str_pad($key, 64, chr(0x00));
	$ipad = str_repeat(chr(0x36), 64);
	$opad = str_repeat(chr(0x5c), 64);
	$hash = $algo(($key ^ $opad).pack('H*', $algo(($key ^ $ipad).$data))); // (RFC 2104) HMAC

	switch($format) {
		case 'hex': // [hexidecimal]
			return $hash;
			break;
		case 'b64':	// [base64 encoded]
			return base64_encode(pack('H*', $hash)); // base64 encoded version.
			break;
		default: // mhash	[binary]
			return pack('H*', $hash); // essentially, mhash(MHASH_$algo, $data, $key);
	}
}

?>