<?php // ۞// text { encoding:utf-8 ; bom:no ; linebreaks:unix ; tabs:4sp ; }
/*

	add.php		v3.3.1

	this script is used to add a new blog

	a part of corzblog.. http://corz.org/blog/

	;o) Cor

	(c) copyright 2003->today -> cor @ corz.org

	2do..  combine with edit.php

*/

// begin..
require 'init.php';

// cbparser preference overrides..
if ($spam_protection) { $cbparser->_prevent_spam = true; }

// page header..
doc_type();

// init..
$blog_page = $corzblog['blog_is'];
$state = 'preview';
$first_visit = true;
$title_add = ' [begin]';
$corzblog['new_blog'] = $corzblog['blog_file'];
$blog_title = $form_textarea = $jump_add = '';
$new_text = $post_track = '';

if (isset($_POST['publish'])) {
	$state = 'blogging';
	$title_add = ' [publishing!]';
}

if (isset($_POST['preview']) or isset($_POST['publish'])
	or !empty($_POST['blogform-text']) or !empty($_POST['blogtitle'])) { // gotta be really sure!
	$first_visit = false;
	$title_add = ' [preview]';
}

// adding to the "about" page?
if (isset($_POST[$corzblog['about_name']]) or isset($_GET[$corzblog['about_name']])) {

	$corzblog['new_blog'] = $corzblog['about_name'].$corzblog['blog_ext'];
	if ($corzblog['rewrite_links']) {
		$jump_add = $corzblog['about_name'].'-'.$corzblog['blog_is'];
	} else {
		$jump_add = '?archive='.$corzblog['about_name'];
	}
	$blog_page = ' "'.$corzblog['about_name'].'" '.$corzblog['blog_is'];
	$post_track = $corzblog['about_name'];
	$title_add .= ' new &quot;about&quot; blog..';
} else {
	$title_add .= ' new blog..';

}


echo '
<title>add a new ',strip_tags($blog_page),' to ',$corzblog['mysite_clean'],'</title>';
output_style_links();
echo '
<script src="inc/js/func.js"></script><noscript><!-- JavaScript Only Functions --></noscript>
</head>
<body>';

// custom header..
if ($corzblog['custom_header']) { include $corzblog['custom_header']; }

echo '
<div id="blog-container">';

echo blog_header('add to '.$corzblog['mysite'].'..', $title_add);

// sidebar..
if ($corzblog['sidebar_first']) { echo sidebar(); }

echo '
	<div id="blogzcol">';


// let's parse..
if (!empty($_POST['blogtitle'])) {
	$blog_title = do_slashes($_POST['blogtitle']);
}

$id_title = $cbparser->make_valid_id($blog_title);

if (!empty($_POST['blogform-text'])) {
	$new_text = $cbparser->bb2html($_POST['blogform-text'], $id_title);
	if (!empty($cbparser->_text)) {
		$form_textarea = $cbparser->_text;
	}
}


/*
	post a blog..	*/

if ($state == 'blogging') {

	switch (true) { // you know it makes sense!

		// no title..
		case (empty($_POST['blogtitle'])):
			echo do_message('you left the title field blank!', 'you will need to give your blog a name.
		<div class="clear-small"></div>');
			$state = 'preview';
			break;

		// blank blog..
		case (empty($_POST['blogform-text'])):
			echo do_message('your blog is blank!', 'you will need to type something!
		<div class="clear-small"></div>');
			$state = 'preview';
			break;

		// imbalanced tags..
		case ($cbparser->_state != 0):
			echo $cbparser->_warning_message; // "there was no text!"
			echo do_message($cbparser->_warning_message, '<div class="clear-small"></div>');
			$state = 'preview';
			break;

		// you are not my blogger!
		case (!$corzblog['is_authorized']):
			echo do_message('You are not authorised to blog!', '<div class="clear-small"></div>');
			$state = 'preview';
			break;


		// w00h00.. SUCCESS!
		case (($corzblog['is_authorized']) and ($state == 'blogging')):
			do_backup($corzblog['new_blog']);

			$entry = create_blog_entry($blog_title, $new_text, 'posted by '.$corzblog['blogger'].' @ '.$date);
			add_blog($corzblog['new_blog'], "\n\n\n\n".$entry.'<!--*end*-->');

			if (!empty($GLOBALS['errors']['add_blog'])) { // automatically resets to preview state if add_blog() fails
				echo do_message($GLOBALS['errors']['add_blog'], '<div class="clear-small"></div>');
				break;
			}

			echo do_cbtimer();
			$jump_link = make_jump_link('now jumping to new '.$corzblog['blog_is'].'..', 2,
				$corzblog['blogzpath'].$jump_add, true, 'go to '.$corzblog['blog_is']);
			echo do_message($corzblog['blog_is'].' entry successful!', $jump_link);
			break;

		default:
			$state = 'preview';
	}
}
/*
	preview a blog..
						 */
if ($corzblog['is_authorized'] and $state == 'preview' and !$first_visit) {

	// check the spelling..
	if ($corzblog['spell_checker']) {
		$spelling->_parse_bbcode = false;
		// we work with the new string because it has been XSS filtered
		// then simply disable bbcode parsing temporarily so example bbcode doesn't initiate the parser /twice/ (_text would become entities!)
		$new_text = $spelling->check_spelling($new_text);
	}

	// display a preview.. (we don't use cbparser's built-in preview function here)
	echo create_blog_entry($blog_title, $new_text, 'posted by '.$corzblog['blogger'].' @ '.$date);

	// display spelling suggestions..
	if ($corzblog['spell_checker']) {
		$spelling->suggest_words();
		if (!$first_visit) {
			$spelling->echo_spelltime();
		}
	}
}


if ($state != 'blogging') {
	$cbparser->do_bb_form($form_textarea, '', '', true, $blog_title, true, $post_track, 'true', 'blogform', true, true, false);
}

echo '
</div>';

if (!$corzblog['sidebar_first']) { echo sidebar(); }
echo '
<div class="clear-small"></div>
<div class="clear"></div>';

if (($state != 'preview') and ($state != 'first edit')) { include 'inc/footer.php'; }

echo '
</div>
</body>
</html>';



//if (!empty($GLOBALS['do_debug'])) {//:debug:
	debug('$GLOBALS: '."\t".print_r($GLOBALS, true)."\nCOMPLETED OUTPUT FOR add.php\n");//:debug:
	debug_out();//:debug:
//	debug('out');
//}//:debug:


?>