<?php // ۞// text { encoding:utf-8 ; bom:no ; linebreaks:unix ; tabs:4sp ; }
require 'init.php';
header("content-type: application/rss+xml");

// if referred by us, set hammer-examption..
if (isset($_SERVER['HTTP_REFERER']) and stristr($_SERVER['HTTP_REFERER'], $corzblog['host'])) {
	$GLOBALS['hammer_exempt'] = true;
}

// log the hit..
require_once $_SERVER['DOCUMENT_ROOT'].'/inc/init.php'; // also does other stuff.

/*
	outputs an xml rdf (RSS 1.0 spec) feed for corzblog
	(would be easy enough to adapt for other purposes)
	© 2004 -> cor at corz.org

	this file allows you to "syndicate" your blogs, so anyone with a
	half-decent news aggregator can grab your "headlines", live.
	pretty cool.

	if you don't have a news aggregator, get one, it could quite
	literally change your life, at least your online life. You can
	look at this page in a web browser, but that's no fun.

	you can edit these elements directly, over-riding init.php,
	except generator admin tags, of course.
*/

echo '<?xml version="1.0" encoding="UTF-8"?>',"\n\n";
echo '<rdf:RDF',"\n";
echo '	xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"',"\n";
echo '	xmlns="http://purl.org/rss/1.0/"',"\n";
echo '	xmlns:dc="http://purl.org/dc/elements/1.1/"',"\n";
echo '	xmlns:sy="http://purl.org/rss/1.0/modules/syndication/"',"\n";
echo '	xmlns:admin="http://webns.net/mvcb/">',"\n\n";

echo '<channel rdf:about="',$corzblog['blog_url'],'">',"\n";
echo '	<title>',$corzblog['mysite_clean'],'</title>',"\n";
echo '	<link>',$corzblog['blog_url'],'</link>',"\n";
echo '	<description>',strip_tags($corzblog['description']),' .. powered by corzblog</description>',"\n\n";

echo '	<dc:language>en-gb</dc:language>',"\n";
echo '	<dc:coverage>worldwide</dc:coverage>',"\n";
echo '	<dc:rights>content (c) ',$corzblog['host'],' - ',date("Y"),
		  ' .. corzblog powered syndication (c) http://corz.org/ 2003 - ',date("Y"),'</dc:rights>',"\n";
echo '	<dc:date>',$today,'</dc:date>',"\n"; // must be in correct (W3DTF) format
echo '	<dc:publisher>',$corzblog['host'],'</dc:publisher>',"\n";
echo '	<dc:creator>',$corzblog['blogger'],'(',mashed_mail($corzblog['mail_addy']),')</dc:creator>',"\n";
echo '	<dc:subject>',$corzblog['mysite_clean'],'</dc:subject>',"\n";
echo '	<sy:updatePeriod>daily</sy:updatePeriod>',"\n";
echo '	<sy:updateFrequency>2</sy:updateFrequency>',"\n\n"; // update twice-daily
		  // I would consider removal of the next two lines an act of violence..
echo '	<admin:generatorAgent rdf:resource="http://corz.org/engine?section=php&amp;download=corzblog.zip" />',"\n";
echo '	<admin:errorReportsTo rdf:resource="mailto:corzblog@corz.org?subject=corzblog-rdf-v',$corzblog['version'],'"/>',"\n\n";
echo '	<image rdf:resource="',$corzblog['blog_url'],'inc/img/corzblog.png" />',"\n\n";

echo '	<items>',"\n";
echo '		<rdf:Seq>',"\n"; //the tabs are optional, but make the xml output more readable


// now the science bit..
$blogzfile = file_get_contents($corzblog['blog_file']);
$line = explode('<!--*end*-->', $blogzfile);
$blogcount = count($line);

// first the headlines
for ($i=0 ; $i < $blogcount ; $i++ ) {
	$z = $i + 1;
	if ($z == $blogcount) {
		break;
	} else {
		$blog = $line[$i];
		$mark = explode('<!--*g*-->', $blog);
		$blog_title = do_valid_id($mark[1]);
		echo '		<rdf:li rdf:resource="',$corzblog['blog_url'],'index.php#',$blog_title,'" />',"\n";
	}
}
echo '		</rdf:Seq>',"\n";
echo '	</items>',"\n\n";
echo '</channel>',"\n\n";

echo '<image rdf:about="',$corzblog['blog_url'],'inc/corzblog.png">',"\n";
echo '	<title>',$corzblog['mysite_clean'],'</title>',"\n";
echo '	<link>http://',$corzblog['host'],'/</link>',"\n";
echo '	<url>',$corzblog['blog_url'],'inc/img/corzblog.png</url>',"\n";
echo '</image>',"\n\n";

for ($i=0 ; $i < $blogcount ; $i++ ) {
	$z = $i + 1;
	if ($z == $blogcount) {
		break;
	} else {
		$blog = $line[$i];
		$mark = explode('<!--*g*-->', $blog);

		// URL encoded verion for valid(atable) links
		$enctitle = rawurlencode(do_valid_id(trim(strip_tags($mark[1]))));
		//$enctitle =  rawurlencode(strip_tags($mark[1]));
		$blog_title = trim(strip_tags($mark[1]));

		/*	I like this better than the rss feed's fancy string splitting
			grab the first two paragraphs for the news preview	*/
		$tp = explode('<br />', $mark[2]);
		$entriez = htmlspecialchars(strip_tags($tp[0])).
			htmlspecialchars(strip_tags($tp[1])) .
				htmlspecialchars(strip_tags($tp[2])); // what a pain!

		echo '<item rdf:about="',$corzblog['blog_url'],'index.php#',$enctitle,"\">\n";
		echo '	<title>',$blog_title,"</title>\n";
		echo '	<link>',$corzblog['blog_url'],'index.php#',$enctitle,'</link>',"\n";
		echo '	<description>',$entriez,"</description>\n";
		echo "</item>\n";
	}
}
echo "</rdf:RDF>\n";
?>