<?php	/* --- ۞---> text { encoding:utf-8;bom:no;linebreaks:unix;tabs:4sp; } */
											 $auto_hotlink['version'] = '0.5';


/*

	Auto-Hotlink									[requires php >= v4.2 + GD]

	This script is designed to function as a hot-link image generator.

	The image can be generated from scratch, or imported. Either way, you can
	also lay text onto the image, even get clever and lay dynamic text on it, if
	that's your bag. A counter would be easily doable. The idea is, you can
	overlay some promotional message onto the image.

	Finally, Auto-HotLink logs the offending hit to a file.

	Auto-Hotlink can generate a png or jpeg image. If you import a transparent
	png, it will be output that way, too. The image part is all very basic, no
	point getting too fancy, just to tell someone to bugger off, politely.

	To use:

		In .htaccess, use mod_rewrite to rewrite image requests to *this* script..

			# hot-linking..
			RewriteCond %{HTTP_REFERER} !^$
			RewriteCond %{HTTP_REFERER} !^http(s)?://(www\.)?mydomain\. [nc]
			RewriteRule ^(.*)\.(gif|jpe?g|png)$ http://%{HTTP_HOST}/path/to/hotlink.php?url=$1.$2 [R,NC,L]

		.. which will then catch the hot-linking requests and spit out your
		hotlink image. The "?url=$1.$2" part is optional, and enables us to log
		exactly what resource they were trying to snatch.

		NOTE:	On some servers, you will need to specify the host, so use
				"mydomain.com" instead of the %{HTTP_HOST}, above.


	For more info on .htaccess + mod_rewrite, see here:

			http://corz.org/server/tricks/htaccess2.php

	Don't forget to set your preferences below.

	Have fun!

	;o) Cor

	(c) 2005->tomorrow! ~ cor + corz.org ;o)

	Please view the license for this free software, here:

		http://corz.org/free-scripts-licence.nfo

*/


/*
prefs..	*/

// site prefs in here..


/*
	Output Image Type

	[default: $auto_hotlink['img_type'] = 'png';]

	Choose from "png" and "jpg"
								*/
$auto_hotlink['img_type'] = 'png';

//
// If you mess up the preference, or don't specify, the type defaults to jpg.


/*
	Import Image..

	[default: $auto_hotlink['import_img'] = 'hotlink.png';]

	Leave this blank to generate an image, or else insert the FULL path to the image you would like
	to use. If the image is in the same folder as this script, you can use the file name by itself.
																*/
$auto_hotlink['import_img'] = '';

/*
	NOTE: You can import a png, and output a jpeg, and vica-versa.
																	*/

/*
	Use Original Image

	[default: $auto_hotlink['use_original'] = false;]

	By request, you can also display the original image they requested, but with your hotlinking
	text overlayed on top.
																	*/
$auto_hotlink['use_original'] = false;

/*
	Output Image Dimensions.

	[default: $auto_hotlink['img_width'] = 280;]
	[default: $auto_hotlink['img_height'] = 32;]

	If not using an imported (or original) image, specify the size of the image to generate from scratch..
																		*/
$auto_hotlink['img_width'] = 280;
$auto_hotlink['img_height'] = 32;


/*
	Background color..

	[default: $auto_hotlink['bg_color'] = '#FF0000';]

	Only for generated images. Use standard RGB value, with or without the "#".
																			*/
$auto_hotlink['bg_color'] = '#FF0000';



//tmp
$trans_color = false;


/*
	Text Overlay

	[default: $auto_hotlink['hotlink_text'] = 'we love '.$_SERVER['HTTP_HOST'].'!';]

	Insert your own text here. I like to use the domain name, as an advert to go on the pages of
	those who would hot-link to the org.

	If you don't want to overlay any text, leave this blank (or comment out)

	examples..

	$auto_hotlink['hotlink_text'] = $_SERVER['HTTP_HOST']; // or maybe..
	$auto_hotlink['hotlink_text'] = "hot-linked from ".$_SERVER['HTTP_HOST'];
	$auto_hotlink['hotlink_text'] = $_SERVER['HTTP_HOST']. " lover!";
																			*/
$auto_hotlink['hotlink_text'] = 'we love '.$_SERVER['HTTP_HOST'].'!';
/*
	This text could be tailored to the site (referrer), user's IP, such as corz.org hot-linker from
	220.2..., or whatever. It could be a simple counter, which is be easy to do in php, or anything
	you like. You can also leave it blank, and send only the image.

	For small to medium sized abusers, a nice advert for your site seems like good value for the
	bandwidth taken. I have one advert currently seen my 1000+ visitors a day! Some band's myspace
	page .:roll:. For serious abusers, see below.
*/


/*
	Text Color

	[default: $auto_hotlink['text_color'] = '#ffffff';]

	RGB, as bg_color, above.
										*/
$auto_hotlink['text_color'] = '#ffffff';

/*
	Text Size

	[default: $auto_hotlink['text_size'] = 5;]

	From 1 - 5
								*/
$auto_hotlink['text_size'] = 5;
//
// I might add truetypes, later.


/*
	Text Align

	[default: $auto_hotlink['align'] = 'center';]

	Horizontal align - choose from 'center', 'right', and 'left'..
																	*/
$auto_hotlink['align'] = 'center';


/*
	Text Border

	[default: $auto_hotlink['txt_border'] = 5;]

	Set the text border (edge space, in pixels)..
	Text won't go any closer than *this* to the edge..
	(unless you have way too much text for the size of the image!)
																	*/
$auto_hotlink['txt_border'] = 5;


/*
	Text Vertical Placement

	[default: $auto_hotlink['text_y'] = 5;]

	Set the vertical placement of the text (in pixels)..
														*/
$auto_hotlink['text_y'] = 5;


/*
	Image Quality

	[default: $auto_hotlink['compression_level'] = 9;]

	png:	Compression level: from 0 (no compression) to 9 (max compression).
			(9 is best)

	jpg:	Quality level: from 10 (dire) to 100 (near lossless).
			80 is good, but 50 uses less bandwidth.
			Large text is still readable at 15.
												*/
$auto_hotlink['compression_level'] = 9;


/*
	Log File..

	[default: $auto_hotlink['log_file'] = $_SERVER['DOCUMENT_ROOT'].'/inc/log/.ht_hotlinks';]

	Unless you are logging to the same folder, use the FULL path, including
	document root..
																			*/
$auto_hotlink['log_file'] = $_SERVER['DOCUMENT_ROOT'].'/inc/log/.ht_hotlinks';



/*
	Evil Domains

	Instead of the usual cute image, we'll send these f*ck3rz something else..
	Separate evil domains with a comma.

	Then it's basically the same prefs again, but for an alternative image..
*/
$auto_hotlink['evil_domains'] = 'repost-agent.blogspot,remote.namusae.com,nutest.org';
$auto_hotlink['evil_type'] = 'jpg';
$auto_hotlink['evil_image'] = 'evil.jpg';
$auto_hotlink['evil_width'] = 314;
$auto_hotlink['evil_height'] = 236;
$auto_hotlink['evil_bg_color'] = 'ffffff';
$auto_hotlink['evil_text'] = 'some *****  stole this article from corz.org!';
$auto_hotlink['evil_text_color'] = '#ffffff';
$auto_hotlink['evil_text_size'] = 2;
$auto_hotlink['evil_align'] = 'center';
$auto_hotlink['evil_txt_border'] = 1;
$auto_hotlink['evil_y'] = 222;
$auto_hotlink['evil_compression_level'] = 50;

/*
	Of course, what you use here, is up to you. But note, most dirty web masters, are male, and
	usually at least slightly homophobic. I find an image of homosexual fellatio, perhaps with the
	text, "some cocksucker stole this from mydomain.com!", works well. Their guests will usually
	complain pretty quickly, jobe done. ;o)

	The usual rules about trying to produce the smallest possible image, don't apply here; we're
	trying to send a message. BIGGER may be better!
*/


/*
end prefs. */


if (!empty($GLOBALS['do_debug'])) { debug("\n".'$auto_hotlink:: '."\t".print_r($auto_hotlink, true)."\n\n"); }//:debug:

/*
	okay, let's go..
						*/

$auto_hotlink['url'] = '';
$auto_hotlink['referrer'] = '';
$auto_hotlink['ref_domain'] = '';


// Capture any GET Variables..
if (!empty($_GET['url'])) { $auto_hotlink['url'] = $_GET['url']; }


// We are using the original requested image..
if ($auto_hotlink['use_original'] == true) {
	$auto_hotlink['import_img'] = $_SERVER['REQUEST_URI'];
}


/*
	Capture "Referer" [sic] information..

	mod_rewrite should have already established that it is a hot-link.
	This is a double-check. We need to capture the referrer, anyway.
	Also, it means keeping a demo on-site won't trigger the logging (later).
*/
if (!empty($_SERVER['HTTP_REFERER'])) {
	$auto_hotlink['referrer'] = $_SERVER['HTTP_REFERER'];
	$auto_hotlink['ref_domain'] = trim(substr($auto_hotlink['referrer'], strpos($auto_hotlink['referrer'], "/")+2, strpos($auto_hotlink['referrer'], "/", 8)-7), '/');
}
/*
	Splitting the referrer into a domain part, saves us searching for multiple
	variations. So long as your host name appears somewhere in the domain part,
	then it's not a hot-link.
*/




// Is this an Evil Domain??
$auto_hotlink['evil_domains'] = explode(',', $auto_hotlink['evil_domains']);
foreach($auto_hotlink['evil_domains'] as $evil) {
	if (stristr($auto_hotlink['referrer'], trim($evil))) {
		$auto_hotlink['img_type'] = $auto_hotlink['evil_type'];
		$auto_hotlink['import_img'] = $auto_hotlink['evil_image'];
		$auto_hotlink['img_width'] = $auto_hotlink['evil_width'];
		$auto_hotlink['img_height'] = $auto_hotlink['evil_height'];
		$auto_hotlink['bg_color'] = $auto_hotlink['evil_bg_color'];
		$auto_hotlink['hotlink_text'] = $auto_hotlink['evil_text'];
		$auto_hotlink['text_color'] = $auto_hotlink['evil_text_color'];
		$auto_hotlink['text_size'] = $auto_hotlink['evil_text_size'];
		$auto_hotlink['align'] = $auto_hotlink['evil_align'];
		$auto_hotlink['txt_border'] = $auto_hotlink['evil_txt_border'];
		$auto_hotlink['text_y'] = $auto_hotlink['evil_y'];
		$auto_hotlink['compression_level'] = $auto_hotlink['evil_compression_level'];

	}
}


// in case we get a "site" path..
if (!empty($auto_hotlink['import_img']) and file_exists($_SERVER['DOCUMENT_ROOT'].$auto_hotlink['import_img'])) {
	$auto_hotlink['import_img'] = $_SERVER['DOCUMENT_ROOT'].$auto_hotlink['import_img'];
}



// Import an image, if required..
//
if (!empty($auto_hotlink['import_img']) and file_exists($auto_hotlink['import_img'])) {

//	if (end(explode('.', $auto_hotlink['import_img'])) == 'png') {
	if (substr(strrchr($auto_hotlink['import_img'], "."), 1) == 'png') {
		$auto_hotlink['img'] = imagecreatefrompng($auto_hotlink['import_img']);
		imagealphablending($auto_hotlink['img'], true);
		imagesavealpha($auto_hotlink['img'], true);
	} else {
		$auto_hotlink['img'] = imagecreatefromjpeg($auto_hotlink['import_img']);
	}
	$auto_hotlink['img_width'] = imagesx($auto_hotlink['img']);
	$auto_hotlink['img_height'] = imagesy($auto_hotlink['img']);

} else {
	$auto_hotlink['img'] = imagecreate($auto_hotlink['img_width'], $auto_hotlink['img_height']) or die();
}



// prepare the user colors..
//
$auto_hotlink['bg_color'] = hex2dec($auto_hotlink['bg_color']);
$hot_bg_red = $auto_hotlink['bg_color'][0];
$hot_bg_green = $auto_hotlink['bg_color'][1];
$hot_bg_blue = $auto_hotlink['bg_color'][2];

$auto_hotlink['text_color'] = hex2dec($auto_hotlink['text_color']);
$hot_red = $auto_hotlink['text_color'][0];
$hot_green = $auto_hotlink['text_color'][1];
$hot_blue = $auto_hotlink['text_color'][2];

$auto_hotlink['bg_color'] = imagecolorallocate($auto_hotlink['img'], $hot_bg_red, $hot_bg_green, $hot_bg_blue);
$auto_hotlink['text_color'] = imagecolorallocate($auto_hotlink['img'], $hot_red, $hot_green, $hot_blue);


if ($trans_color) {
	imagecolortransparent($auto_hotlink['img'], $auto_hotlink['bg_color']);
}


// Align the text and overlay onto the image..
//
if (!empty($auto_hotlink['hotlink_text'])) {

	$halfway = ($auto_hotlink['img_width'] / 2);

	$chr_width = imagefontwidth($auto_hotlink['text_size']);
	$string_width = strlen($auto_hotlink['hotlink_text']) * $chr_width;

	switch ($auto_hotlink['align']) {
		case 'center':
			$text_x = $halfway - ($string_width / 2);
			break;
		case 'right':
			$text_x = $auto_hotlink['img_width'] - $string_width - $auto_hotlink['txt_border'];
			break;
		case 'left':
			$text_x = $auto_hotlink['txt_border'];
			break;
	}
	imagestring($auto_hotlink['img'], $auto_hotlink['text_size'], $text_x, $auto_hotlink['text_y'], $auto_hotlink['hotlink_text'], $auto_hotlink['text_color']); // size 4 built-in font
}





// send the image to the browser..

if ($auto_hotlink['img_type'] == 'png') {
	if ($auto_hotlink['compression_level'] > 9) { $auto_hotlink['compression_level'] = 9; }
	header('Content-type: image/png');
	imagepng($auto_hotlink['img'], NULL, $auto_hotlink['compression_level']) or die("there was an error. sorree");

} else {
	if ($auto_hotlink['compression_level'] < 10) { $auto_hotlink['compression_level'] *= 10; }
	header('Content-type: image/jpg');
	imagejpeg($auto_hotlink['img'], NULL, $auto_hotlink['compression_level']) or die("there was an error. sorree");
}

imagedestroy($auto_hotlink['img']);




// Log the Hot-link..
//
if (!stristr($auto_hotlink['ref_domain'], $_SERVER['HTTP_HOST'])) {
	$auto_hotlink['hit_data'] =	"\n"
	 .$auto_hotlink['referrer']."\n"
	  ."\t\t".'['.$_SERVER['REMOTE_ADDR'].']'."\t".date('Y.m.d h:i:s A')."\n"
	   ."\t\t".'http://'.$_SERVER['HTTP_HOST'].'/'.$auto_hotlink['url']."\n";
	log_hotlink($auto_hotlink['log_file'], $auto_hotlink['hit_data']);
}





/*



		fin



					*/



/*
	Hex >> Dec

	Converts an HTML #hex colour to decimal colour levels..
															*/
function hex2dec($rgb) {
	if (substr($rgb, 0, 1) == "#") {
		$rgb = substr($rgb, 1);
	}
	$r = hexdec(substr($rgb, 0, 2));
	$g = hexdec(substr($rgb, 2, 2));
	$b = hexdec(substr($rgb, 4, 2));

	return array($r, $g, $b);
}



/*
	Log the Hot-Link
									*/
function log_hotlink($file, $data) {

	if (!file_exists($file)) { $fp = @fopen($file, 'wb'); }
	if (is_writable($file)) {

		$fp = @fopen($file, 'ab');
		if (is_writable($file)) {
		$lock = flock($fp, LOCK_EX);

			if ($lock) {
				fwrite($fp, $data);
				flock ($fp, LOCK_UN);
			}
			fclose($fp);
			clearstatcache();
		}
	}
}





/*
	itstory

		0.5

		*	There is now the capability to use the original image (the one they
			requested) with your hot-link text overlayed.

			Essentially, this turns auto-hotlink into an automatic watermarking
			script.

		0.4.4

		*	Fixed the bug I introduced (0.4.3) in the referer logging.

		0.4.3

		+	Improved Referer (sic) checking.



		Didn't note changes prior to this.

*/

?>