#!/usr/bin/perl
# Inserts XMMS InfoPipe information to the web page...
# Intended to be used with SSI or something. Will return a HTML fragment.
# Needs Apache and mod_perl.
# By Weyfour WWWWolf, 2000-12-10
#
# Example configuration for .htaccess:
#
# <files "xmms-info.pl">
#   PerlSetVar PipeFile "/tmp/xmms-info_wwwwolf.0"
# </files>
#
# Requirements:
#  - If you use .ogg files, you need "ogginfo" utility
#    (part of vorbis-tools)
#  - You need MP3::Info to extract information from MP3 files.
#
# $Id: xmms-info.pl,v 1.5 2002/04/02 20:54:12 wwwwolf Exp $

use strict;
use warnings;

use CGI qw(:standard);
use Apache::Constants qw(:common);
use File::Basename qw(basename);

our ($tune, $time, $status, $file, $metainfo);

#######################################################################

sub htmlescape {
  my $string = shift;

  $string =~ s/&/&amp;/gi;
  $string =~ s/</&lt;/gi;
  $string =~ s/>/&gt;/gi;

  return $string;
}


#######################################################################

# Apache request
my $r = Apache->request;

# Get the pipe file name.
my $pipefile =
  $r->dir_config('PipeFile') ||
  "/tmp/xmms-info";

# Open the information. If file cannot be read, we just silently quit...
open(INFO,$pipefile) or do {
  print header();
  exit(0);
};

# Parse information from the
while(<INFO>) {
  chomp;
  if(/^Title: (.*)$/) {
    $tune = htmlescape($1);
  }
  if(/^Position: (.*)$/) {
    $time = htmlescape($1);
  }
  if(/^Status: (.*)$/) {
    $status = $1;
  }
  if(/^File: (.*)$/) {
    $file = htmlescape($1);
  }
}

# Close infopipe.
close INFO;

# Print headers.
print header();

# If stopped, we mention nothing.
exit unless ($status ne 'Stopped');

# Is the file readable? If not, skip all this crap...
do {
  $metainfo = $tune;
  goto SAYIT;
} unless (-r $file);

# Get some metainfo...
if($file =~ /\.ogg/i) {             # Ogg Vorbis
  eval { # Hope this works...

    # Preferred metainfo format:
    # <strong>Title</strong> (Artist: <i>Album</i>)
    # [Stereo 44.1khz (lll/nnn/uuu kbps, avg. xxxkbps)]

    open(METAINF, "ogginfo '$file'|") or die;

    my($infoline, %ogginfo);
    while($infoline = <METAINF>) {
      chomp $infoline;
      next if($infoline !~ '=');
      my @info = split(/=/, $infoline, 2);
      my $key = shift @info;
      my $val = shift @info;
      $ogginfo{$key} = $val;
    }

    $metainfo = "<strong>" . $ogginfo{'title'} . "</strong> ";
    # Make the artist-album-thing so that it looks nice.
    if($ogginfo{'artist'}) {
      if($ogginfo{'album'}) {   # (Artist: Album)
	$metainfo .= "(" . $ogginfo{'artist'} . ": <i>"
	  . $ogginfo{'album'}
	  . "</i>) ";
      } else {                 # (Artist)
	$metainfo .= "(" . $ogginfo{'artist'} . ") ";
      }
    } else {
      if($ogginfo{'album'}) {   # (Album)
	$metainfo .= "(<i>" . $ogginfo{'artist'} . "</i>) ";
      }
    }

    # Do we NOT have a title (some files regrettably have no tags)?
    if($metainfo =~ m{<strong>\s*</strong>}) {
      # If so, let's just use the file name...
      $metainfo = "<strong>" . ucfirst(basename($file, ".ogg")) . "</strong> ";
    }

    # Technical song information.
    $metainfo .= "[";
    if($ogginfo{'channels'} == 2) { # Stereo/Mono
      $metainfo .= "Stereo ";
    } elsif($ogginfo{'channels'} == 2) {
      $metainfo .= "Mono ";
    } else {
      $metainfo .= $ogginfo{'channels'}."ch ";
    }
    $metainfo .= sprintf("%.1f",$ogginfo{'rate'}/1000) . "khz "; # Sample rate

    # Bitrates
    $metainfo .= "(" .
      ($ogginfo{'bitrate_lower'} ne 'none'
       ? sprintf("%.1f",$ogginfo{'bitrate_lower'}/1000) : "none")
	. "/" .
      ($ogginfo{'bitrate_nominal'} ne 'none'
       ? sprintf("%.1f",$ogginfo{'bitrate_nominal'}/1000) : "none")
	. "/" .
      ($ogginfo{'bitrate_upper'} ne 'none'
       ? sprintf("%.1f",$ogginfo{'bitrate_upper'}/1000) : "none")
	. " kbps, avg. " . sprintf("%.1f",$ogginfo{'bitrate_average'}/1000)
	. "kbps)";

    $metainfo .= "]";


    close METAINF;

  };
  if($@) { # Errors?
    $metainfo = $tune;
  }

} elsif($file =~ /\.mp3/i) {        # MPEG

  # Preferred Metainfo format:

  # <strong>Title</strong> (Performer: <i>Album</i>)
  # [Mono 11.2KHz VBR(~2 kbps)]

  eval { # Wrapped in eval, in case you don't have MP3::Info or something...
    use MP3::Info;

    my $mp3tag = get_mp3tag($file);
    my $mp3info = get_mp3info($file);

    $metainfo = "<strong>" . $mp3tag->{TITLE} . "</strong> ";

    # Make the artist-album-thing so that it looks nice.
    if($mp3tag->{ARTIST}) {
      if($mp3tag->{ALBUM}) {   # (Artist: Album)
	$metainfo .= "(" . $mp3tag->{ARTIST} . ": <i>"
	  . $mp3tag->{ALBUM}
	  . "</i>) ";
      } else {                 # (Artist)
	$metainfo .= "(" . $mp3tag->{ARTIST} . ") ";
      }
    } else {
      if($mp3tag->{ALBUM}) {   # (Album)
	$metainfo .= "(<i>" . $mp3tag->{ALBUM} . "</i>) ";
      }
    }

    # Do we NOT have a title (some files regrettably have no tags)?
    if($metainfo =~ m{<strong>\s*</strong>}) {
      # If so, let's just use the file name...
      $metainfo = "<strong>" . ucfirst(basename($file, ".mp3")) . "</strong> ";
    }


    # Technical song information.
    $metainfo .= "[";
    if($mp3info->{STEREO}) { # Stereo/Mono
      $metainfo .= "Stereo ";
    } else {
      $metainfo .= "Mono ";
    }
    $metainfo .= $mp3info->{FREQUENCY} . "khz "; # Sample rate
    if($mp3info->{VBR}) { # VBR/CBR
      $metainfo .= "VBR (~" . $mp3info->{BITRATE} . "kbps)";
    } else {
      $metainfo .= "CBR (" . $mp3info->{BITRATE} . "kbps)";
    }

    $metainfo .= "]";
  };
  if($@) { # Errors?
    $metainfo = $tune;
  }
} else {                            # No idea...
  $metainfo = $tune;
}

SAYIT:

# Otherwise, say the things.
print
  "<p>Currently XMMS is playing song: $metainfo,\n",
  "at position <strong>$time</strong>.</p>\n";
